
(function () {
    const PLATFORM = "tiwistter"
    const E = {
        ping: "X-Ping",
        fromPlatform: 'honey extensions',
        getUserName: "Get-User-Name",
        getViewers: "Get-Viewers",
        getLiveState: "Get-Living-State",
        sendChatMessage: "Send-Message",
        intercept: "honey-intercept",
        websocketMessage: "X-WebSocket-Message",
        fecthMessage: "X-Fetch-Message",
        xhrMessage: "X-XHR-Message",
        domLoaded: "X-Page-DOMContentLoaded",
        pageClosed: "X-Page-Close",
        room: "room",
        from: "vibeconnect-extension",
        chatEvent: "Chat-Event",
        viewerCache: `$cached.camsoda.viewers`,
        privateMessage: "Send-Private-Message",
        getStreamSetting: "Get-Stream-Settings",
        syncTipmenu: "Sync-TipMenu-Platform",
        syncTipmenuCallback: "Sync-TipMenu-Platform-Callback",
        sdk: "VC-SDK",
        clientLoginState: "Client-Login-State",
    }
    let channel = null;
    Array.prototype.any = function (fn) {
        if (typeof fn !== "function") {
            for (var item of this) {
                if (fn == item) {
                    return true;
                }
            }
            return false;
        }
        for (var item of this) {
            if (fn.call(this, item)) {
                return true;
            }
        }
        return false;
    }
    function storage(key, value) {
        if (arguments.length < 2) {
            return localStorage.getItem(key)
        } else {
            if (value == undefined) {
                return localStorage.removeItem(value)
            }
            if (typeof value == "object") {
                value = JSON.stringify(value)
            }
            return localStorage.setItem(key, value)
        }
    }
    const tryJson = (raw) => {
        try {
            return JSON.parse(raw);
        } catch (e) {
            return;
        }
    }
    const randomChar = (length) => {
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        let result = '';
        for (let i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * characters.length));
        }
        return result;
    }
    function sleep(time) {
        return new Promise((res) => {
            setTimeout(() => {
                res();
            }, time || 10);
        })
    }


    const postMsg = (type, data) => {
        return new Promise((res) => {
            chrome.runtime.sendMessage({
                platform: PLATFORM,
                type,
                data: data
            }, (resp) => {
                if (chrome.runtime.lastError) {
                    // console.error("postMsg Error:", type, chrome.runtime.lastError);
                } else {

                    res(resp)
                }
            });
        })
    }

    const convertGender = (g) => {
        if (g == "m") {
            return 0;
        }
        if (g == "f") {
            return 1;
        }
        return -1;
    }
    function onChannelMessage(type, data) {
        try {
            if (type == E.websocketMessage) {
                const { url } = data.data;
                if (/wss:\/\/node2-ord.livemediahost.com:/i.test(url)) {
                    var cdata = data.data.data;
                    var msg = typeof cdata.responseData === "string" ? JSON.parse(cdata.responseData) : cdata.responseData;



                    //新用户进入
                    if (msg[0] == 37) {
                        var userEvtData = msg[3][0];
                        var usercache = storage(E.viewerCache);
                        usercache = tryJson(usercache == -1 ? null : usercache) || [];
                        usercache.push({
                            username: userEvtData[1][0],
                            colour: "",
                            gender: convertGender(userEvtData[1][1]),
                            type: "",
                            colorStr: "",
                            id: userEvtData[2].id,
                            isNewAccount: null,
                            isSubsriber: userEvtData[2].is_fans_subsriber,
                            in_fan_club: null,
                            isMod: userEvtData[2].is_model_admin,
                            raw: JSON.stringify(userEvtData)
                        });

                        storage(E.viewerCache, usercache || [])
                    }
                    //用户离开
                    else if (msg[0] == 38) {
                        var usercache = storage(E.viewerCache);
                        usercache = tryJson(usercache == -1 ? null : usercache) || [];
                        var userEvtData = msg[3][0];
                        var id = userEvtData[2].id;
                        var index = usercache.findIndex(el => {
                            return el.id == id;
                        });
                        usercache.split(index, 1);
                        storage(E.viewerCache, usercache || [])
                    }
                    else if (msg[0] == 29) {
                        //缓存的用户
                        var users = msg[3][1];
                        var usercache = [];
                        users.map(el => {
                            usercache.push({
                                username: el[1][0],
                                colour: "",
                                gender: convertGender(el[1][1]),
                                type: "",
                                colorStr: "",
                                id: el[2].id,
                                isNewAccount: null,
                                isSubsriber: el[2].is_fans_subsriber,
                                in_fan_club: null,
                                isMod: el[2].is_model_admin,
                                raw: JSON.stringify(el)
                            });
                        })
                        storage(E.viewerCache, usercache || [])
                    }
                    else if (msg[0] == 2) {
                        var userinfo = msg[3][1];
                        Adapter.userInfo = userinfo;
                    } else if (msg[0] == 6) {
                        //获取room的ws路径
                        Adapter.chatWebsocket = msg[1].url;
                    }
                }
            }
        } catch (ex) {
            console.error("ex", ex)
        }
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, data);
        }
    }
    const getJson = (d) => {
        if (d.responseType == "text") {
            return tryJson(d.responseData)
        } else if (d.responseType == "json") {
            return d.responseData;
        }
        return;
    }
    function getParams(req) {
        if ((req.method || "").toLowerCase() == "post") {
            return tryJson(req.body)
        } else {

        }
    }
    function onFetchMessage(type, req) {
        const { data } = req;
        try {
            const url = data.url, d = data.data;
        } catch (ex) {

        }
    }

    function onChannelInit() {
        if (!Adapter.isNormal()) {
            Adapter.init(channel);
        }
    }
    window.addEventListener("message", function (t, a) {
        const data = t.data;
        const { from, type } = data;

        if (from == E.intercept) {
            if (type == E.websocketMessage || type == E.xhrMessage) {
                onChannelMessage(type, data)
            }
            else if (type == E.fecthMessage) {
                onFetchMessage(type, data)
            }
            else if (type == E.domLoaded) {
                chrome.runtime.onConnect.addListener((port) => {
                    if (port.name == E.room) {
                        channel = port;
                        onChannelInit(channel);
                    }
                });
                storage(E.viewerCache, -1);
                postMsg(E.domLoaded, {})
            }
            else if (type == E.pageClosed) {
                postMsg(E.pageClosed, {})
            }
        }
        else if (from == E.sdk) {
            switch (type) {
                case "getExtStatus":
                    Adapter.SDK = true;
                    Adapter.initSDK(data);
                    break;
                case "settings":
                    Adapter.getSettings(data);
                    break;
                case "camVersion":
                    Adapter.SDK = true;
                    Adapter.getCamVersion(data);
                    break;
                case "toyStatus":
                    Adapter.getToyStatus(data);
                    break;
                case "tip":
                case "userEnter":
                case "userLeave":
                case "follow":
                case "chatPM":
                case "unfollow":
                case "chat":
                case "broadcastState":
                case "reportOnlineUser":
                    Adapter.receiveSDKEvent(type, data);
                    break;
            }
        }
    });


    //tipmenu
    const TipMenu = function () {
        async function sendTips() {
            var index = 0;
            Adapter.instance.sendChatMessage(`----->HoneyPlayBox Toys respond to tips. Here are my levels:`)
            for (var preset of tipMenu.presets) {
                index = index + 1;
                await sleep(200);
                Adapter.instance.sendChatMessage(`----->#${index} ${preset.name} = ${preset.token} Tokens`)
            }
        }
        async function asyncTipRun(params) {


            const r = await postMsg("Fetch-Data", {
                url: "@server/system/tipMenu/selectTipMenuDetailList/forplatform/" + PLATFORM,
                body: {}
            })
            if (!r.success) {
                return;
            }
            var d = r.data;
            if (!d || d.code != 1000) {
                return;
            }
            d = d.data ? d.data[0] : null
            if (!d || !d.enable) {
                tipMenu.active = false;
                return;
            }
            tipMenu.active = d.enable;
            tipMenu.presets = (d.tipMenuPresetDetailList || []).map(el => {
                return {
                    name: el.activityName,
                    token: el.token,
                }
            });
            sendTips();
        }
        class tipMenu {
            static presets = []
            static active = ""
            static timer = 0;
            static duration = 5
            static run(preset, active, config) {
                tipMenu.presets = preset;
                tipMenu.active = active;
                if (config) {
                    tipMenu.duration = config.duration;
                }
                sendTips();
            }
            static start() {
                if (tipMenu.timer) {
                    return
                }
                setTimeout(async () => {
                    await asyncTipRun();
                    tipMenu.timer = setInterval(async () => {
                        await asyncTipRun();
                    }, (this.duration || 5) * 60 * 1000)
                }, 5000)
            }
        }
        return tipMenu;
    }();

    //PM manager
    const PM = function () {
        class PM {
            static cached = {}
            static async getPMToken(username) {
                if (PM.cached[username]) {
                    return PM.cached[username].token;
                }
                const resp = await fetch(`/api/v1/pm/room/${username}`, {
                    method: "get",
                    mode: "cors",
                    cache: "no-cache",
                    credentials: "same-origin",
                    headers: {
                    },
                    redirect: "follow",
                    referrerPolicy: "strict-origin-when-cross-origin",
                });
                var json = await resp.json();
                if (json.token) {
                    PM.cached[username] = {
                        room: json.roomName,
                        friendStatus: json.friendStatus,
                        token: json.token,
                        user: json.user,
                    }
                }
                return PM.cached[username].token;
            }
            static async send(message, username) {
                var token = await this.getPMToken(username);
                const pd = {
                    token: token,
                    message: message,
                }
                const resp = await fetch(`/api/v1/pm/room/${username}/message`, {
                    method: "post",
                    mode: "cors",
                    cache: "no-cache",
                    credentials: "same-origin",
                    headers: {
                        "content-type": "application/json"
                    },
                    redirect: "follow",
                    referrerPolicy: "strict-origin-when-cross-origin",
                    body: JSON.stringify(pd),
                });
                var json = await resp.json();
                return { success: resp.status == 200, }
            }
        }
        return PM;
    }();



    class Adapter {
        static callback(requestId, data, err = null) {
            window.postMessage({
                requestId,
                data: data,
                type: "async-callback",
                from: E.from,
                error: err,
            }, location.href)
        }
        static async initSDK(data) {
            const { platform, url, requestId } = data;
            try {
                setTimeout(() => {
                    window.postMessage({
                        data: {
                            platform: PLATFORM,
                            version: Adapter.version
                        },
                        type: "init",
                        from: E.from,
                    })
                    //通知平台状态
                    window.postMessage({
                        data: {
                            platform: PLATFORM,
                            state: platform == PLATFORM
                        },
                        type: "platform-state",
                        from: E.from,
                    })
                }, 100);
                setTimeout(async () => {
                    var r = await postMsg(E.clientLoginState, {})
                    if (r.success) {
                        window.postMessage({
                            data: {
                                platform: PLATFORM,
                                login: r.data.login
                            },
                            type: "login-state",
                            from: E.from,
                        })
                    }
                })
            } catch (e) {

            }
            if (data.platform != PLATFORM) {
                return this.callback(requestId, { success: false }, "The source platform is not supported");
            } else {
                var r = await postMsg("Get-Ext-Status", {})
                if (r.success) {
                    return this.callback(requestId, {
                        login: r.data.login,
                        version: r.data.version,
                    })
                }
            }
        }
        static async receiveSDKEvent(type, data) {
            var pd = null
            switch (type) {
                case "tip":
                    pd = {
                        type,
                        platform: data.platform,

                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            },
                            tip: {
                                tokens: data.tip?.amount,
                                is_anon: !!data.tip?.is_anon,
                                message: data.message?.message || null,
                            }
                        }
                    }
                    break;
                case "follow":
                    pd = {
                        type: "follow",
                        platform: data.platform,
                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            }
                        }
                    }
                    break;
                case "unfollow":
                    pd = {
                        type: "unfollow",
                        platform: data.platform,
                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            }
                        }
                    }
                    break;
                case "userEnter":
                    pd = {
                        type: "user_enter",
                        platform: data.platform,
                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            }
                        }
                    }
                    break;
                case "userLeave":
                    pd = {
                        type: "user_leave",
                        platform: data.platform,
                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            }
                        }
                    }
                    break;
                case "chat":
                    pd = {
                        type: "chat_message",
                        platform: data.platform,
                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            },
                            message: {
                                color: data.extra?.message?.color, //字体颜色
                                "bg_color": data.extra?.message?.bg_color, //背景颜色
                                "message": data.message.message, //聊天消息
                                "font": data.extra?.message?.font //字体大小
                            }
                        }
                    }
                    break;
                case "chatPM":
                    pd = {
                        type: "private_message",
                        platform: data.platform,
                        data: {
                            broadcaster: data.broadcaster,
                            user: {
                                username: data.fromUser,
                                in_fan_club: data.extra?.in_fan_club,
                                gender: data.extra?.gender,
                                has_token: data.extra?.has_token,
                                recent_tips: data.extra?.recent_tips,
                                is_mod: data.extra?.is_mod,
                            },
                            message: {
                                color: data.extra?.message?.color, //字体颜色
                                "bg_color": data.extra?.message?.bg_color, //背景颜色
                                "message": data.message.message, //聊天消息
                                "font": data.extra?.message?.font //字体大小
                            }
                        }
                    }
                    break;
                case "broadcastState":
                    pd = {
                        type: data.living ? "broadcast_start" : "broadcast_stop",
                        platform: data.platform,
                        data: null
                    }
                    if (data.living) {
                        Adapter.isLiving = true;
                    } else {
                        Adapter.isLiving = false;
                    }
                    break;
            }

            if (pd) {
                pd._raw = data;
                pd._extra = data.extra;
                Adapter.instance.post("SDK-Event", { data: pd });
            }
        }

        static async getSettings() {

            const { platform, url, requestId } = data;
            const toyStatus = await postMsg("Get-Settings", {});
            if (!toyStatus.success) {
                return this.callback(requestId, { success: false }, "The source platform is not supported");
            } else {
                return this.callback(requestId, { success: true, ...toyStatus });
            }
        }

        static async getCamVersion(data) {
            const { platform, url, requestId } = data;
            return this.callback(requestId, Adapter.version);
        }
        static async getToyStatus(data) {
            const { platform, url, requestId } = data;
            const toyStatus = await postMsg("Get-Toys", {});
            if (!toyStatus.success) {
                return this.callback(requestId, { success: false }, "The source platform is not supported");
            } else {
                return this.callback(requestId, (toyStatus.data||[]).map((el)=>{
                    return {
                        name:el.name,
                        battery:el.battery,
                        icon:el.icon_url,
                        id:uuid,
                        connected:el.in_use
                    }
                }));
            }
        }
        getCookie(cookieName) {
            var cookieValue = "";
            if (document.cookie) {
                var cookies = document.cookie.split(';');
                for (var i = 0; i < cookies.length; i++) {
                    var cookie = cookies[i];
                    if (cookie.substring(0, cookieName.length + 2).trim() == cookieName.trim() + "=") {
                        cookieValue = cookie.substring(cookieName.length + 2, cookie.length);
                        return cookieValue;
                    }
                }
            }
            return cookieValue;
        }
        async getUserList() {
            var j = storage(E.viewerCache);
            if (j == -1) {
                return []
            }
            if (!j) {
                return []
            }
            var list = (tryJson(j) || [])
            return {
                count: list.length,
                usersList: list,
            }
        }
        getUsername() {
            return Adapter.userInfo?.username || "";
        }
        getLiveState() {
            if (Adapter.isLiving) {
                return "live";
            }
            return "close";
        }
        listen() {
            chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
                const { platform, type } = request;
                if (!platform || platform != E.fromPlatform) {
                    sendResponse({
                        success: false,
                    })
                    return false;
                }
                if (type == E.authToken) {
                    var token = Adapter.instance.getToken();
                    return sendResponse({
                        success: true,
                        data: token
                    })
                }
                if (type == E.getUserName) {
                    var username = Adapter.instance.getUsername();
                    return sendResponse({
                        success: true,
                        username: username
                    })
                }
                else if (type == E.getViewers) {
                    Adapter.instance.getUserList().then(res => {
                        sendResponse({
                            success: true,
                            data: res,
                        })
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                } else if (type == E.getLiveState) {
                    return sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                } else if (type == E.sendChatMessage) {
                    Adapter.instance.sendChatMessage(request.message).then(res => {
                        sendResponse(res)
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                } else if (type == E.privateMessage) {
                    Adapter.instance.sendPrivateMessage(request.message, request.info?.username).then(res => {
                        sendResponse(res)
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                } else if (type == E.getStreamSetting) {
                    Adapter.instance.getStreamSetting().then(res => {
                        sendResponse(res)
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                }
                return true
            });
        }
        async getStreamSetting() {
            var serverEl = document.querySelectorAll(".input-copy-module__wrapper--omLwl input.input-copy-module__input--bokp1")
            if (serverEl.length > 0) {
                return {
                    success: true,
                    data: {
                        username: this.getUsername(),
                        server: serverEl[0]?.value,
                        key: serverEl[1]?.value
                    }
                }
            } else {
                return {
                    success: false,
                    data: {
                        code: 404
                    }
                }
            }
        }
        async sendChatMessage(message) {
            try {
                if (!Adapter.chatWebsocket) {
                    return { success: false, error: 'send error' };
                }
                window.dispatchEvent(new CustomEvent("Honey-Websocket-Upload", {
                    detail: JSON.stringify({
                        websocket: !Adapter.chatWebsocket.endsWith('/') ? (Adapter.chatWebsocket + "/") : Adapter.chatWebsocket,
                        data: [27, { "color": "#333" }, 32771, [message, this.getUsername(), "en"]]
                    })
                }))
                return Promise.resolve({ success: true, error: 'send error' });
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return  Promise.resolve({ success: false, error: 'send error' });
            }
        }
        async sendPrivateMessage(message, username) {
            try {
                return PM.send(message, username);
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        getToken() {
            return this.getCookie("XSRF-TOKEN");
        }
        getId() {
            return Adapter.userInfo?.id || "";
        }
        _ping(isFirst) {
            let liveState = this.getLiveState();
            this.post(E.ping, {
                url: location.href,
                token: this.getToken(),
                id: this.getId(),
                state: liveState,
                isFirst: isFirst,
                platform: PLATFORM,
                username: this.getUsername(),
                email: "",
            })
        }
        post(type, data) {
            if (channel)
                channel.postMessage({
                    ...data,
                    type,
                })
        }
        ping() {
            this._ping(true)
            setInterval(() => {
                this._ping(false)
            }, 5 * 1000)
        }
        syncTipMenu(data) {
            data.active = data.active || "preset1";
            var presets = data.preset;
            var enable = data.enable;
            if (!enable) {
                return;
            }
            TipMenu.run(presets, data.active, data.config);
            return { success: true }
        }
        static instance;
        static init(port) {
            channel = port;
            Adapter.instance = new Adapter();
            Adapter.instance.ping();
            Adapter.instance.listen();
            channel.onMessage.addListener(async (request) => {
                const { data, type } = request;
                if (type == "version") {
                    Adapter.version = data;
                }
                else if (type == E.syncTipmenu) {
                    var r = await Adapter.instance.syncTipMenu(data);
                    if (r) {
                        Adapter.instance.post(E.syncTipmenuCallback, {
                            status: r.success,
                            data: {
                                success: r.success,
                                data: r.data
                            }
                        })
                    }
                }
                else if (type == "sdk-toy") {
                    window.postMessage({
                        type: "toy",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-reacting") {
                    window.postMessage({
                        type: "reacting",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-queue") {
                    window.postMessage({
                        type: "queue",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-settings") {
                    window.postMessage({
                        type: "settings",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-message") {
                    window.postMessage({
                        type: "postMessage",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-vibeWithMeEnable") {
                    window.postMessage({
                        type: "vibeWithMeEnable",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-vibeWithMeTip") {
                    window.postMessage({
                        type: "vibeWithMeTip",
                        data: data,
                        from: "vibe-connect"
                    })
                }
                else if (type == "sdk-vibeWithMeCustomer") {
                    window.postMessage({
                        type: "vibeWithMeCustomer",
                        data: data,
                        from: "vibe-connect"
                    })
                }
            })
            channel.onDisconnect.addListener(() => {
                channel = null;
            })
            TipMenu.start();
        }
        static isNormal() {
            return !!Adapter.instance;
        }
    }
})()