
(function () {
    const PLATFORM = "myfreecams"
    const E = {
        ping: "X-Ping",
        fromPlatform: 'honey extensions',
        getUserName: "Get-User-Name",
        getViewers: "Get-Viewers",
        getLiveState: "Get-Living-State",
        sendChatMessage: "Send-Message",
        intercept: "honey-intercept",
        websocketMessage: "X-WebSocket-Message",
        fecthMessage: "X-Fetch-Message",
        xhrMessage: "X-XHR-Message",
        xworker: "X-Worker-Message",
        domLoaded: "X-Page-DOMContentLoaded",
        pageClosed: "X-Page-Close",
        room: "room",
        chatEvent: "Chat-Event",
        viewerCache: `$cached.myfreecams.viewers`,
        privateMessage: "Send-Private-Message",
        getStreamSetting: "Get-Stream-Settings",
        syncTipmenu: "Sync-TipMenu-Platform",
        syncTipmenuCallback: "Sync-TipMenu-Platform-Callback"

    }
    let channel = null;
    Array.prototype.any = function (fn) {
        if (typeof fn !== "function") {
            for (var item of this) {
                if (fn == item) {
                    return true;
                }
            }
            return false;
        }
        for (var item of this) {
            if (fn.call(this, item)) {
                return true;
            }
        }
        return false;
    }
    function sleep(time) {
        return new Promise((res) => {
            setTimeout(() => {
                res();
            }, time || 10);
        })
    }
    function storage(key, value) {
        if (arguments.length < 2) {
            return localStorage.getItem(key)
        } else {
            if (value == undefined) {
                return localStorage.removeItem(value)
            }
            if (typeof value == "object") {
                value = JSON.stringify(value)
            }
            return localStorage.setItem(key, value)
        }
    }
    const tryJson = (raw) => {
        try {
            return JSON.parse(raw);
        } catch (e) {
            return;
        }
    }
    const randomChar = (length) => {
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        let result = '';
        for (let i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * characters.length));
        }
        return result;
    }

    const postMsg = (type, data) => {
        return new Promise((res) => {
            chrome.runtime.sendMessage({
                platform: PLATFORM,
                type,
                data: data
            }, (resp) => {
                if (chrome.runtime.lastError) {
                    // console.error("postMsg Error:", type, chrome.runtime.lastError);
                } else {

                    res(resp)
                }
            });
        })
    }

    function onChannelMessage(type, data) {
        try {
            if (type == E.websocketMessage) {
            }
        } catch (ex) {
            console.error("ex", ex)
        }
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, data);
        }
    }
    const getJson = (d) => {
        if (d.responseType == "text") {
            return tryJson(d.responseData)
        } else if (d.responseType == "json") {
            return d.responseData;
        }
        return;
    }
    function getParams(req) {
        if ((req.method || "").toLowerCase() == "post") {
            return tryJson(req.body)
        } else {

        }
    }
    function onFetchMessage(type, req) {

        if (Adapter.isNormal()) {
            Adapter.instance.post(type, req);
        }
    }
    function onWorkerMessage(type, req) {
        try {
            const { url } = req.data;
            if (/wsw.js/i.test(url)) {
                var cdata = req.data.data;
                var packraw = cdata.responseData || "";
                var pack = JSON.parse(packraw);
                if (!pack[0] || !/onpacket/i.test(pack[0])) {
                    return
                }
                var msg = pack[1]
                var pattern = msg.split(/\s+/);
                var type_id = pattern[0].length > 6 ? pattern[0].substring(6) : pattern[0];

                if (type_id == 1) {
                    Adapter.token = pattern[pattern.length - 2].replace("::", "");
                }
                else if (type_id == 14) {
                    var encodeData = pattern[pattern.length - 1];
                    if (encodeData) {
                        encodeData = decodeURIComponent(encodeData);
                    }
                    if (encodeData) {
                        encodeData = tryJson(encodeData);
                        if (typeof encodeData != "object") {
                            return;
                        }

                        Adapter.chatroomId = encodeData.channel;

                        if (encodeData.rdata && pattern[pattern.length - 2] == "22") {

                            var users = [];
                            // var field = encodeData.rdata[0];
                            for (var i = 1; i < encodeData.rdata.length; i++) {
                                if (encodeData.rdata[i]) {
                                    if (Adapter.instance.isBroadcaster(encodeData.rdata[i][1])) {
                                        continue;
                                    }
                                    var u = {
                                        username: encodeData.rdata[i][1],
                                        colour: "",
                                        gender: null,
                                        type: "",
                                        colorStr: "",
                                        id: encodeData.rdata[i][3],
                                        sessionId: encodeData.rdata[i][2],
                                        isNewAccount: null,
                                        isSubsriber: null,
                                        in_fan_club: null,
                                        isMod: null,
                                        raw: JSON.stringify(encodeData.rdata[i])
                                    };
                                    users.push(u)
                                }
                            }
                            storage(E.viewerCache, users || [])
                        }
                    }
                }
                //自己的用户信息
                else if (type_id == 5) {
                    var encodeData = pattern[pattern.length - 1];
                    if (encodeData) {
                        encodeData = decodeURIComponent(encodeData);
                    }
                    if (encodeData) {
                        encodeData = tryJson(encodeData);
                        if (typeof encodeData != "object") {
                            return;
                        }
                    }
                    Adapter.user = {
                        info: encodeData,
                        username: encodeData.nm,
                        level: encodeData.lv,
                        id: encodeData.uid,
                        sessionId: encodeData.sid,
                        age: encodeData.u?.age,
                        country: encodeData.u?.country,
                    }
                }
                //用户进入跟退出
                else if (type_id == 51) {
                    if (!Adapter.viewer) {
                        Adapter.viewer = {}
                    }
                    var usercache = storage(E.viewerCache);
                    usercache = tryJson(usercache == -1 ? null : usercache) || [];
                    //用户进入
                    if (pattern[5] == 1) {
                        var encodeData = pattern[pattern.length - 1];
                        if (encodeData) {
                            encodeData = decodeURIComponent(encodeData);
                        }
                        if (encodeData) {
                            encodeData = tryJson(encodeData);
                            if (typeof encodeData != "object") {
                                return;
                            }
                        }

                        if (Adapter.instance.isBroadcaster(encodeData.nm)) {
                            return;
                        }
                        var user = {
                            username: encodeData.nm,
                            colour: "",
                            gender: null,
                            type: "",
                            colorStr: "",
                            id: encodeData.uid,
                            sessionId: encodeData.sid,
                            isNewAccount: null,
                            isSubsriber: null,
                            in_fan_club: null,
                            isMod: null,
                            raw: JSON.stringify(encodeData)
                        };
                        Adapter.viewer[pattern[2]] = user;
                        usercache.push(user)
                    }
                    else if (pattern[5] == 2) {
                        var user = Adapter.viewer[pattern[2]]
                        delete Adapter.viewer[pattern[2]];
                        var index = usercache.findIndex(el => {
                            return el.id == id;
                        });
                        usercache.split(index, 1);
                    }
                    storage(E.viewerCache, usercache || [])
                }
            }

        } catch (ex) {

        }
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, req);
        }
    }

    function onChannelInit() {
        if (!Adapter.isNormal()) {
            Adapter.init(channel);
        }
    }
    window.addEventListener("message", function (t, a) {
        const data = t.data;
        const { from, type } = data;

        if (from == E.intercept) {
            if (type == E.websocketMessage || type == E.xhrMessage) {
                onChannelMessage(type, data)
            }
            else if (type == E.xworker) {
                onWorkerMessage(type, data);
            }
            else if (type == E.fecthMessage) {
                onFetchMessage(type, data)
            }
            else if (type == E.fecthMessage) {
                onFetchMessage(type, data)
            }
            else if (type == E.domLoaded) {
                chrome.runtime.onConnect.addListener((port) => {
                    if (port.name == E.room) {
                        channel = port;
                        onChannelInit(channel);
                    }
                });
                storage(E.viewerCache, -1);
                postMsg(E.domLoaded, {})
            }
            else if (type == E.pageClosed) {
                postMsg(E.pageClosed, {})
            }
        }
    });


    //tipmenu
    const TipMenu = function () {
        async function sendTips() {
            var index = 0;
            Adapter.instance.sendChatMessage(`----->HoneyPlayBox Toys respond to tips. Here are my levels:`)
            for (var preset of tipMenu.presets) {
                index = index + 1;
                await sleep(200);
                Adapter.instance.sendChatMessage(`----->#${index} ${preset.name} = ${preset.token} Tokens`)
            }
        }
        async function asyncTipRun(params) {


            const r = await postMsg("Fetch-Data", {
                url: "@server/system/tipMenu/selectTipMenuDetailList/forplatform/" + PLATFORM,
                body: {}
            })
            if (!r.success) {
                return;
            }
            var d = r.data;
            if (!d || d.code != 1000) {
                return;
            }
            d = d.data ? d.data[0] : null
            if (!d || !d.enable) {
                tipMenu.active = false;
                return;
            }
            tipMenu.active = d.enable;
            tipMenu.presets = (d.tipMenuPresetDetailList || []).map(el => {
                return {
                    name: el.activityName,
                    token: el.token,
                }
            });
            sendTips();
        }
        class tipMenu {
            static presets = []
            static active = ""
            static timer = 0;
            static duration = 5
            static run(preset, active, config) {
                tipMenu.presets = preset;
                tipMenu.active = active;
                if (config) {
                    tipMenu.duration = config.duration;
                }
                sendTips();
            }
            static start() {
                if (tipMenu.timer) {
                    return
                }
                setTimeout(async () => {
                    await asyncTipRun();
                    tipMenu.timer = setInterval(async () => {
                        await asyncTipRun();
                    }, (this.duration || 5) * 60 * 1000)
                }, 5000)
            }
        }
        return tipMenu;
    }();

    class Adapter {
        getCookie(cookieName) {
            var cookieValue = "";
            if (document.cookie) {
                var cookies = document.cookie.split(';');
                for (var i = 0; i < cookies.length; i++) {
                    var cookie = cookies[i];
                    if (cookie.substring(0, cookieName.length + 2).trim() == cookieName.trim() + "=") {
                        cookieValue = cookie.substring(cookieName.length + 2, cookie.length);
                        return cookieValue;
                    }
                }
            }
            return cookieValue;
        }
        async getUserList() {
            var j = storage(E.viewerCache);
            if (!j || j == -1) {
                return []
            }
            var list = (tryJson(j) || []).map(el => {
                return {
                    username: el.username,
                    colour: "",
                    gender: -1,
                    type: "",
                    colorStr: "",
                    id: el.id,
                    isNewAccount: el.isNewAccount,
                    in_fan_club: el.fanClubTier,
                    isSubsriber: el.hasFavorited,
                    isMod: el.isAdmin,
                    raw: JSON.stringify(el)
                }
            })
            return {
                count: list.length,
                usersList: list,
            }
        }
        isBroadcaster(username) {
            return this.getUsername() == username;
        }
        getUsername() {
            return Adapter.user?.username || "";
        }
        getLiveState() {
            if (!channel) {
                return "unknow"
            }
            var ele = document.querySelector("#myfreecams")
            if (ele && (ele.innerHTML || "").trim().toLowerCase() == "live") {
                return "live";
            }
            return "close";
        }
        listen() {
            chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
                const { platform, type } = request;
                if (!platform || platform != E.fromPlatform) {
                    sendResponse({
                        success: false,
                    })
                    return false;
                }
                if (type == E.authToken) {
                    var token = Adapter.instance.getToken();
                    return sendResponse({
                        success: true,
                        data: token
                    })
                }
                if (type == E.getUserName) {
                    var username = Adapter.instance.getUsername();
                    return sendResponse({
                        success: true,
                        username: username
                    })
                }
                else if (type == E.getViewers) {
                    Adapter.instance.getUserList().then(res => {
                        sendResponse({
                            success: true,
                            data: res,
                        })
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                } else if (type == E.getLiveState) {
                    return sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                } else if (type == E.sendChatMessage) {
                    var r = Adapter.instance.sendChatMessage(request.message)
                    sendResponse(r)
                    return true;
                } else if (type == E.privateMessage) {
                    var r = Adapter.instance.sendPrivateMessage(request.message, request.info?.id, request.info)
                    sendResponse(r)
                    return true;
                } else if (type == E.getStreamSetting) {
                    Adapter.instance.getStreamSetting().then(r => {
                        sendResponse(r)
                    })
                    return true;
                }
                return true
            });
        }
        async getStreamSetting() {
            var button = document.querySelector("#button-1045-btnInnerEl");
            if (button) {
                button.click();
                await sleep(800);
            }
            var radio = document.querySelector("#radio-1064-boxLabelEl a");
            if (radio) {
                radio.click();
                await sleep(800);
            }

            var serverEl = document.querySelector("#streamkey_url-inputEl")
            var keyEl = document.querySelector("#streamkey_ext-inputEl")
            var r = {
                success: true,
                data: {
                    username:this.getUsername(),
                    server: serverEl?.value,
                    key: keyEl?.value
                }
            }

            document.querySelector("#button-1134-btnEl")?.click();
            await sleep(100);

            document.querySelector("#tool-1126-toolEl").click();

            return r;
        }
        sendChatMessage(message) {
            try {
                // 设置消息内容并调用发送方法
                const messageInput = document.querySelector('input[name=message_input]');
                if (!messageInput) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                messageInput.value = message;
                messageInput.textContent = message;

                // 触发输入事件，确保网站检测到内容变化
                messageInput.dispatchEvent(new InputEvent('input', {
                    bubbles: true,
                    cancelable: true,
                    inputType: 'insertText',
                    data: message
                }));
                const sendBtn = document.querySelector("a.x-btn[id^=\"send_button\"]")
                if (!sendBtn) {
                    return { success: false, error: 'cant find send button' };
                }
                sendBtn.click();
                // 调用发送方法
                //const result = this.sendMessage(request.message);
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        async sendPrivateMessage(message, username, userInfo) {
            try {
                window.dispatchEvent(new CustomEvent("worker-post", {
                    detail: {
                        url: `wsw.js`,
                        data: `["Post","3 ${Adapter.user.id} ${userInfo.id} 0 0 ${message}\\n\\u0000"]`
                    }
                }))
                //["Post","3 46463986 46460277 0 0 halo\n\u0000"]
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        getToken() {
            return Adapter.token;
        }
        getId() {
            return Adapter.user?.id;
        }
        getEmail() {
            return Adapter.user?.email
        }
        isLiving = false
        _ping(isFirst) {
            let liveState = this.getLiveState();
            
            if (!this.isLiving && liveState == "live") {
                this.isLiving = true;
                setTimeout(() => {
                    Adapter.instance.post(E.chatEvent, {
                        message: {
                            data: {
                                broadcaster: this.getUsername(),
                                user: {
                                    username: this.getUsername(),
                                    in_fan_club: false,
                                }
                            },
                            type: "broadcast_start",
                        }
                    })
                }, 1200)

            }
            if (this.isLiving && liveState == "close") {
                this.isLiving = false;
                Adapter.instance.post(E.chatEvent, {
                    message: {
                        data: {
                            broadcaster: this.getUsername(),
                            user: {
                                username: this.getUsername(),
                                in_fan_club: false,
                            }
                        },
                        type: "broadcast_stop",
                    }
                })
            }
            this.post(E.ping, {
                url: location.href,
                token: this.getToken(),
                id: this.getId(),
                state: liveState,
                isFirst: isFirst,
                platform: PLATFORM,
                username: this.getUsername(),
                email: this.getEmail(),
            })
        }
        post(type, data) {
            if (channel)
                channel.postMessage({
                    ...data,
                    type,
                })
        }
        ping() {
            this._ping(true)
            setInterval(() => {
                this._ping(false)
            }, 5 * 1000)
        }
        syncTipMenu(data) {
            data.active = data.active || "preset1";
            var presets = data.preset;
            var enable = data.enable;
            if (!enable) {
                return;
            }
            TipMenu.run(presets, data.active, data.config);
            return { success: true }
        }
        static instance;
        static init(port) {
            channel = port;
            Adapter.instance = new Adapter();
            Adapter.instance.ping();
            Adapter.instance.listen();
            channel.onMessage.addListener(async (request) => {
                const { data, type } = request;
                if (type == "Get-Living-State") {
                    sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                }
                else if (type == E.syncTipmenu) {
                    var r = await Adapter.instance.syncTipMenu(data);
                    if (r) {
                        Adapter.instance.post(E.syncTipmenuCallback, {
                            status: r.success,
                            data: {
                                success: r.success,
                                data: r.data
                            }
                        })
                    }
                } else if (type == "post-message") {
                    window.postMessage({ ...data })
                } else if (type == "post-message-sync") {
                    window.postMessage({ ...data })
                }
            })
            channel.onDisconnect.addListener(() => {
                channel = null;
            })
            TipMenu.start();
        }
        static isNormal() {
            return !!Adapter.instance;
        }
    }
})()