
(function () {
    const PLATFORM = "joystick"
    const E = {
        ping: "X-Ping",
        fromPlatform: 'honey extensions',
        getUserName: "Get-User-Name",
        getViewers: "Get-Viewers",
        getLiveState: "Get-Living-State",
        sendChatMessage: "Send-Message",
        intercept: "honey-intercept",
        websocketMessage: "X-WebSocket-Message",
        fecthMessage: "X-Fetch-Message",
        xhrMessage: "X-XHR-Message",
        domLoaded: "X-Page-DOMContentLoaded",
        pageClosed: "X-Page-Close",
        room: "room",
        fromJoystick: "joystick tv",
        chatEvent: "Chat-Event",
        viewerCache: `$cached.joystick.viewers`,
        privateMessage: "Send-Private-Message",
        getStreamSetting: "Get-Stream-Settings",
        syncTipmenu: "Sync-TipMenu-Platform",
        syncTipmenuCallback: "Sync-TipMenu-Platform-Callback"
    }
    let channel = null;
    Array.prototype.any = function (fn) {
        if (typeof fn !== "function") {
            for (var item of this) {
                if (fn == item) {
                    return true;
                }
            }
            return false;
        }
        for (var item of this) {
            if (fn.call(this, item)) {
                return true;
            }
        }
        return false;
    }

    function sleep(time) {
        return new Promise((res) => {
            setTimeout(() => {
                res();
            }, time || 10);
        })
    }
    function storage(key, value) {
        if (arguments.length < 2) {
            return localStorage.getItem(key)
        } else {
            if (value == undefined) {
                return localStorage.removeItem(value)
            }
            if (typeof value == "object") {
                value = JSON.stringify(value)
            }
            return localStorage.setItem(key, value)
        }
    }
    const tryJson = (raw) => {
        try {
            return JSON.parse(raw);
        } catch (e) {
            return;
        }
    }

    const postMsg = (type, data) => {
        return new Promise((res) => {
            chrome.runtime.sendMessage({
                platform: PLATFORM,
                type,
                data: data
            }, (resp) => {
                if (chrome.runtime.lastError) {
                    // console.error("postMsg Error:", type, chrome.runtime.lastError);
                } else {

                    res(resp)
                }
            });
        })
    }
    function onChannelMessage(type, data) {
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, data);
        }
    }
    const getJson = (d) => {
        if (d.responseType == "text") {
            return tryJson(d.responseData)
        } else if (d.responseType == "json") {
            return d.responseData;
        }
        return;
    }
    function getParams(req) {
        if ((req.method || "").toLowerCase() == "post") {
            return tryJson(req.body)
        } else {

        }
    }
    function onFetchMessage(type, req) {
        const { data } = req;
        try {
            const url = data.url, d = data.data;
            const param = getParams(d.requestOptions)
            if (param && param?.operationName == "OnlineViewers") {
                json = getJson(d);
                if (!json) { return; }
                var last = storage(E.viewerCache);
                //如果初始化的数据，就忽略掉
                if (last != -1) {
                    if (typeof last === "string") {
                        last = tryJson(last);
                    }
                    last = last || []
                    var nows = json?.data?.onlineViewers || [];

                    if (channel) {
                        for (var n of nows) {
                            if (!last.any(e => e.username == n.username)) {
                                if (Adapter.instance.isBroadcaster(n.username)) {
                                    continue;
                                }
                                channel.postMessage({
                                    type: E.chatEvent,
                                    message: {
                                        type: "user_enter",
                                        data: {
                                            broadcaster: Adapter.instance.getUsername(),
                                            user: {
                                                username: n.username,
                                                in_fan_club: n.isSubsriber,
                                                isSubsriber: n.isFollower,
                                                gender: -1,
                                                is_mod: n.isModerator,
                                                isNewAccount: n.isNewAccount,
                                            }
                                        }
                                    }
                                })
                            }
                        }
                        for (var n of last) {
                            if (!nows.any(e => e.username == n.username)) {
                                if (Adapter.instance.isBroadcaster(n.username)) {
                                    continue;
                                }
                                channel.postMessage({
                                    type: E.chatEvent,
                                    message: {
                                        type: "user_leave",
                                        data: {
                                            broadcaster: Adapter.instance.getUsername(),
                                            user: {
                                                username: n.username,
                                                in_fan_club: n.isSubsriber,
                                                isSubsriber: n.isFollower,
                                                gender: -1,
                                                is_mod: n.isModerator,
                                                isNewAccount: n.isNewAccount,
                                            }
                                        }
                                    }
                                })
                            }
                        }
                    }
                }
                storage(E.viewerCache, (json?.data?.onlineViewers || []).filter(el => {
                    return !Adapter.instance.isBroadcaster(el.username);
                }))
            }
        } catch (ex) {

        }
    }

    function onChannelInit() {
        if (!Adapter.isNormal()) {
            Adapter.init(channel);
        }
    }
    function decorateUser(username) {

        var last = storage(E.viewerCache);

        if (typeof last === "string") {
            last = tryJson(last);
        }
        if (last && last.length) {
            var index = last.findIndex(el => {
                return el.username == username
            })
            var found = last[index]
            if (found) {
                return {
                    username,
                    in_fan_club: found.isSubsriber,
                    isSubsriber: found.isFollower,
                    gender: -1,
                    is_mod: found.isModerator,
                    isNewAccount: found.isNewAccount,
                }
            }
            return {
                username,
            }
        } else {
            return {
                username
            }
        }
    }
    window.addEventListener("message", function (t, a) {
        const data = t.data;
        const { from, type } = data;

        if (from == E.intercept) {
            if (type == E.websocketMessage || type == E.xhrMessage) {
                onChannelMessage(type, data)
            }
            else if (type == E.fecthMessage) {
                onFetchMessage(type, data)
            }
            else if (type == E.domLoaded) {
                chrome.runtime.onConnect.addListener((port) => {
                    if (port.name == E.room) {
                        channel = port;
                        onChannelInit(channel);
                    }
                });
                storage(E.viewerCache, -1);
                postMsg(E.domLoaded, {})
            }
            else if (type == E.pageClosed) {
                postMsg(E.pageClosed, {})
            }
        } else if ((from || "").toLowerCase() == E.fromJoystick) {
            // console.log("on message", type, data)
            if (type == "tipMode") {
                return;
            }
            var evttype = convert2MsgType(type)
            if (evttype == "chat_message" && /^\![tip|uptime|wishlist|tokens|timer|social|so|highlight|giphy|dropin|cleartimers|timers]/i.test(data.content)) {
                return;
            }
            if (evttype == "chat_message" && /^\!whisper/i.test(data.content)) {
                evttype = "private_message"
            }
            const tip = getTip(data);
            var user = type == "tip" ? decorateUser(data.tip.tipperName) : decorateUser(data.userName)
            if (Adapter.instance.isBroadcaster(user.username)) {
                return;
            }
            var evtData = {
                user: user,
                message: { message: data.content },
                tip: tip,
            };
            Adapter.instance.post(E.chatEvent, {
                message: {
                    data: evtData,
                    type: evttype,
                }
            })
        }
    });

    const convert2MsgType = (type) => {
        if (type == "chatMessage") {
            return 'chat_message';
        }
        else if (type == "tip") {
            return 'tip';
        }
        else if (type == "endBroadcast") {
            return 'broadcast_stop';
        }
        else if (type == "sdkDataReport") {
            return 'sdkDataReport';
        }
        return "from:" + type
    }

    //tipmenu
    const TipMenu = function () {
        async function sendTips() {
            var index = 0;
            Adapter.instance.sendChatMessage(`----->HoneyPlayBox Toys respond to tips. Here are my levels:`)
            for (var preset of tipMenu.presets) {
                index = index + 1;
                await sleep(200);
                Adapter.instance.sendChatMessage(`----->#${index} ${preset.name} = ${preset.token} Tokens`)
            }
        }
        async function asyncTipRun(params) {


            const r = await postMsg("Fetch-Data", {
                url: "@server/system/tipMenu/selectTipMenuDetailList/forplatform/" + PLATFORM,
                body: {}
            })
            if (!r.success) {
                return;
            }
            var d = r.data;
            if (!d || d.code != 1000) {
                return;
            }
            d = d.data ? d.data[0] : null
            if (!d || !d.enable) {
                tipMenu.active = false;
                return;
            }
            tipMenu.active = d.enable;
            tipMenu.presets = (d.tipMenuPresetDetailList || []).map(el => {
                return {
                    name: el.activityName,
                    token: el.token,
                }
            });
            sendTips();
        }
        class tipMenu {
            static presets = []
            static active = ""
            static timer = 0;
            static duration = 5
            static run(preset, active, config) {
                tipMenu.presets = preset;
                tipMenu.active = active;
                if (config) {
                    tipMenu.duration = config.duration;
                }
                sendTips();
            }
            static start() {
                if (tipMenu.timer) {
                    return
                }
                setTimeout(async () => {
                    await asyncTipRun();
                    tipMenu.timer = setInterval(async () => {
                        await asyncTipRun();
                    }, (this.duration || 5) * 60 * 1000)
                }, 5000)
            }
        }
        return tipMenu;
    }();

    function getTip(d) {
        return {
            tokens: d.tip?.amount,
            tipperName: d.tip?.tipperName,
            cParameter: d.tip?.cParameter
        }
    }
    class Adapter {
        getCookie(cookieName) {
            var cookieValue = "";
            if (document.cookie) {
                var cookies = document.cookie.split(';');
                for (var i = 0; i < cookies.length; i++) {
                    var cookie = cookies[i];
                    if (cookie.substring(0, cookieName.length + 2).trim() == cookieName.trim() + "=") {
                        cookieValue = cookie.substring(cookieName.length + 2, cookie.length);
                        return cookieValue;
                    }
                }
            }
            return cookieValue;
        }
        async getUserList() {
            var j = storage(E.viewerCache);
            if (!j) {
                return []
            }
            var list = (tryJson(j) || []).map(el => {
                return {
                    username: el.username,
                    colour: "",
                    gender: -1,
                    type: "",
                    colorStr: "",
                    isNewAccount: el.isNewAccount,
                    in_fan_club: el.isSubsriber,
                    isSubsriber: el.isFollower,
                    isMod: el.isModerator,
                    id: null,
                    raw: JSON.stringify(el)
                }
            })
            return {
                count: list.length,
                usersList: list,
            }
        }
        isBroadcaster(username) {
            return this.getUsername() == username;
        }
        getUsername() {
            let vuex = localStorage.getItem("vuex")
            if (vuex) {
                if (typeof vuex === "string") {
                    vuex = JSON.parse(vuex);
                }
            }
            return vuex?.user.username || ""
        }
        getLiveState() {
            if (!channel) {
                return "unknow"
            }
            var ele = document.querySelector("video#myplayer")
            if (ele) {
                return "live";
            }
            return "close";
        }
        listen() {
            chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
                const { platform, type } = request;
                if (!platform || platform != E.fromPlatform) {
                    sendResponse({
                        success: false,
                    })
                    return false;
                }
                if (type == E.authToken) {
                    var token = Adapter.instance.getToken();
                    return sendResponse({
                        success: true,
                        data: token
                    })
                }
                if (type == E.getUserName) {
                    var username = Adapter.instance.getUsername();
                    return sendResponse({
                        success: true,
                        username: username
                    })
                }
                else if (type == E.getViewers) {
                    Adapter.instance.getUserList().then(res => {
                        sendResponse({
                            success: true,
                            data: res,
                        })
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                } else if (type == E.getLiveState) {
                    return sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                } else if (type == E.sendChatMessage) {
                    var r = Adapter.instance.sendChatMessage(request.message)
                    sendResponse(r)
                    return true;
                } else if (type == E.privateMessage) {
                    var r = Adapter.instance.sendPrivateMessage(request.message, request.username)
                    sendResponse(r)
                    return true;
                } else if (type == E.getStreamSetting) {
                    Adapter.instance.getStreamSetting().then(r => {
                        sendResponse(r)
                    })
                    return true;
                }
                return true
            });
        }
        async getStreamSetting() {
            var a = document.querySelector("a[href='/stream-settings']");
            if (a) {
                a.click();
                await sleep(1000);
            }
            var streamsettings = document.querySelectorAll("ul.side-navigation li.flex.flex-row a")
            //[href='#']contains(text(), 'Stream Settings')
            if (streamsettings && streamsettings.length) {
                for (var st of streamsettings) {
                    if (st.innerHTML.includes('Stream Settings')) {
                        st.click();
                        await sleep(400);
                        break;
                    }
                }
            }
            var server = document.querySelector("input[name=ingestEndpoint]");
            var key = document.querySelector("input[name=streamKey]");

            var r = {
                success: true,
                data: {
                    username: this.getUsername(),
                    server: server?.value,
                    key: key?.value
                }
            }
            var a = document.querySelector("a[href='/publisher']");
            if (a) {
                a.click();
            }
            return r;
        }
        sendChatMessage(message) {
            try {
                // 设置消息内容并调用发送方法
                const messageWrapper = document.querySelector('#chat-input');
                if (!messageWrapper) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                const messageInput = messageWrapper.querySelector('input[flow-id=chat-message-text-input]');
                if (!messageInput) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                messageInput.value = message;
                messageInput.textContent = message;

                // 触发输入事件，确保网站检测到内容变化
                messageInput.dispatchEvent(new InputEvent('input', {
                    bubbles: true,
                    cancelable: true,
                    inputType: 'insertText',
                    data: message
                }));
                const sendBtn = messageWrapper.querySelector("button.button")
                if (!sendBtn) {
                    return { success: false, error: 'cant find send button' };
                }
                sendBtn.click();
                // 调用发送方法
                //const result = this.sendMessage(request.message);
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        async ____syncTipMenu(data) {
            data.active = data.active || "preset1";
            if (!data.enable) {
                return;
            }
            var queryMenus = await fetch("/v1/graphql", {
                method: "post",
                headers: {
                    authorization: "Bearer " + this.getToken(),
                },
                body: JSON.stringify({
                    "operationName": "TipMenus",
                    "variables": { "streamerSlug": this.getUsername(), "active": "both" },
                    "query": "query TipMenus($streamerSlug: String!, $active: String!) {\n  tipMenus(streamerSlug: $streamerSlug, active: $active) {\n    id\n    active\n    title\n    subscriberOnly\n    tipMenuItems {\n      id\n      title\n      amount\n      singleUse\n      locked\n      cooldown\n    }\n  }\n}\n"
                })
            });
            var qjson = await queryMenus.json();
            if (qjson && qjson.data) {
                var found = (qjson.data.tipMenus || []).findIndex(el => {
                    return el.title == data.active
                });
                if (found > -1) {
                    var f = qjson.data.tipMenus[found];

                    await sleep(300);
                    var deleteMenus = await fetch("/v1/graphql", {
                        method: "post",
                        headers: {
                            authorization: "Bearer " + this.getToken(),
                        },
                        body: JSON.stringify({
                            "operationName": "DeleteTipMenu",
                            "variables": { "tipMenuId": f.id },
                            "query": "mutation DeleteTipMenu($tipMenuId: String!) {\n  deleteTipMenu(tipMenuId: $tipMenuId) {\n    success\n    errors\n  }\n}\n"
                        })
                    })

                    qjson = await deleteMenus.json();
                }

            }
            await sleep(500);
            var preset = await fetch("/v1/graphql", {
                method: "post",
                headers: {
                    authorization: "Bearer " + this.getToken(),
                },
                body: JSON.stringify({
                    "operationName": "CreateTipMenu",
                    "variables": {
                        "tipMenu": { "title": data.active, "active": true }
                    },
                    "query": "mutation CreateTipMenu($tipMenu: TipMenu!) {\n  createTipMenu(tipMenuParams: $tipMenu) {\n    success\n    errors\n  }\n}\n"
                })
            })
            var json = await preset.json();
            if (json && json.data && json.data.createTipMenu && json.data.createTipMenu.success) {

                var queryMenus = await fetch("/v1/graphql", {
                    method: "post",
                    headers: {
                        authorization: "Bearer " + this.getToken(),
                    },
                    body: JSON.stringify({
                        "operationName": "TipMenus",
                        "variables": { "streamerSlug": this.getUsername(), "active": "both" },
                        "query": "query TipMenus($streamerSlug: String!, $active: String!) {\n  tipMenus(streamerSlug: $streamerSlug, active: $active) {\n    id\n    active\n    title\n    subscriberOnly\n    tipMenuItems {\n      id\n      title\n      amount\n      singleUse\n      locked\n      cooldown\n    }\n  }\n}\n"
                    })
                });
                var qjson = await queryMenus.json();
                var last = qjson.data.tipMenus[qjson.data.tipMenus.length - 1]
                //创建成功
                for (var item of data.preset) {
                    await sleep(300);
                    var add = await fetch("/v1/graphql", {
                        method: "post",
                        headers: {
                            authorization: "Bearer " + this.getToken(),
                        },
                        body: JSON.stringify({
                            "operationName": "AddTipMenuItem",
                            "variables": {
                                "tipMenuItem": {
                                    "tipMenuId": last.id,
                                    "title": item.name,
                                    "amount": item.token,
                                    "singleUse": false,
                                    "cooldown": 0,
                                    "active": true
                                }
                            },
                            "query": "mutation AddTipMenuItem($tipMenuItem: TipMenuItem!) {\n  addTipMenuItem(tipMenuItemParams: $tipMenuItem) {\n    success\n    errors\n  }\n}\n"
                        })
                    })
                    var addresult = await add.json();

                    if (addresult && addresult.data && addresult.data.addTipMenuItem && addresult.data.addTipMenuItem.success) {
                        continue;
                    } else {
                        return {
                            success: false,
                            data: {
                                msgCode: "syncErr"
                            }
                        }
                    }
                }

                return {
                    success: true
                }
            } else {
                return {
                    success: false,
                    data: {
                        msgCode: "createErr"
                    }
                }
            }
        }
        async syncTipMenu(data) {

            data.active = data.active || "preset1";
            var presets = data.preset;
            var enable = data.enable;
            if (!enable) {
                return;
            }
            TipMenu.run(presets, data.active, data.config);
            return { success: true }
        }
        sendPrivateMessage(message, username) {
            try {
                // 设置消息内容并调用发送方法
                const messageWrapper = document.querySelector('#chat-input');
                if (!messageWrapper) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                const messageInput = messageWrapper.querySelector('input[flow-id=chat-message-text-input]');
                if (!messageInput) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                message = `!whisper @${username} ${message}`
                messageInput.value = message;
                messageInput.textContent = message;

                // 触发输入事件，确保网站检测到内容变化
                messageInput.dispatchEvent(new InputEvent('input', {
                    bubbles: true,
                    cancelable: true,
                    inputType: 'insertText',
                    data: message
                }));
                const sendBtn = messageWrapper.querySelector("button.button")
                if (!sendBtn) {
                    return { success: false, error: 'cant find send button' };
                }
                sendBtn.click();
                // 调用发送方法
                //const result = this.sendMessage(request.message);
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        getToken() {
            return localStorage.getItem("apollo-token") || "";
        }
        isLiving = false
        _ping(isFirst) {
            let vuex = localStorage.getItem("vuex")
            if (vuex) {
                if (typeof vuex === "string") {
                    vuex = JSON.parse(vuex);
                }
            }
            let liveState = this.getLiveState();

            if (!this.isLiving && liveState == "live") {
                this.isLiving = true;
                setTimeout(() => {
                    Adapter.instance.post(E.chatEvent, {
                        message: {
                            data: {
                                broadcaster: this.getUsername(),
                                user: {
                                    username: this.getUsername(),
                                    in_fan_club: false,
                                }
                            },
                            type: "broadcast_start",
                        }
                    })
                }, 800)

            }
            if (this.isLiving && liveState == "close") {
                this.isLiving = false;
                Adapter.instance.post(E.chatEvent, {
                    message: {
                        data: {
                            broadcaster: this.getUsername(),
                            user: {
                                username: this.getUsername(),
                                in_fan_club: false,
                            }
                        },
                        type: "broadcast_stop",
                    }
                })
            }
            this.post(E.ping, {
                url: location.href,
                token: this.getToken(),
                state: liveState,
                isFirst: isFirst,
                platform: PLATFORM,
                username: this.getUsername(),
                email: vuex?.user?.email || "",
                id: vuex?.user?.id,
            })
        }
        post(type, data) {
            if (channel)
                channel.postMessage({
                    ...data,
                    type,
                })
        }
        ping() {
            this._ping(true)
            setInterval(() => {
                this._ping(false)
            }, 5 * 1000)
        }

        static instance;
        static init(port) {
            channel = port;
            Adapter.instance = new Adapter();
            Adapter.instance.ping();
            Adapter.instance.listen();
            channel.onMessage.addListener(async (request) => {
                // console.log("on channel message", msg)
                const { data, type } = request;
                if (type == "Get-Living-State") {
                    sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                }
                else if (type == E.syncTipmenu) {
                    var r = await Adapter.instance.syncTipMenu(data);
                    if (r) {
                        Adapter.instance.post(E.syncTipmenuCallback, {
                            status: r.success,
                            data: {
                                success: r.success,
                                data: r.data
                            }
                        })
                    }
                } else if (type == "post-message") {
                    window.postMessage({ ...data })
                } else if (type == "post-message-sync") {
                    window.postMessage({ ...data })
                }
            })
            channel.onDisconnect.addListener(() => {
                channel = null;
            })
            TipMenu.start();
        }
        static isNormal() {
            return !!Adapter.instance;
        }
    }
})()