
(function () {
    const PLATFORM = "chaturbate"
    const E = {
        ping: "X-Ping",
        fromPlatform: 'honey extensions',
        getUserName: "Get-User-Name",
        getViewers: "Get-Viewers",
        getLiveState: "Get-Living-State",
        sendChatMessage: "Send-Message",
        privateMessage: "Send-Private-Message",
        getStreamSetting: "Get-Stream-Settings",
        chatEvent: "Chat-Event",
        syncTipmenu: "Sync-TipMenu-Platform",
        syncTipmenuCallback: "Sync-TipMenu-Platform-Callback"

    }
    let channel = null;

    const postMsg = (type, data) => {
        return new Promise((res) => {
            chrome.runtime.sendMessage({
                platform: PLATFORM,
                type,
                data: data
            }, (resp) => {
                if (chrome.runtime.lastError) {
                    // console.error("postMsg Error:", type, chrome.runtime.lastError);
                } else {

                    res(resp)
                }
            });
        })
    }

    function sleep(time) {
        return new Promise((res) => {
            setTimeout(() => {
                res();
            }, time || 10);
        })
    }
    function onChannelMessage(type, data) {
        console.log("------type", type)
        if (type == "X-XHR-Message") {
            const { url } = data.data;
            console.log("------url", url)
            if (/cb\.dev\/api\/app\/list\?isInstalled/i.test(url)) {
                const d = data.data.data;
                ExtenisionsApp.preinit(d);
            }
        }
        if (type == "X-Fetch-Message") {
            const { url } = data.data;
            console.log("------fetch url", url)
            if (/cb\.dev\/api\/app\/list\?isInstalled/i.test(url)) {
                const d = data.data.data;
                ExtenisionsApp.preinit(d);
            }
        }
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, data);
        }
    }

    function onChannelInit() {
        if (!Adapter.isNormal()) {
            Adapter.init(channel);
        }
    }

    window.addEventListener("message", function (t, a) {
        const data = t.data;
        const { from, type } = data;
        if (from == "honey-intercept") {
            if (type == "X-WebSocket-Message" || type == "X-XHR-Message" || type == "X-Fetch-Message") {
                onChannelMessage(type, data)
            }
            if (type == "X-Page-DOMContentLoaded") {
                chrome.runtime.onConnect.addListener((port) => {
                    if (port.name == "room") {
                        channel = port;
                        onChannelInit(channel);
                    }
                });
                postMsg("X-Page-DOMContentLoaded", {})
            }
            else if (type == "X-Page-Close") {
                postMsg("X-Page-Close", {})
            }
        } else {

        }
    });


    //tipmenu
    const TipMenu = function () {
        async function sendTips() {
            var index = 0;
            Adapter.instance.sendChatMessage(`----->HoneyPlayBox Toys respond to tips. Here are my levels:`)
            for (var preset of tipMenu.presets) {
                index = index + 1;
                await sleep(200);
                Adapter.instance.sendChatMessage(`----->#${index} ${preset.name} = ${preset.token} Tokens`)
            }
        }
        async function asyncTipRun(params) {


            const r = await postMsg("Fetch-Data", {
                url: "@server/system/tipMenu/selectTipMenuDetailList/forplatform/" + PLATFORM,
                body: {}
            })
            if (!r.success) {
                return;
            }
            var d = r.data;
            if (!d || d.code != 1000) {
                return;
            }
            d = d.data ? d.data[0] : null
            if (!d || !d.enable) {
                tipMenu.active = false;
                return;
            }
            tipMenu.active = d.enable;
            tipMenu.presets = (d.tipMenuPresetDetailList || []).map(el => {
                return {
                    name: el.activityName,
                    token: el.token,
                }
            });
            sendTips();
        }
        class tipMenu {
            static presets = []
            static active = ""
            static timer = 0;
            static duration = 5
            static run(preset, active, config) {
                tipMenu.presets = preset;
                tipMenu.active = active;
                if (config) {
                    tipMenu.duration = config.duration;
                }
                sendTips();
            }
            static start() {
                // if (tipMenu.timer) {
                //     return
                // }
                // setTimeout(async () => {
                //     await asyncTipRun();
                //     tipMenu.timer = setInterval(async () => {
                //         await asyncTipRun();
                //     }, (this.duration || 5) * 60 * 1000)
                // }, 5000)
            }
        }
        return tipMenu;
    }();



    class Adapter {
        getCookie(cookieName) {
            var cookieValue = "";
            if (document.cookie) {
                var cookies = document.cookie.split(';');
                for (var i = 0; i < cookies.length; i++) {
                    var cookie = cookies[i];
                    if (cookie.substring(0, cookieName.length + 2).trim() == cookieName.trim() + "=") {
                        cookieValue = cookie.substring(cookieName.length + 2, cookie.length);
                        return cookieValue;
                    }
                }
            }
            return cookieValue;
        }
        async getUserList() {
            const UserColour = {
                ORANGE: "o",      // Broadcaster
                RED: "r",         // Moderator
                DARK_PURPLE: "l", // Tipped 1,000 tkns +
                LIGHT_PURPLE: "p",// Tipped 250 - 999 tkns
                DARK_BLUE: "tr",  // Tipped 50 - 249 tkns
                LIGHT_BLUE: "t",  // Tipped 0 - 49 tkns, or just has tokens
                GREEN: "g"        // Has no Tokens
            };

            const UserType = {
                RED: "m",    // Moderator
                ORANGE: "o", // Fan Club Member
                GREEN: "g"   // Broadcaster
            };

            const UserGender = {
                MALE: "m",   // man
                FEMALE: "f", // woman
                TRANS: "t",  // transgender
                COUPLE: "c"  // couple
            };

            function mapGender(gender) {
                switch (gender) {
                    case UserGender.MALE:
                        return 0;
                    case UserGender.FEMALE:
                        return 1;
                    case UserGender.TRANS:
                        return 2;
                    case UserGender.COUPLE:
                        return 3;
                    default:
                        return -1;
                }
            }

            function mapColour(colour) {
                switch (colour) {
                    case UserColour.ORANGE:
                        return "orange";
                    case UserColour.RED:
                        return "red";
                    case UserColour.GREEN:
                        return "green";
                    case UserColour.DARK_PURPLE:
                        return "dark purple";
                    case UserColour.LIGHT_PURPLE:
                        return "light purple";
                    case UserColour.DARK_BLUE:
                        return "dark blue";
                    case UserColour.LIGHT_BLUE:
                        return "light blue";
                    case UserColour.GREEN:
                        return "grey";
                    default:
                        return "";
                }
            }
            const username = this.getUsername()
            const token = this.getCookie("csrftoken");
            const resp = await fetch(`/api/getchatuserlist/?roomname=${username}&private=false&sort_by=a&exclude_staff=true`, {
                headers: {
                    Newrelic: token
                }
            });

            if (!resp.ok) {
                return {
                    count: 0,
                    usersList: []
                };
            }

            const text = await resp.text();
            // console.log("get user list", text);
            const allViewers = text.split(",");

            if (allViewers.length < 2) {
                return {
                    count: 0,
                    usersList: []
                };
            }

            const anonymousNumber = Math.max(0, Number(allViewers[0]));
            const users = allViewers.slice(1).reduce((acc, item) => {
                const args = item.split("|");
                if (args.length < 4) {
                    return acc;
                }

                const username = (args[0] || "").trim();
                if (!username || username === this.username) {
                    return acc;
                }
                acc.push({
                    username: username,
                    colour: mapColour(args[1]),
                    gender: mapGender(args[2]),
                    type: args[3],
                    raw: JSON.stringify(args),
                    colorStr: mapColour(args[1])
                });
                return acc;
            }, []);

            return {
                count: anonymousNumber,
                usersList: users
            };
        }
        getUsername() {
            var el = document.querySelector(".user_information_header_username");
            if (el) {
                return (el.innerHTML || "").trim()
            }
            return ""
        }
        getLiveState() {
            if (!channel) {
                return "unknow"
            }
            var ele = document.querySelector("#OBSOverlay .roomStatus")
            if (ele) {
                var status = (ele.innerHTML || "").trim();
                if (!status || status == "" || status == "offline") {
                    return "close"
                }
                return "live";
            }
            return "close";
        }
        listen() {
            chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
                const { platform, type } = request;
                if (!platform || platform != E.fromPlatform) {
                    sendResponse({
                        success: false,
                    })
                    return false;
                }
                if (type == E.getUserName) {
                    var username = Adapter.instance.getUsername();
                    return sendResponse({
                        success: true,
                        username: username
                    })
                }
                else if (type == E.getViewers) {
                    Adapter.instance.getUserList().then(res => {
                        sendResponse({
                            success: true,
                            data: res,
                        })
                    }).catch(e => {
                        sendResponse({
                            success: false
                        })
                    })
                    return true;
                } else if (type == E.getLiveState) {
                    sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                    return true;
                } else if (type == E.sendChatMessage) {
                    var r = Adapter.instance.sendChatMessage(request.message)
                    sendResponse({
                        success: true,
                        data: r,
                    })
                    return true;
                } else if (type == E.privateMessage) {
                    Adapter.instance.sendPrivateMessage(request.username, request.message).then(r => {
                        sendResponse({
                            success: true,
                            data: r,
                        })
                    })
                    return true;
                } else if (type == E.getStreamSetting) {
                    Adapter.instance.getStreamSetting().then(r => {
                        sendResponse(r)
                    })
                    return true;
                }

                return true
            });
        }
        async getStreamSetting() {
            var panel = document.querySelector("a#obs_info");
            if (panel) {
                panel.click();
                await sleep(400);
            }
            var server = document.querySelector(".obs_info strong.rtmpUrl");
            var key = document.querySelector("#obs_token");

            var r = {
                success: true,
                data: {
                    username: this.getUsername(),
                    server: server?.textContent,
                    key: key?.value,
                }
            }
            var close = document.querySelector("a.button[data-testid=close-btn]")
            if (close) {
                close.click();
            }
            return r;
        }
        async sendPrivateMessage(username, message) {
            const braodcastor = this.getUsername()
            const token = this.getCookie("csrftoken");
            var formdata = new FormData();
            formdata.append("room", braodcastor)
            formdata.append("from_user", braodcastor)
            formdata.append("to_user", username)
            formdata.append("message", JSON.stringify({
                m: message,
                media_id: []
            }))
            formdata.append("csrfmiddlewaretoken", token);
            const resp = await fetch(`/api/ts/chatmessages/pm_publish/`, {
                method: "post",
                mode: "cors",
                cache: "no-cache",
                credentials: "same-origin",
                headers: {
                    // "Content-Type": "application/json",
                    "X-Requested-With": "XMLHttpRequest",
                },
                redirect: "follow",
                referrerPolicy: "strict-origin-when-cross-origin",
                body: formdata,
            });
            var json = await resp.json();
            return json.status == "Ok";
        }
        sendChatMessage(message) {
            try {
                // 找到聊天输入框和发送按钮
                const chatInput = document.querySelector('.chat-input-field');
                const sendButton = document.querySelector('.SendButton');
                if (!chatInput) {
                    return { success: false, error: 'cant find message box' };
                }
                if (!sendButton) {
                    sendResponse({ success: false, error: 'cant find send button' });
                    return;
                }
                chatInput.value = message;
                chatInput.textContent = message;

                // 触发输入事件，确保网站检测到内容变化
                chatInput.dispatchEvent(new InputEvent('input', {
                    bubbles: true,
                    cancelable: true,
                    inputType: 'insertText',
                    data: message
                }));
                sendButton.click();
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        getToken() {
            var token = this.getCookie("csrftoken")
            return token || "";
        }
        isBroadcaster() {
            return true;
        }

        /**
         * 同步设置
         */
        syncSetting() {

        }
        isLiving = false
        _ping(isFirst) {
            let liveState = this.getLiveState();
            if (!this.isLiving && liveState == "live") {
                this.isLiving = true;
                Adapter.instance.post(E.chatEvent, {
                    message: {
                        data: {
                            broadcaster: this.getUsername(),
                            user: {
                                username: this.getUsername(),
                                in_fan_club: false,
                            }
                        },
                        type: "broadcast_start",
                    }
                })

            }
            else if (this.isLiving && liveState == "close") {
                this.isLiving = false;
                Adapter.instance.post(E.chatEvent, {
                    message: {
                        data: {
                            broadcaster: this.getUsername(),
                            user: {
                                username: this.getUsername(),
                                in_fan_club: false,
                            }
                        },
                        type: "broadcast_stop",
                    }
                })
            }
            this.post(E.ping, {
                url: location.href,
                isFirst: isFirst,
                token: this.getToken(),
                state: liveState,
                platform: PLATFORM,
                username: this.getUsername()
            })
        }
        post(type, data) {
            if (channel)
                channel.postMessage({
                    ...data,
                    type,
                })
        }
        postSync(type, data) {
            if (!channel) {
                return Promise.resolve(null)
            }
            data = data || {}
            var reqId = new Date().valueOf() + `${data.type || "_"}`;
            return new Promise((res, rej) => {
                // 定义消息处理函数
                function handleMessage(msg) {
                    console.log('收到消息:', msg);
                    if (msg.requestId != reqId && msg.callbackId && msg.callbackId == reqId) {
                        // 处理消息...
                        channel.onMessage.removeListener(handleMessage);
                        const { ok, data, message } = msg;
                        if (ok) {
                            res(data)
                        } else {
                            rej(message)
                        }
                    }
                }
                if (timeout) {
                    setTimeout(() => {
                        channel.onMessage.removeListener(handleMessage);
                        rej("timeout")
                    }, timeout);
                }
                channel.onMessage.addListener(handleMessage);
                channel.postMessage({
                    ...data,
                    requestId: reqId,
                })
            })
        }
        ping() {
            this._ping(true)
            setInterval(() => {
                this._ping(false)
            }, 5 * 1000)
        }
        syncTipMenu(data) {
            data.active = data.active || "preset1";
            var presets = data.preset;
            var enable = data.enable;
            if (!enable) {
                return;
            }
            TipMenu.run(presets, data.active, data.config);
            return { success: true }
        }
        channel() {

        }
        static instance;
        static init(port) {
            channel = port;
            Adapter.instance = new Adapter();
            Adapter.instance.ping();
            Adapter.instance.listen();
            channel.onMessage.addListener(async (request) => {
                const { data, type } = request;
                if (type == "Get-Living-State") {
                    sendResponse({
                        success: true,
                        data: Adapter.instance.getLiveState(),
                    })
                }
                else if (type == E.syncTipmenu) {
                    var r = await Adapter.instance.syncTipMenu(data);
                    if (r) {
                        Adapter.instance.post(E.syncTipmenuCallback, {
                            status: r.success,
                            data: {
                                success: r.success,
                                data: r.data
                            }
                        })
                    }
                } else if (type == "post-message") {
                    window.postMessage({ ...data })
                } else if (type == "post-message-sync") {
                    window.postMessage({ ...data })
                }

            })
            channel.onDisconnect.addListener(() => {
                channel = null;
            })
            // TipMenu.start();
        }
        static isNormal() {
            return !!Adapter.instance;
        }
    }
})();