
const PLATFORM = "chaturbate"
const postMsg = (type, data) => {
    return new Promise((res) => {
        chrome.runtime.sendMessage({
            platform: PLATFORM,
            type,
            data: data
        }, (resp) => {
            if (chrome.runtime.lastError) {
            } else {
                res(resp)
            }
        });
    })
}
const ExtenisionsApp = function () {
    const Apps = [
        {
            id: "c6823ae1-0000-0000-0000-000000000000",
            enabled: true,
            functional: ['tipMenu', 'tipRule', 'auto-reply']
        },
        {
            id: "eeadaa1b-0000-0000-0000-000000000000",
            enabled: true,
            functional: ['tipMenu', 'tipRule', 'auto-reply']
        }
    ]

    const hasFunctional = (id, functional) => {
        const app = findById(id);
        if (!app) {
            return false;
        }
        return app.functional.includes(functional);
    }
    const hasTipMenu = (id) => {
        return hasFunctional(id, 'tipMenu');
    }
    const hasLoveMeter = (id) => {
        return hasFunctional(id, 'lovemeter');
    }
    const hasTipRule = (id) => {
        return hasFunctional(id, 'tipRule');
    }

    const findById = (id) => {
        return Apps.find(el => el.id == id);
    }

    const getSettings = async (key) => {
        key = `Get-${key}-Settings`
        var result = await postSync("Transfer-To-Offscreen-Sync", {
            target: key,
            data: {
            }
        });
        if (!result) {
            return;
        }
        return result;
    }
    const getVirbration = (lv) => {
        switch (lv) {
            case 100:
                return "Ultra";
            case 75:
                return "High";
            case 50:
                return "Medium";
            default:
                return "Low";
        }
    }
    const syncTipRules = async (isNotSaveUpdate) => {
        var settings = await getSettings("Tip-Rule");
        if (!settings || !settings.ok || !settings.data) {
            return;
        }
        settings = settings.data || [];
        var st = {

        }

        for (var i = 1; i <= 20; i++) {
            st[`tiprule_lv_${i}`] = "";
        }

        var i = 0;
        for (var r of settings) {
            i++;
            if (r.tokenMax) {
                st[`tiprule_lv_${i}`] = `[${r.tokenMin} to ${r.tokenMax} tokens] = ${r.duration} SEC (${getVirbration(r.motorModel1)} Vibrations)`;
            } else {
                st[`tiprule_lv_${i}`] = `[≥${r.tokenMin} tokens] = ${r.duration} SEC (${getVirbration(r.motorModel1)} Vibrations)`;
            }
        }

        if (isNotSaveUpdate) {
            return st;
        }
        for (var app of Apps) {
            if (!app.enabled) {
                continue;
            }
            if (!hasTipRule(app.id)) {
                continue;
            }
            await mergeUpdate(app, st);
        }

        return st;
    }

    const syncTipMenus = async (isNotSaveUpdate) => {

        var settings = await getSettings("Tip-Menu");
        if (!settings || !settings.ok || !settings.data) {
            return;
        }
        settings = settings.data[0] || {};
        if (!settings) {
            return;
        }
        var detailList = settings.tipMenuPresetDetailList || [];
        var st = {}

        for (var i = 1; i <= 20; i++) {
            st[`tipmenu_lv_${i}`] = "";
        }
        var i = 0;
        if (settings.enable) {
            for (var r of detailList) {
                i++;
                st[`tipmenu_lv_${i}`] = `[${r.token} tokens] = ${r.activityName}`;
                //st[`tipmenu_lv_${i}`] = `[${r.token} tokens] = [cb:tip amount=${r.token} message="${r.activityName}"]`;
            }
        }
        if (isNotSaveUpdate) {
            return st;
        }
        for (var app of Apps) {
            if (!app.enabled) {
                continue;
            }
            if (!hasTipMenu(app.id)) {
                continue;
            }
            mergeUpdate(app, st);

        }
    }

    const syncLoveMeter = async () => {
        var settings = await getSettings("Love-Meter");
        if (!settings || !settings.length) {
            return;
        }
        for (var app of Apps) {
            if (!app.enabled) {
                continue;
            }
            if (!hasTipRule(app.id)) {
                continue;
            }
            await saveUpdate(app, settings);
        }
    }

    const saveUpdate = async (app, settings) => {
        if (!app || !app.enabled) {
            return false;
        }

        var url = `https://directory-v3-live.cb.dev/api/app/${app.id}/update`
        const params = {
            permissions: {},
            reason: "",
            settings: settings
        }
        var resp = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                "Authorization": `Bearer ${sessionStorage.getItem("token")}`
            },
            body: JSON.stringify(params)
        })

        if (resp.ok) {
            return true
        }
        return false;
    }

    const mergeUpdate = async (app, settings) => {
        var details = await getDetail(app.id);
        details = details || {}
        console.log("----------->app 详情", details)
        var settingsValues = details.settingsValues || {};
        Object.assign(settingsValues, settings || {})
        saveUpdate(app, Object.assign({}, settingsValues))
    }

    const getInstalledApp = async () => {
        var url = `https://directory-v3-live.cb.dev/api/app/list?isInstalled=true`

        var resp = await fetch(url, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                "Authorization": `Bearer ${sessionStorage.getItem("token")}`
            },
        })

        if (resp.ok) {
            return true
        }
        return false;
    }

    const getDetail = async (appid) => {
        var url = `https://directory-v3-live.cb.dev/api/app/${appid}`
        var resp = await fetch(url, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                "Authorization": `Bearer ${sessionStorage.getItem("token")}`
            },
        })

        if (resp.ok) {
            return resp.json();
        }
        return;
    }

    function onMessage(msg) {
        const { type, data, platform, requestId, name } = msg
        if (type == "notify-tiprule-changed") {
            syncTipRules();
        }
        else if (type == "notify-tipmenu-changed") {
            syncTipMenus();
        }
    }

    var channel = null
    function listen() {
        // channel = chrome.runtime.connect({
        //     name: "monitor"
        // });
        // channel.onMessage.addListener((message) => {

        // });

        chrome.runtime.onConnect.addListener((port) => {
            if (port.name == "monitor") {
                channel = port;
                init();
                channel.onMessage.addListener((message) => {
                    console.log('收到消息:', message);
                    onMessage(message);
                })
            }
        });
        postMsg("X-Monitor-DOMContentLoaded", {

        })
    }


    function disconnect() {
        if (!channel) {
            return
        }
        console.log("------------>monitor disconnect")
        channel.disconnect();
    }

    function postSync(type, data, timeout) {
        if (!channel) {
            return;
        }
        data = data || {}
        if (!timeout) {
            timeout = 10000;
        }
        var reqId = "monitor" + timeout + "-" + new Date().valueOf() + `${data.type || "_"}`;
        return new Promise((res, rej) => {
            // 定义消息处理函数
            function handleMessage(message) {
                console.log('收到消息:', message);
                if (message.type != data.type + "-callback" && message.requestId && message.requestId == reqId) {
                    // 处理消息...
                    channel.onMessage.removeListener(handleMessage);
                    res(message);
                }
            }
            if (timeout) {
                setTimeout(() => {
                    channel.onMessage.removeListener(handleMessage);
                    rej("timeout");
                }, timeout);
            }
            channel.onMessage.addListener(handleMessage);
            channel.postMessage({
                type,
                platform: PLATFORM,
                data,
                requestId: reqId,
            })
        })
    }

    async function init() {
        await getInstalledApp();
        var menus = await syncTipMenus(true);
        var rules = await syncTipRules(true);
        menus = menus || {};
        rules = rules || {}
        // Object.assign(menus, rules || {});
        for (var app of Apps) {
            try {
                if (!app.enabled) {
                    continue;
                }
                var details = await getDetail(app.id);
                details = details || {}
                console.log("----------->app 详情", details)
                var settingsValues = details.settingsValues || {};
                if (hasTipMenu(app.id)) {
                    Object.assign(settingsValues, menus || {})
                }
                if (hasTipRule(app.id)) {
                    Object.assign(settingsValues, rules || {});
                }
                saveUpdate(app, Object.assign({}, settingsValues))
            } catch (ex) {
                console.log("---------->init error", details)
            }
        }
    }

    return {
        isInstall: function (id) {
            const app = Apps.find(el => el.id == id);
            if (!app) {
                return;
            }
            app.enabled = true;
        },
        getDetail,
        init: init,
        postSync,
        listen,
        disconnect,
        getInstalledApp,
        async sync() {
            await syncTipRules();
            await syncTipMenus();
            await syncLoveMeter();
        }
    };
}();

// window.addEventListener("message", function (t, a) {
//     const data = t.data;
//     const { from, type } = data;
//     if (from != "honey-intercept") {
//         return;
//     }
//     if (type == "X-Page-DOMContentLoaded") {
//         ExtenisionsApp.connect();
//     }
//     else if (type == "X-Page-Close") {
//         ExtenisionsApp.disconnect();
//     }
// })

window.addEventListener("DOMContentLoaded", function () {
    console.log("----monitor connect")
    ExtenisionsApp.listen();
})
