
(function () {
    let hasLoaded = false;
    (function () {
        let wakeLock = null;
        async function requestWakeLock() {
            try {
                wakeLock = await navigator.wakeLock.request('screen');
                console.log('屏幕唤醒锁定已激活');

                wakeLock.addEventListener('release', () => {
                    console.log('唤醒锁被释放');
                });
            } catch (err) {
                console.error(`请求失败: ${err.name}, ${err.message}`);
            }
        }
        requestWakeLock();
    })();
    window.addEventListener("message", (e) => {
        console.log("message evt", e)
        const data = e.data;
        const { from, type } = data;
        console.log("message evt", from, type, data, e)
        if (type == "loaded") {
            chrome.runtime.sendMessage({
                type: "offscreen-document-loaded", data: {
                    config: data.config || {},
                    constains: data.constains || {}
                }
            }, (resp) => { })
            const extensionId = chrome.runtime.id;
            console.log("extensions id", extensionId)
            iframe.contentWindow?.postMessage({
                type: "Extenisions",
                platform: "offscreen",
                data: {
                    id: extensionId
                }
            }, "*");
            console.log("post message", extensionId)
        }
    })
    async function runtimeOnMessageHandler(request, sender, sendResponse) {
        const { type, platform, data } = request;
        switch (type) {
            case "To-Offscreen":
                iframe.contentWindow?.postMessage({
                    type,
                    platform,
                    data
                });
                sendResponse({ success: true })
                break;
        }
    }
    var iframe = document.getElementById("backendIframe");
    //环境切换
    iframe.src = "https://extensions.vibexcast.com/prods/background.html?no-store="+new Date().valueOf();
    // iframe.src = chrome.runtime.getURL("/cloud/background.html");
    iframe.addEventListener("load", () => {
        if (hasLoaded) {
            return;
        }
        chrome.runtime.onMessage.addListener(runtimeOnMessageHandler);
        hasLoaded = true;
    })
})();