
(function () {
    const PLATFORM = "xham"
    const E = {
        ping: "X-Ping",
        fromPlatform: 'honey extensions',
        getUserName: "Get-User-Name",
        getViewers: "Get-Viewers",
        getLiveState: "Get-Living-State",
        sendChatMessage: "Send-Message",
        intercept: "honey-intercept",
        websocketMessage: "X-WebSocket-Message",
        fecthMessage: "X-Fetch-Message",
        xhrMessage: "X-XHR-Message",
        domLoaded: "X-Page-DOMContentLoaded",
        pageClosed: "X-Page-Close",
        room: "room",
        chatEvent: "Chat-Event",
        viewerCache: `$cached.xham.viewers`,
        privateMessage: "Send-Private-Message",
        getStreamSetting: "Get-Stream-Settings",
        syncTipmenu: "Sync-TipMenu-Platform",
        syncTipmenuCallback: "Sync-TipMenu-Platform-Callback"

    }
    let channel = null;
    Array.prototype.any = function (fn) {
        if (typeof fn !== "function") {
            for (var item of this) {
                if (fn == item) {
                    return true;
                }
            }
            return false;
        }
        for (var item of this) {
            if (fn.call(this, item)) {
                return true;
            }
        }
        return false;
    }
    function storage(key, value) {
        if (arguments.length < 2) {
            return localStorage.getItem(key)
        } else {
            if (value == undefined) {
                return localStorage.removeItem(value)
            }
            if (typeof value == "object") {
                value = JSON.stringify(value)
            }
            return localStorage.setItem(key, value)
        }
    }
    const tryJson = (raw) => {
        try {
            return JSON.parse(raw);
        } catch (e) {
            return;
        }
    }
    const randomChar = (length) => {
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        let result = '';
        for (let i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * characters.length));
        }
        return result;
    }

    const postMsg = (type, data) => {
        return new Promise((res) => {
            chrome.runtime.sendMessage({
                platform: PLATFORM,
                type,
                data: data
            }, (resp) => {
                if (chrome.runtime.lastError) {
                    // console.error("postMsg Error:", type, chrome.runtime.lastError);
                } else {

                    res(resp)
                }
            });
        })
    }

    function onChannelMessage(type, data) {
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, data);
        }
    }
    const getJson = (d) => {
        if (d.responseType == "text") {
            return tryJson(d.responseData)
        } else if (d.responseType == "json") {
            return d.responseData;
        }
        return;
    }
    function getParams(req) {
        if ((req.method || "").toLowerCase() == "post") {
            return tryJson(req.body)
        } else {

        }
    }
    function onFetchMessage(type, req) {
        const { data } = req;
        try {
            const url = data.url, d = data.data;
            const param = getParams(d.requestOptions)
            if (url && /\/api\/front\/models\/username\/[^\/]+\/members\/?[^\/]*/i.test(url)) {
                //获取members的结构
                json = getJson(d);
                if (!json) { return; }
                var last = storage(E.viewerCache);
                //如果初始化的数据，就忽略掉
                if (last != -1) {
                    if (typeof last === "string") {
                        last = tryJson(last);
                    }
                    last = last || []
                    var nows = json?.members || [];

                    if (channel) {
                        for (var n of nows) {
                            if (!last.any(e => e.user.username == n.user.username)) {
                                if(Adapter.instance.isBroadcaster(n.user.username)){
                                    continue;
                                }
                                channel.postMessage({
                                    type: E.chatEvent,
                                    message: {
                                        type: "user_enter",
                                        data: {
                                            broadcaster: Adapter.instance.getUsername(),
                                            user: {
                                                username: n.user.username,
                                                in_fan_club: n.fanClubTier,
                                                isSubsriber: n.hasFavorited,
                                                gender: -1,
                                                id: n.user.id,
                                                is_mod: n.isAdmin,
                                                isNewAccount: n.isNewAccount,
                                            }
                                        }
                                    }
                                })
                            }
                        }
                        for (var n of last) {
                            if (!nows.any(e => e.user.username == n.user.username)) {
                                if(Adapter.instance.isBroadcaster(n.user.username)){
                                    continue;
                                }
                                channel.postMessage({
                                    type: E.chatEvent,
                                    message: {
                                        type: "user_leave",
                                        data: {
                                            broadcaster: Adapter.instance.getUsername(),
                                            user: {
                                                username: n.user.username,
                                                in_fan_club: n.fanClubTier,
                                                isSubsriber: n.hasFavorited,
                                                gender: -1,
                                                id: n.user.id,
                                                is_mod: n.isAdmin,
                                                isNewAccount: n.isNewAccount,
                                            }
                                        }
                                    }
                                })
                            }
                        }
                    }
                }
                storage(E.viewerCache, json?.members || [])
            }
            if (url && /\/api\/front\/v3\/config\/initial/i.test(url)) {
                //获取通信token
                var msg = typeof data.data.responseData === "string" ? JSON.parse(data.data.responseData) : data.data.responseData;
                if (!msg) {
                    return;
                }
                client = msg.initial.client;
                Adapter.client = {
                    csrfNotifyTimestamp: client.csrfNotifyTimestamp,
                    csrfTimestamp: client.csrfTimestamp,
                    csrfToken: client.csrfToken,
                    cometAuth: client.cometAuth,
                }
                Adapter.userInfo = {
                    id: client.user.id,
                    gender: client.user.gender || client.user.broadcastGender,
                    birthDate: client.user.birthDate,
                    country: client.user.country,
                    username: client.user.username || client.user.login,
                }
            }
        } catch (ex) {

        }
    }
    function sleep(time) {
        return new Promise((res) => {
            setTimeout(() => {
                res();
            }, time || 10);
        })
    }

    function onChannelInit() {
        if (!Adapter.isNormal()) {
            Adapter.init(channel);
        }
    }
    window.addEventListener("message", function (t, a) {
        const data = t.data;
        const { from, type } = data;

        if (from == E.intercept) {
            if (type == E.websocketMessage || type == E.xhrMessage) {
                onChannelMessage(type, data)
            }
            else if (type == E.fecthMessage) {
                onFetchMessage(type, data)
            }
            else if (type == E.domLoaded) {
                chrome.runtime.onConnect.addListener((port) => {
                    if (port.name == E.room) {
                        channel = port;
                        onChannelInit(channel);
                    }
                });
                storage(E.viewerCache, -1);
                postMsg(E.domLoaded, {})
            }
            else if (type == E.pageClosed) {
                postMsg(E.pageClosed, {})
            }
        }
    });
    //tipmenu
    const TipMenu = function () {
        async function sendTips() {
            var index = 0;
            Adapter.instance.sendChatMessage(`----->HoneyPlayBox Toys respond to tips. Here are my levels:`)
            for (var preset of tipMenu.presets) {
                index = index + 1;
                await sleep(200);
                Adapter.instance.sendChatMessage(`----->#${index} ${preset.name} = ${preset.token} Tokens`)
            }
        }
        async function asyncTipRun(params) {


            const r = await postMsg("Fetch-Data", {
                url: "@server/system/tipMenu/selectTipMenuDetailList/forplatform/" + PLATFORM,
                body: {}
            })
            if (!r.success) {
                return;
            }
            var d = r.data;
            if (!d || d.code != 1000) {
                return;
            }
            d = d.data ? d.data[0] : null
            if (!d || !d.enable) {
                tipMenu.active = false;
                return;
            }
            tipMenu.active = d.enable;
            tipMenu.presets = (d.tipMenuPresetDetailList || []).map(el => {
                return {
                    name: el.activityName,
                    token: el.token,
                }
            });
            sendTips();
        }
        class tipMenu {
            static presets = []
            static active = ""
            static timer = 0;
            static duration = 5
            static run(preset, active, config) {
                tipMenu.presets = preset;
                tipMenu.active = active;
                if (config) {
                    tipMenu.duration = config.duration;
                }
                sendTips();
            }
            static start() {
                if (tipMenu.timer) {
                    return
                }
                setTimeout(async () => {
                    await asyncTipRun();
                    tipMenu.timer = setInterval(async () => {
                        await asyncTipRun();
                    }, (this.duration || 5) * 60 * 1000)
                }, 5000)
            }
        }
        return tipMenu;
    }();

    class Adapter {
        getCookie(cookieName) {
            var cookieValue = "";
            if (document.cookie) {
                var cookies = document.cookie.split(';');
                for (var i = 0; i < cookies.length; i++) {
                    var cookie = cookies[i];
                    if (cookie.substring(0, cookieName.length + 2).trim() == cookieName.trim() + "=") {
                        cookieValue = cookie.substring(cookieName.length + 2, cookie.length);
                        return cookieValue;
                    }
                }
            }
            return cookieValue;
        }
        async getUserList() {
            var j = storage(E.viewerCache);
            if (!j) {
                return []
            }
            var list = (tryJson(j) || []).map(el => {
                return {
                    username: el.user.username,
                    colour: "",
                    gender: -1,
                    type: "",
                    colorStr: "",
                    id: el.user.id,
                    isNewAccount: el.isNewAccount,
                    in_fan_club: el.fanClubTier,
                    isSubsriber: el.hasFavorited,
                    isMod: el.isAdmin,
                    raw: JSON.stringify(el)
                }
            })
            return {
                count: list.length,
                usersList: list,
            }
        }
        async getStreamSetting() {
            
            var switchEl = document.querySelector(".external-broadcast-switcher");
            if (switchEl) {
                var clsName = switchEl.className;
                clsName = clsName.split(/\s*/);
                if (clsName.indexOf('external') < 0) {
                    switchEl.click();
                    await sleep(1200);
                }
            }
            // else {
            //     return {
            //         success: false,
            //         data: {
            //             code: 404
            //         }
            //     }
            // }
            var btnEl = document.querySelector("button.external-offline__button");
            if (btnEl) {
                btnEl.click();
                await sleep(1000);
            }
            var serverEl = document.querySelectorAll(".broadcast-specification-header .header-input-wrapper input.clipboardable-input")
            if (serverEl.length > 0) {
                var close =document.querySelector(".broadcast-specification-footer button.btn");
                if(close){
                    close.click()
                }
                return {
                    success: true,
                    data: {
                        username:this.getUsername(),
                        server: serverEl[0]?.value,
                        key: serverEl[1]?.value
                    }
                }
            } else {
                var close =document.querySelector(".broadcast-specification-footer button.btn");
                if(close){
                    close.click()
                }
                return {
                    success: false,
                    data: {
                        code: 404
                    }
                }
            }
        }
        isBroadcaster(username) {
            return this.getUsername() == username;
        }
        getUsername() {
            return Adapter.userInfo?.username || "";
        }
        getLiveState() {
            if (!channel) {
                return "unknow"
            }
            var ele = document.querySelector(".external-player .external-start-show")
            if (ele) {
                return "live";
            }
            var liveState = document.querySelector(".player-panel-status-connection .indicator.live");
            if (liveState) {
                return "live";
            }
            return "close";
        }
        listen() {
            chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
                const { platform, type } = request;
                try {
                    if (!platform || platform != E.fromPlatform) {
                        sendResponse({
                            success: false,
                        })
                        return false;
                    }
                    if (type == E.authToken) {
                        var token = Adapter.instance.getToken();
                        return sendResponse({
                            success: true,
                            data: token
                        })
                    }
                    if (type == E.getUserName) {
                        var username = Adapter.instance.getUsername();
                        return sendResponse({
                            success: true,
                            username: username
                        })
                    }
                    else if (type == E.getViewers) {
                        Adapter.instance.getUserList().then(res => {
                            sendResponse({
                                success: true,
                                data: res,
                            })
                        }).catch(e => {
                            sendResponse({
                                success: false
                            })
                        })
                        return true;
                    } else if (type == E.getLiveState) {
                        return sendResponse({
                            success: true,
                            data: Adapter.instance.getLiveState(),
                        })
                    } else if (type == E.sendChatMessage) {
                        Adapter.instance.sendChatMessage(request.message).then(res => {
                            sendResponse(res)
                        }).catch(e => {
                            sendResponse({
                                success: false
                            })
                        })
                        return true;
                    } else if (type == E.privateMessage) {
                        Adapter.instance.sendPrivateMessage(request.message, request.info?.id).then(res => {
                            sendResponse(res)
                        }).catch(e => {
                            sendResponse({
                                success: false
                            })
                        })
                        return true;
                    } else if (type == E.getStreamSetting) {
                         Adapter.instance.getStreamSetting().then(res => {
                            sendResponse(res)
                        }).catch(e => {
                            sendResponse({
                                success: false
                            })
                        })
                        return true;
                    }
                } catch (ex) {
                    console.error(ex)
                }
                return true
            });
        }
        async syncTipmenu(data) {
            try {
                var preset = {};
                if (Array.isArray(data.preset)) {
                    preset = {
                        preset1: data.preset.map(el => {
                            return {
                                activity: el.name,
                                price: el.token
                            }
                        }),
                        activePreset: data.active || "preset1"
                    }
                } else {
                    preset.activePreset = data.active;
                    for (var item of Object(data.preset)) {
                        preset[item] = (data.preset[item] || []).map(el => {
                            return {
                                activity: el.name,
                                price: el.token
                            }
                        })
                    }
                }

                var pd = {
                    isEnabled: data.enable,
                    csrfNotifyTimestamp: Adapter.client?.csrfNotifyTimestamp,
                    csrfTimestamp: Adapter.client?.csrfTimestamp,
                    csrfToken: Adapter.client?.csrfToken,
                    uniq: randomChar(16),
                    presets: preset
                }
                const resp = await fetch(`/api/front/models/${Adapter.userInfo.id}/tip/menu`, {
                    method: "PUT",
                    mode: "cors",
                    cache: "no-cache",
                    credentials: "same-origin",
                    headers: {
                    },
                    redirect: "follow",
                    referrerPolicy: "strict-origin-when-cross-origin",
                    body: JSON.stringify(pd),
                });
                var json = await resp.json();
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        sendChatMessage(message) {
            try {
                // 设置消息内容并调用发送方法
                const messageWrapper = document.querySelector('.model-chat-controls');
                if (!messageWrapper) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                const messageInput = messageWrapper.querySelector('input');
                if (!messageInput) {
                    sendResponse({ success: false, error: 'cant find message box' });
                    return;
                }
                messageInput.value = message;
                messageInput.textContent = message;

                // 触发输入事件，确保网站检测到内容变化
                messageInput.dispatchEvent(new InputEvent('input', {
                    bubbles: true,
                    cancelable: true,
                    inputType: 'insertText',
                    data: message
                }));
                const sendBtn = messageWrapper.querySelector("button.a11y-button[aria-label=Send]")
                if (!sendBtn) {
                    return { success: false, error: 'cant find send button' };
                }
                sendBtn.click();
                // 调用发送方法
                //const result = this.sendMessage(request.message);
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        async sendPrivateMessage(message, username) {
            try {
                var pd = {
                    body: message,
                    csrfNotifyTimestamp: Adapter.client?.csrfNotifyTimestamp,
                    csrfTimestamp: Adapter.client?.csrfTimestamp,
                    csrfToken: Adapter.client?.csrfToken,
                    uniq: randomChar(16)
                }
                const resp = await fetch(`/api/front/users/${Adapter.userInfo.id}/conversations/${username}/messages`, {
                    method: "post",
                    mode: "cors",
                    cache: "no-cache",
                    credentials: "same-origin",
                    headers: {
                    },
                    redirect: "follow",
                    referrerPolicy: "strict-origin-when-cross-origin",
                    body: JSON.stringify(pd),
                });
                var json = await resp.json();
                //const result = this.sendMessage(request.message);
                return { success: true, message: 'send success' };
            } catch (error) {
                // console.error('发送消息时出错:', error);
                return { success: false, error: 'send error' };
            }
        }
        getToken() {
            return Adapter.client?.csrfToken;
        }
        getId() {
            var data = localStorage.getItem("MOE_DATA") || ""
            if (data) {
                data = tryJson(data);
                if (data) {
                    return data.IDENTITY_MAP?.userIdentities?.uid || ""
                }
            }
            return ""
        }
        isLiving = false
        _ping(isFirst) {

            let liveState = this.getLiveState();
            if (!this.isLiving && liveState == "live") {
                this.isLiving = true;
                Adapter.instance.post(E.chatEvent, {
                    message: {
                        data: {
                            broadcaster:this.getUsername(),
                            user:{
                                username:this.getUsername(),
                                in_fan_club:false,
                            }
                        },
                        type: "broadcast_start",
                    }
                })

            }
            if (this.isLiving && liveState == "close") {
                this.isLiving = false;
                Adapter.instance.post(E.chatEvent, {
                    message: {
                        data: {
                            broadcaster:this.getUsername(),
                            user:{
                                username:this.getUsername(),
                                in_fan_club:false,
                            }
                        },
                        type: "broadcast_stop",
                    }
                })

            }
            this.post(E.ping, {
                url: location.href,
                token: this.getToken(),
                id: this.getId(),
                state: liveState,
                isFirst: isFirst,
                platform: PLATFORM,
                username: this.getUsername(),
                email: "",
            })
        }
        post(type, data) {
            if (channel)
                channel.postMessage({
                    ...data,
                    type,
                })
        }
        ping() {
            this._ping(true)
            setInterval(() => {
                this._ping(false)
            }, 5 * 1000)
        }

        static instance;
        static init(port) {
            channel = port;
            Adapter.instance = new Adapter();
            Adapter.instance.ping();
            Adapter.instance.listen();
            channel.onMessage.addListener(async (request) => {
                const { data, type } = request;
                if (type == E.syncTipmenu) {
                    var r = await Adapter.instance.syncTipmenu(data);
                    if (r) {
                        Adapter.instance.post(E.syncTipmenuCallback, {
                            status: r.success,
                            data: {
                                success: r.success,
                                data: r.data
                            }
                        })
                    }
                }
            })
            channel.onDisconnect.addListener(() => {
                channel = null;
            })
        }
        static isNormal() {
            return !!Adapter.instance;
        }
    }
})()