
(function () {
    const E = {
        fromPlatform: "honey extensions",
        eventDispath: "Event-Dispatch",
        authToken: "Get-Auth-Token",
        tokenKey: "xvibe-key",
        postMessage: "Post-Message",
        postMessageSync: "Post-Message-Sync",
        getConnectedToy: "Get-Connected-Toys",
    }
    var call_index = 0;

    function postSync(type, data, from = "") {
        call_index++;
        const msgId = `call_${new Date().valueOf()}_${call_index}`;
        const message = Object.assign({
            requestId: msgId,
            type: type,
            from: "front",
        }, data || {})

        let timer, handleResponse;

        // 超时处理
        const timerPromise = new Promise((_, reject) => {
            timer = setTimeout(() => {
                if (handleResponse)
                    window.removeEventListener("message", handleResponse);
                reject(new Error("request timeout"));
            }, 3000);
        });
        // 等待响应
        const run = new Promise((resolve, reject) => {
            function handle(event) {
                const { requestId, data, from, error } = event.data;
                // 匹配消息ID且来自扩展
                if (requestId === msgId && from == "front-callback") {
                    clearTimeout(timer);
                    window.removeEventListener("message", handle);
                    if (error) {
                        reject(error);
                    } else {
                        resolve(event.data);
                    }
                }
            }
            handleResponse = handle;
            // 注册响应监听
            window.addEventListener("message", handle);
            window.postMessage(message, location.href);
        });

        //  raced between response and timeout
        return Promise.race([timerPromise, run]);
    }
    chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
        const { platform, type } = request;

        if (type == 'PRE_CHECK_ADD_TOYS' || type == 'PRE_CHECK_SCAN_QR_CODE') {
            const block = document.querySelector('.container-bluetooth-connection-block');
            if (block) {
                block.classList.add('add-toys-shadow-animation');
                setTimeout(() => {
                    block.classList.remove('add-toys-shadow-animation');
                }, 5000);
            }
        } else if (type == 'PRE_CHECK_CONNECT_VIDEO_FEEDBACK' || type == 'PRE_CHECK_EXTERNAL_OPEN_OBS') {
            console.log('front.js ', request);
            window.postMessage({
                type: type,
                platform: platform
            }, location.href);
        }

        if (!platform && platform != E.fromPlatform) {
            return sendResponse({
                success: true,
            })
        }
        if (request.type === E.authToken) {
            const token = localStorage.getItem(E.tokenKey)
            return sendResponse({ data: token });
        }
        else if (type == E.eventDispath) {
            window.dispatchEvent(new CustomEvent(request.event, {
                detail: JSON.stringify(
                    {
                        from: platform,
                        data: request.data
                    }
                )
            }))
            return sendResponse({
                success: true,
            })
        }
        else if (type == E.postMessage) {
            window.postMessage(request.data)
            return sendResponse({
                success: true,
            })
        }
        else if (type == E.postMessageSync) {
            postSync(request.data.type, request.data).then(e => {
                return sendResponse({
                    success: true,
                    data: e.data
                })
            }).catch(e => {
                return sendResponse({ success: false, })
            })
            return true;
        }
        return sendResponse({
            success: false,
        });
    });

})();