
(function () {
    const PLATFORM = ""
    let channel = null;

    function onChannelMessage(type, data) {
        if (Adapter.isNormal()) {
            Adapter.instance.post(type, data);
        }
    }

    function onChannelInit() {
        if (!Adapter.isNormal()) {
            Adapter.init(channel);
        }
    }

    window.addEventListener("message", function (t, a) {
        const data = t.data;
        const { from, type } = data;
        if (from == "honey-intercept") {
            //来自joystick
            if (["X-WebSocket-Message", "X-Fetch-Message", "X-XHR-Message"].includes(type)) {
                onChannelMessage(type, data)
            }
            else if (type == "X-Page-DOMContentLoaded") {
                chrome.runtime.onConnect.addListener((port) => {
                    if (port.name == "room") {
                        channel = port;
                        onChannelInit(channel);
                    }
                });
                postMsg("X-Page-DOMContentLoaded", {})
            }
            else if (type == "X-Page-Close") {
                postMsg("X-Page-Close", {})
            }
        } else {

        }
    });
    class Adapter {
        getCookie(cookieName) {
            var cookieValue = "";
            if (document.cookie) {
                var cookies = document.cookie.split(';');
                for (var i = 0; i < cookies.length; i++) {
                    var cookie = cookies[i];
                    if (cookie.substring(0, cookieName.length + 2).trim() == cookieName.trim() + "=") {
                        cookieValue = cookie.substring(cookieName.length + 2, cookie.length);
                        return cookieValue;
                    }
                }
            }
            return cookieValue;
        }
        getUserList() {
            return []
        }
        getUsername() {
            var el = document.querySelector(".user_information_header_username");
            if (el) {
                return (el.innerHTML || "").trim()
            }
            return ""
        }
        getLiveState() {
            if (!channel) {
                return "unknow"
            }
            var ele = document.querySelector("#OBSOverlay .roomStatus")
            if (ele) {
                var status = (ele.innerHTML || "").trim();
                if (status == "offline") {
                    return "close"
                }
                return "live";
            }
            return "close";
        }
        init() {

        }
        getToken() {
            return ""
        }
        _ping() {
            honey$Ext.username = honey$Ext.getUsername();
            honey$Ext.token = honey$Ext.getCookie("csrftoken");
            //OBSOverlay
            let liveState = honey$Ext.getLiveState();

            this.post("X-Ping", {
                url: location.href,
                token: this.getToken(),
                liveState: liveState,
                platform: PLATFORM,
                username: this.getUsername()
            })
        }
        post(type, data) {
            if (channel)
                channel.postMessage({
                    ...data,
                    type,
                })
        }
        ping() {
            this._ping()
            setInterval(() => {
                this._ping(false)
            }, 5 * 1000)
        }

        static instance;
        static init(port) {
            channel = port;
            Adapter.instance = new Adapter();
            Adapter.instance.ping();
        }
        static isNormal() {
            return !!Adapter.instance;
        }
    }
})()