const config = {
    version: "1.5.1",
    debug: true,
    //环境切换
    localBaseUrl: "http://127.0.0.1:18080",
    // localBaseUrl: "http://127.0.0.1:19090",//连接器端
    serverBaseUrl: "https://api.honeyplaybox.com",
    websocketUrl: "wss://api.honeyplaybox.com/",
    hostname: ["platform-test.vibexcast.com", "app.vibe-connect.net", "localhost", "platform-test.vibexcast.com"],
    pages: {
        chatbox: {//环境切换
            url: "https://app.vibe-connect.net/chatbox",
            // url: "http://localhost:5173/chatbox",
            width: 880,
            height: 800,
            type: "panel",
            alwaysOnTop: true,
        },
        front: {//环境切换
            url: "https://app.vibe-connect.net/",
            loginUrl: "https://app.vibe-connect.net/login"
            // url: "http://localhost:5173/",
            // loginUrl: "http://localhost:5173/login"
        }
    },
    platform: {
        //平台对应code
        joystick: "joystick",
        chaturbate: "chaturbate",
        chaturbatetest: "chaturbatetest",
        stripchat: "stripchat",
        camsoda: "camsoda",
        myfreecams: "myfreecams",
        camversity: "camversity",
        manyvids: "manyvids",
        bongacams: "bongacams",
        // xham: "xham",
        tiwistter: "tiwistter"
    },
    front: {//环境切换
        pattern: "*://app.vibe-connect.net/*"
        // pattern: "*://localhost:*/*",
    },
    urls: {
        joystick: {
            domain: "joystick.tv",
            pattern: "*://joystick.tv/*",
            roomPage: ':\/\/joystick.tv\/publisher*',
            roomPagePatten: "*://joystick.tv/publisher*",
            websocket: {

            },//
            xhr: {

            }
        },
        chaturbate: {
            domain: "chaturbate.com",
            pattern: ["*://*.chaturbate.com/*"],
            roomPage: ':\/\/.*chaturbate.com\/b*',
            roomPagePatten: [
                "*://chaturbate.com/b/*",
                "*://*.chaturbate.com/b/*",
            ],
            websocket: {
                chat: /wss:\/\/realtime.pa.highwebmedia.com*/i,
            },
            xhr: {
            }
        },
        chaturbatetest: {
            domain: "www.testbed.cb.dev",
            pattern: ["*://www.testbed.cb.dev/*"],
            roomPage: ':\/\/.*.testbed.cb.dev\/b*',
            roomPagePatten: [
                "*://www.testbed.cb.dev/b/*"
            ],
            websocket: {
                chat: /wss:\/\/realtime.pa.highwebmedia.com*/i,
            },
            xhr: {
            }
        },
        stripchat: {
            domain: "stripchat.com",
            pattern: "*://stripchat.com/*",
            roomPage: ':\/\/stripchat.com\/*',
            roomPagePatten: "*://stripchat.com/*",
            websocket: {
                chat: /wss:\/\/websocket-sp-v[\d]+.stripchat.com\/connection\/websocket/i
            },
        },
        camsoda: {
            domain: "camsoda.com",
            pattern: "*://www.camsoda.com/*",
            roomPage: ':\/\/www.camsoda.com\/*',
            roomPagePatten: "*://www.camsoda.com/*",
            websocket: {
                chat: /wss:\/\/node2-ord.livemediahost.com:/,
                chat3000: /wss:\/\/node2-ord.livemediahost.com:3000/
            },
        },
        camversity: {
            domain: "camversity.com",
            pattern: "*://www.camversity.com/*",
            roomPage: ':\/\/www.camversity.com\/*',
            roomPagePatten: "*://www.camversity.com/*",
            websocket: {
                chat: /wss:\/\/node2-ord.livemediahost.com:/,
                chat3000: /wss:\/\/node2-ord.livemediahost.com:3000/
            },
        },
        myfreecams: {
            domain: "myfreecams.com",
            pattern: "*://www.myfreecams.com/*",
            roomPage: ':\/\/www.myfreecams.com\/*',
            roomPagePatten: "*://www.myfreecams.com/modelweb/*",
            websocket: {
                chat: /wss:\/\/wchat64.myfreecams.com\/fcsl/
            },
            worker: {
                chat: /wsw.js/i
            }
        },
        manyvids: {
            domain: "manyvids.com",
            pattern: "*://www.manyvids.com/*",
            roomPage: ':\/\/www.manyvids.com\/live/cam/*',
            roomPagePatten: "*://www.manyvids.com/live/cam/*",
            websocket: {

            },//
            xhr: {
            }
        },
        bongacams: {
            domain: "bongacams.com",
            pattern: "*://bongacams.com/*",
            roomPage: ':\/\/bongacams.com\/live/cam/*',
            roomPagePatten: "*://bongacams.com/live/cam/*",
            websocket: {

            },//
            xhr: {
            }
        },
        tiwistter: {
            domain: "tiwistter.com",
            pattern: "*://hpb-manage-test.vibexcast.com/*",
            roomPage: ':\/\/hpb-manage-test.vibexcast.com\/*',
            roomPagePatten: "*://hpb-manage-test.vibexcast.com/*",
            websocket: {
            },//
            xhr: {
            }
        },
    },
    platform_patterns: [],
    platform_api_patterns: [
        '*://plausible.joystick.tv/*',
        '*://joystick.tv/cable*',
        '*://joystick.tv/v1/graphql*'
    ],
    constains: {
        getToken: ""
    }
};

const c = {
    ping: "PING",
    extensionsStatus: "Get-Extensions-Status",
    sendMsg: "EXTERNAL_SEND_MESSAGE",
    platformForChat: "Get-Platform-For-Chat",
    platformForLive: "Get-Platform-For-Living",
    fetch: "Fetch-Data",
    getViewers: "Get-Viewers",
    openChatBox: "Open-Chatbox",
    tipAnimationChanges: "Tip-Animation-Changed",
    userLogout: "User-Logout",
    userLogin: "User-Login",
    dispatch: "Event-Dispatch",
    websocket: "X-WebSocket-Message",
    xworker: "X-Worker-Message",
    xhr: "X-XHR-Message",
    xfetch: "X-Fetch-Message",
    chatEvent: "Chat-Event",
    xping: "X-Ping",
    toOffscreen: "Transfer-To-Offscreen",
    toOffscreenUdf: "Transfer-To-Offscreen-UDF",
    toOffscreenSync: "Transfer-To-Offscreen-Sync",
    offscreenUDF: "Offscreen-UDF",
    domloaded: "X-Page-DOMContentLoaded",
    pageClose: "X-Page-Close",
    pageClosing: "X-Page-Closing",
    pingOffscreen: "Offscreen-Ping",
    interactUser: "Interact-With-User",
    sdkEvent: "SDK-Event",
    openUrl: "Open-Url",
    openExtPage: "Open-Extension-Page",
    transferPlatformsAction: "Transfer-Platforms-Action",
    transferPlatformAction: "Transfer-Platform-Action",
    pingFromPlatform: "Ping-From-Platform"
}

const isVCBrowser = () => {
    return window.navigator.userAgent.indexOf("VibeConnect") > -1
}
if (!isVCBrowser()) {
    config.localBaseUrl = "http://127.0.0.1:19090"
}

const isMatchs = (regs, url) => {
    if (Array.isArray(regs)) {
        return regs.any(r => r.test(url))
    }
    return regs.test(url)
}
const postMsg = (d) => {
    window.parent.postMessage(d, "*")
}
const log = (...args) => {
    if (!config.debug) {
        return
    }
    console.log(...args);
};
const err = (...args) => {
    if (!config.debug) {
        return
    }
    console.error(...args);
};
const tryJson = (raw) => {
    try {
        return JSON.parse(raw);
    } catch (e) {
        return;
    }
}

//#region 加载完成，注入config
//加载成功
(function () {

    const local = {
        async post(interfaceUrl, data) {
            try {
                var body = typeof data == "string" ? data : JSON.stringify(data);
                const response = await fetch(config.localBaseUrl + interfaceUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: body
                });
                return response
            } catch (ex) {
                throw ex
            }
        },
        postEvent(data, platform) {
            if (data.type == "tip") {
                AudioController.play("tip");
            }
            else if (data.type === "chat_message") {
                AudioController.play("message");
            }
            else if (data.type === "private_message") {
                AudioController.play("message");
            }
            // chatbox.accept(platform,data);

            // 如果在手机端直播，则不发送事件
            if (PlatformProcessor.platforms[platform].client == "mobile" && PlatformProcessor.platforms[platform].living) {
                return;
            }

            // server.chatMessage(data, platform);
            // local.post(`/api/v1/platform/${platform}/postevents`, data);
            chrome.runtime.sendMessage("cfdhahmmdgobpcombidffgclfnncbdlj", {
                type: "Fetch-Data",
                data: {
                    url: `${config.localBaseUrl}/api/v1/platform/${platform}/postevents`,
                    method: "post",
                    requestBody: data
                }
            }, (response) => {
                // 回调函数：接收 Worker 的回复（可选）
                // if (chrome.runtime.lastError) {
                //     console.error("消息发送失败：", chrome.runtime.lastError);
                //     return;
                // }
                // console.log("收到 Worker 回复：", response);
            });
        }
    }

    // sendTips("test tip");
    // function sendTips(tip) {
    //     function _() {
    //         local.postEvent({
    //             type: "tip",
    //             platform:"chaturbate",
    //             meta:{
    //                 today:0,
    //                 past:0,
    //                 tag:"new",
    //                 color:"grey"
    //             },
    //             data:{
    //                 user:{
    //                     username:"tipper1",
    //                     in_fan_club:false,
    //                     gender:0,
    //                     has_token:true,
    //                     recent_tips:"tons",
    //                     is_mod:false,
    //                 },
    //                 tip:{
    //                     tokens:10,
    //                     is_annon:false,
    //                     message:tip||""
    //                 },
    //                 overlayer:{

    //                 }
    //             }

    //         }, "chaturbate");
    //         setTimeout(() => {
    //             _();
    //         }, 3000);
    //     }
    //     setTimeout(() => {
    //         _();
    //     }, 3000);
    // }


    class PlatformProcessor {
        static onWebsocket(platform, data, reqId) {
            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].onWebsocket(data, reqId)
        }

        static onWorker(platform, data, reqId) {
            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].onWorker(data, reqId)
        }
        static onFetch(platform, data, reqId) {

            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].onFetch(data, reqId)
        }

        static onXHR(platform, data, reqId) {
            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].onXHR(data, reqId)
        }

        static onPing(platform, data, reqId) {
            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].onPing(data, reqId)
        }
        static sdkEvent(platform, data, reqId) {
            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].sdkEvent(data, reqId)
        }
        static onChatEvent(platform, data, reqId) {
            if (!this.platforms[platform]) {
                return;
            }
            this.platforms[platform].onChatEvent(data, reqId)
        }
        static onUserDefined(platform, data, reqId, evt) {
            if (!this.platforms[platform]) {
                return;
            }
            const type = data.type, d = data.data;
            if (server.UserDefinedCaller[type]) {
                return server.UserDefinedCaller[type](d, reqId, evt);
            }
            const processor = this.platforms[platform];

            processor && processor[type] && processor[type](d, reqId, evt);
        }
        platform = ""
        constructor(platform) {
            this.platform = platform;
        }

        onWebsocket(req, reqId) {

        }
        onWorker(req, reqId) {

        }
        onXHR(req, reqId) {

        }

        onChatEvent(req, reqId) {
            req.platform = this.platform;

            local.postEvent(req.data, this.platform)
        }
        profile = null
        onPing(req, reqId) {
            this.profile = req;
        }

        onFetch(req, reqId) {

        }

        static platforms = {

        }

        static register(platform, method) {
            var proccessor = new PlatformProcessor(platform);
            Object.assign(proccessor, method || {})
            this.platforms[platform] = proccessor;
            return proccessor;
        }
    }

    const extensions = {
        channel: null,
        id: "",
        callback(ok, type, requestId, data) {
            if (!extensions.channel) {
                return;
            }
            return extensions.channel.postMessage({
                ok,
                type: type + "-callback",
                requestId,
                data,
            })
        },
        postSync(data, timeout) {
            if (!extensions.channel || !data) {
                return Promise.resolve(null);
            }
            data = data || {}
            var reqId = new Date().valueOf() + `${data.type || "_"}`;
            var t = this;
            return new Promise((res, rej) => {
                // 定义消息处理函数
                function handleMessage(message) {
                    if (message.requestId != reqId && message.callbackId && message.callbackId == reqId) {
                        // 处理消息...
                        extensions.channel.onMessage.removeListener(handleMessage);
                        res(message);
                    }
                }
                if (timeout) {
                    setTimeout(() => {
                        extensions.channel.onMessage.removeListener(handleMessage);
                        rej()
                    }, timeout);
                }
                extensions.channel.onMessage.addListener(handleMessage);
                extensions.channel.postMessage({
                    ...data,
                    requestId: reqId,
                })
            })
        },
        connect() {
            try {
                extensions.channel = chrome.runtime.connect(extensions.id, { name: "offscreen-iframe" });

                extensions.channel.onMessage.addListener((msg) => {
                    // console.log("offscreen-iframe-connect", msg.type, msg)
                    const { type, data, platform, requestId } = msg;
                    switch (type) {
                        case c.xworker:
                            PlatformProcessor.onWorker(platform, data, requestId);
                            break;
                        case c.websocket:
                            PlatformProcessor.onWebsocket(platform, data, requestId);
                            break;
                        case c.xfetch:
                            PlatformProcessor.onFetch(platform, data, requestId);
                            break;
                        case c.xhr:
                            PlatformProcessor.onXHR(platform, data, requestId);
                            break;
                        case c.chatEvent:
                            PlatformProcessor.onChatEvent(platform, data, requestId);
                            break;
                        case c.toOffscreen:
                            PlatformProcessor.onUserDefined(platform, data, requestId, msg);
                            break;
                        case c.pingOffscreen:
                            PlatformProcessor.onPing(platform, data, requestId);
                            break;
                        case c.sdkEvent:
                            PlatformProcessor.sdkEvent(platform, data, requestId);
                            break;
                        case c.pingFromPlatform:
                            if (data.liveState == 1) {//直播中
                                server.liveHeartbeat(data.platform);
                            }
                            break;
                        case "sync-user-token":
                            server.setToken(data.token);
                            break;
                        case c.toOffscreenSync:
                            PlatformProcessor.onUserDefined(platform, data, requestId, msg);
                            break;
                        case "Get-Tip-Rule-Settings":
                            server.UserDefinedCaller['Get-Tip-Rule-Settings'](data, requestId, msg);
                            break;
                        case "Get-Tip-Rule-Settings":
                            server.UserDefinedCaller['Get-Tip-Rule-Settings'](data, requestId, msg);
                            break;
                        case "ToyConnector-Mode-Changed":
                            monitoringStatus.setToyMode(data.data)
                            break;
                        case "OBS-mode-Changed":
                            monitoringStatus.setIsExternalObs(data.data)
                            break;
                        case "usb-status":
                            monitoringStatus.setUsb(data);
                            break;
                    }
                })
            } catch (ex) {
                err(ex);
            }
            try {
                setTimeout(() => {

                    if (extensions.channel) {
                        extensions.channel.postMessage({
                            type: "User-Scripts-Register",
                            data: {
                                id: "chaturbate-cb-app-script",
                                type: "file",
                                path: "https://extensions.vibexcast.com/prods/sites-app/chaturbate/chaturbate-app.js",//"/sites/chaturbate-app.js", //`https://extensions.vibexcast.com/test/sites-app/chaturbate/chaturbate-app.js`,
                                urls: [
                                    "*://directory-v3-live.cb.dev/*"
                                ],
                                allFrames: true,
                                runAt: "document_start"
                            },
                            platform: config.platform.chaturbate,
                        })

                        if (isVCBrowser()) {
                            const allRoomPagePatterns = [];
                            Object.values(config.urls).forEach(urlObj => {
                                if (urlObj.roomPagePatten) {
                                    if (Array.isArray(urlObj.roomPagePatten)) {
                                        allRoomPagePatterns.push(...urlObj.roomPagePatten);
                                    } else if (typeof urlObj.roomPagePatten === 'string') {
                                        allRoomPagePatterns.push(urlObj.roomPagePatten);
                                    }
                                }
                            });

                            extensions.channel.postMessage({
                                type: "User-Scripts-Register",
                                data: {
                                    id: "inject-view-script",
                                    type: "file",
                                    path: "https://extensions.vibexcast.com/prods/sites-app/js/injected-view.js?t=" + Date.now(),
                                    urls: allRoomPagePatterns,
                                    allFrames: false,
                                    runAt: "document_start"
                                }
                            })
                        }

                    }
                }, 60)
            } catch (ex) {
                console.log("register script exception", ex)
            }
        }
    };

    const browserType = function () {
        if (window.navigator.userAgent.indexOf("VibeConnect") > -1) {
            return "VibeConnect"
        }
        const userAgent = navigator.userAgent;
        // 判断 Edge（优先，因为 Edge 也包含 Chrome 标识）
        if (userAgent.includes('Edg/')) {
            return 'Edge';
        }
        // 判断 Chrome（排除 Edge 后）
        if (userAgent.includes('Chrome/')) {
            return 'Chrome';
        }
        // 判断 Safari（排除 Chrome/Edge 后，包含 Safari 标识）
        if (userAgent.includes('Safari/')) {
            return 'Safari';
        }
        // 其他浏览器
        return '';
    }()

    const server = function () {
        let ws = null
        const TYPE = "web_scheduler";
        let UserToken = ""

        function send(data) {
            if (!ws || ws.readyState != ws.OPEN) {
                return;
            }
            return ws.send(typeof data != "string" && !(data instanceof Blob) ? JSON.stringify(data) : data)
        }

        function disconnect() {
            if (!ws || ws.readyState != ws.OPEN) {
                return;
            }
            ws.close(3111);
        }
        function ping() {

            function _() {
                send({
                    "businessType": "ping",
                    "source": TYPE,
                    "value": null
                })
                if (!ws || ws.readyState != ws.OPEN) {
                    return;
                }
                setTimeout(() => {
                    _();
                }, 60 * 1000);
            }
            setTimeout(() => {
                _();
            }, 60 * 1000);

            _();
        }
        async function callMessage(data) {
            try {
                switch (data.businessType) {
                    case "live_status":
                        var living = data.status == "start" ? true : false;
                        var platform = await server.getPlatformId(data.value.platformId);
                        PlatformProcessor.platforms[platform.code].client = data.source == "app" ? "mobile" : "pc";
                        PlatformProcessor.platforms[platform.code].living = living;
                        if (living) {
                            PlatformProcessor.platforms[platform.code].livingId = data.livePlatformId || null;
                        } else {
                            PlatformProcessor.platforms[platform.code].livingId = null
                        }
                        if (data.source == "app") {
                            extensions.channel.postMessage({
                                type: "living-mobile-change",
                                data: {
                                    livePlatformId: data.livingId,
                                    platform: platform.code,
                                    living: living
                                }
                            })
                        }
                        break;
                    case "logout":
                        //退出登录
                        extensions.channel.postMessage({
                            type: "user-logout",
                            data: {
                                platform: data.platformCode,
                            }
                        })
                        break;
                    case "tip_test":
                        AudioController.play("tip");
                        break;
                    case "notification_sound":
                        if (data.value.notifcationCode == "reward_notification_sound") {
                            if (data.value.enabled) {
                                AudioController.get("tip")?.enable();
                            } else {
                                AudioController.get("tip")?.disable();
                            }
                        } else if (data.value.notifcationCode == "message_notification_sound") {
                            if (data.value.enabled) {
                                AudioController.get("message")?.enable();
                            } else {
                                AudioController.get("message")?.disable();
                            }
                        }
                        break;
                    case "quantity_electricity":
                        if (data?.source !== 'local') {
                            extensions.channel.postMessage({
                                type: "toyconnector-sync-list",
                                data: {
                                    devices: (data.value || []).map((el) => {
                                        var uuid = el.sn
                                        return {
                                            battery: parseInt(el.quantityElectricity),
                                            bt_name: "",
                                            productId: el.productId,
                                            icon_url: el.iconUrl,
                                            in_use: true,
                                            from: "app",
                                            canTurnon: false,
                                            product: typeof el.productInfo == "string" ? JSON.parse(el.productInfo) : el.productInfo,
                                            name: el.name,
                                            uuid: uuid,
                                            sn: el.sn,
                                            status: "connected"
                                        }
                                    })
                                }
                            })
                        }
                        break;
                    case "tip_command":
                        //玩具震动
                        break;
                    case "app_match_pc":
                        extensions.channel.postMessage({
                            type: "toyconnector-sync-list",
                            data: {
                                devices: []
                            }
                        })
                }
            } catch (ex) {
                console.log("callMessage", ex)
            }
        }
        async function syncPlatform() {
            try {
                const response = await fetch(`${config.serverBaseUrl}/system/anon/streamer/platform`, {
                    method: "get",
                    headers: {
                        'Content-Type': 'application/json',
                    }
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        server.PLATFORMS = data.data || [];
                    }
                }
            } catch (e) {
                return []
            }
        }
        async function getPlatformById(platform) {
            if (!server.PLATFORMS || !server.PLATFORMS.length) {
                await syncPlatform();
            }
            if (!server.PLATFORMS || !server.PLATFORMS.length) {
                return Promise.resolve(null);
            }
            for (var i of server.PLATFORMS) {
                if (i.id == platform) {
                    return Promise.resolve(i);
                }
            }
            return Promise.resolve(null);
        }
        async function getPlatformId(platform) {
            if (!server.PLATFORMS || !server.PLATFORMS.length) {
                await syncPlatform();
            }
            if (!server.PLATFORMS || !server.PLATFORMS.length) {
                return Promise.resolve(null);
            }
            for (var i of server.PLATFORMS) {
                if (i.code == platform) {
                    return Promise.resolve(i.id);
                }
            }
            return Promise.resolve(null);
        }
        async function getTipRules(platform) {
            try {
                const response = await fetch(`${config.serverBaseUrl}/system/toyReactionRules/listByCode`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${UserToken}`,
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        platformCode: platform
                    })
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        //手机端开始监听
                        return data.data || [];
                    }
                }
            } catch (e) {
                return []
            }
        }

        async function liveHeartbeat(platform) {
            try {
                var livePlatformId = PlatformProcessor.platforms[platform]?.livingId || null;
                if (livePlatformId) {
                    const response = await fetch(`${config.serverBaseUrl}/system/liveSession/heartbeat`, {
                        method: "POST",
                        headers: {
                            'Authorization': `Bearer ${UserToken}`,
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: "livePlatformId=" + livePlatformId
                    });
                    if (response.ok) {

                    }
                }
            } catch (e) {
                console.log("-------->chat message error", e)
                return []
            }
        }
        async function chatMessage(data, platform) {
            var pd = {
                "liveUserName": data.data.broadcaster,
                "streamerPlatformId": await server.getPlatformId(platform),
                "livePlatformId": PlatformProcessor.platforms[platform]?.livingId || null,
                "recentTips": data.data.user?.recent_tips,
                "businessType": data.type,
                "inFanClub": data.data.user?.in_fan_club,
                "hasTokens": data.data.user?.has_token,
                "isMod": data.data.user?.is_mod,
                "isSubscriber": data.data.user?.is_subscriber,
                "gender": data.data.user?.gender,
                "message": data.message?.message,
                "messageType": 0,
                "viewerUserName": data.data.user?.name,
                "tipMessage": data.data.tip?.message,
                "amount": data.data.tip?.tokens,
                "isAnon": data.data.tip?.is_anon,
                "tokens": data.data.tip?.tokens
            }
            try {
                const response = await fetch(`${config.serverBaseUrl}/system/liveSession/chathistory`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${UserToken}`,
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(pd)
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        //手机端开始监听
                        return data.data || [];
                    }
                }
            } catch (e) {
                console.log("-------->chat message error", e)
                return []
            }
            //关播
            if (pd.businessType == "broadcast_stop") {
                try {
                    var livePlatformId = PlatformProcessor.platforms[platform]?.livingId || null;
                    if (livePlatformId) {
                        const response = await fetch(`${config.serverBaseUrl}/system/liveSession/close`, {
                            method: "POST",
                            headers: {
                                'Authorization': `Bearer ${UserToken}`,
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                livePlatformId: livePlatformId,
                                startTime: new Date().getTime()
                            })
                        });
                        if (response.ok) {

                        }
                    }
                } catch (e) {
                    console.log("-------->chat message error", e)
                    return []
                }
            }
            //开播
            if (pd.businessType == "broadcast_start") {
                try {
                    await getPlatformLiveStatus();
                    //如果客户端信息没有、或者不是mobile的话，则认为是pc端开播
                    if (!PlatformProcessor.platforms[platform].client || PlatformProcessor.platforms[platform].client != "mobile") {
                        var platFormId = await server.getPlatformId(platform)
                        const response = await fetch(`${config.serverBaseUrl}/system/liveSession/open`, {
                            method: "POST",
                            headers: {
                                'Authorization': `Bearer ${UserToken}`,
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                streamerPlatformId: platFormId,
                                liveUserName: pd.liveUserName,
                                startTime: new Date().getTime(),
                                platformPage: "",
                                source: "pc",
                            })
                        });
                        if (response.ok) {
                            var rsp = await response.json();
                            var livePlatformId = rsp.data;
                            PlatformProcessor.platforms[platform].client = "pc";
                            PlatformProcessor.platforms[platform].living = true;
                            PlatformProcessor.platforms[platform].livingId = livePlatformId;
                        }

                    }
                } catch (e) {
                    console.log("-------->chat message error", data, e)
                    return []
                }
            }
        }

        async function getTipMenus(platform) {
            try {
                const response = await fetch(`${config.serverBaseUrl}/system/tipMenu/selectTipMenuDetailList/forplatform/${platform}`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${UserToken}`,
                        'Content-Type': 'application/json',
                    }
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        return data.data || [];
                    }
                }
            } catch (e) {
                return []
            }
        }

        async function connect() {
            try {
                const response = await fetch(`${config.serverBaseUrl}/system/socket/getQRCode`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${UserToken}`,
                        'Content-Type': 'application/json',
                    },
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        //手机端开始监听
                        setTimeout(() => {
                            connecting(data.data);
                        }, 100)
                    }
                }
            } catch (e) {
                console.log("---connect websocket err", e)
            }
        }

        async function loadNotificationSoundAlert() {
            try {
                if (!UserToken) {
                    return;
                }
                const response = await fetch(`${config.serverBaseUrl}/system/chatbox/notifcation/sound/list`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${UserToken}`,
                        'Content-Type': 'application/json',
                    },
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        for (var item of data.data) {
                            if (item.notificationCode == "reward_notification_sound") {
                                if (item.enabled) {
                                    AudioController.get("tip")?.enable();
                                } else {
                                    AudioController.get("tip")?.disable();
                                }
                            } else if (item.notificationCode == "message_notification_sound") {
                                if (item.enabled) {
                                    AudioController.get("message")?.enable();
                                } else {
                                    AudioController.get("message")?.disable();
                                }
                            }
                        }
                    }
                }
            } catch (e) {
                console.log("getPlatformLiveStatus failed", e)
            }
        }

        /**
         * 启动时，加载插件，获取各平台的直播推流状态
         */
        async function getPlatformLiveStatus() {
            try {
                const response = await fetch(`${config.serverBaseUrl}/system/liveSession/selectliveSession`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${UserToken}`,
                        'Content-Type': 'application/json',
                    },
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        var livingPlatforms = [];
                        for (var item of data.data) {
                            if (!PlatformProcessor.platforms[item.platformCode]) {
                                PlatformProcessor.platforms[item.platformCode] = {};
                            }
                            PlatformProcessor.platforms[item.platformCode].client = item.source == "app" ? "mobile" : "pc";
                            PlatformProcessor.platforms[item.platformCode].living = true;
                            PlatformProcessor.platforms[item.platformCode].livingId = item.livePlatformId;
                        }
                        for (var platformCode in PlatformProcessor.platforms) {
                            if (!livingPlatforms.includes(platformCode)) {
                                PlatformProcessor.platforms[platformCode].client = null
                                PlatformProcessor.platforms[platformCode].living = false;
                                PlatformProcessor.platforms[platformCode].livingId = null;
                            }
                        }
                    }
                }
            } catch (e) {
                console.log("getPlatformLiveStatus failed", e)
            }
        }

        let isConnecting = false;
        /**
         * 连接websocket web_scheduler
         * @param {*} channelId 
         * @returns 
         */
        function connecting(channelId) {
            try {
                if (ws) {
                    return;
                }
                log("----------->connecting", channelId)
                var url = `${config.websocketUrl}tip?type=${TYPE}&channelId=${channelId}&osVersion=${browserType}&clientVersion=${config.version}`;

                if (ws) {
                    return;
                }
                ws = new WebSocket(url);
                ws.addEventListener("message", function (event) {
                    var d = event.data;
                    log("-------->message", d)
                    if (typeof d == "string") {
                        d = JSON.parse(d)
                    }
                    callMessage(d)
                })
                ws.addEventListener("close", function (e) {
                    ws = null;
                    if (e.code == 3111) {
                        //手动close 关闭，不自动连接
                    } else {
                        connecting(channelId);
                    }
                });
                ws.addEventListener("open", function (e) {
                    ping();
                });
                log("-------->connecting success")
                return ws;
            } catch (ex) {
                log("-------->connecting failed", ex)
                if (!ws || ws.readyState != ws.OPEN) {
                    setTimeout(() => {
                        connecting(channelId)
                    }, 5000)
                }
            }
        }

        async function prepare() {
            try {
                await getPlatformLiveStatus();
                await loadNotificationSoundAlert();
            } catch (ex) {
                log("prepare throw exception---", ex)
            }
        }

        const UserDefinedCaller = {
            "Get-Tip-Menu-Settings"(data, reqId, msg) {
                getTipMenus(data?.platform)?.then(res => {
                    extensions.callback(true, msg.type, reqId, res)
                })
            },
            "Get-Tip-Rule-Settings"(data, reqId, msg) {
                getTipRules(data?.platform)?.then(res => {
                    extensions.callback(true, msg.type, reqId, res)
                })
            },
        }
        return {
            async setToken(token) {
                UserToken = token;
                // await storage("vc.token", token)
                // if (token && UserToken && token != UserToken) {
                await prepare();
                // }
                if (ws && ws.readyState == ws.OPEN) {
                    ws.close(3111);
                }
                connect();
                setTimeout(() => {
                    if (ObsClient) {
                        ObsClient.reconnect();
                    }
                })
            },
            getToken() {
                return UserToken
            },
            syncPlatform,
            chatMessage,
            PLATFORMS: [],
            getPlatformId,
            getPlatformById,
            UserDefinedCaller,
            connect,
            getTipMenus,
            getTipRules,
            disconnect,
            ping,
            send,
            liveHeartbeat
        }
    }();

    //#region 音频播放
    class AudioController {
        get src() {
            return this.audio?.src;
        }
        isPlaying = false
        enabled = true
        constructor(src) {
            if (this.audio) {
                this.audio.remove();
            }
            this.audio = new Audio();
            this.enabled = true;
            // 监听时间更新事件
            this.audio.addEventListener('timeupdate', () => {
                // if (this.audio.duration) {
                //     const progress = audio.currentTime / audio.duration;
                // }
            });
            // 播放结束时更新状态
            this.audio.addEventListener('ended', () => {
                this.isPlaying = false;
            });
            if (src)
                this.audio.src = src;
        }
        static async create(src, name) {
            const audio = new AudioController(src);
            if (src)
                await audio.load();
            if (name) {
                AudioController[name] = audio;
                audio.name = name;
            }
            return audio;
        }

        static play(name) {
            var audio = this.get(name);
            if (!audio) {
                return
            }
            return audio.play();
        }
        static get(name) {
            return AudioController[name];
        }
        load() {
            return this.audio.load();
        }
        stop() {
            this.audio.pause();
            this.audio.currentTime = 0;
            this.isPlaying = false;
        }
        pause() {
            this.audio.pause();
            this.isPlaying = false;
        }
        seek(seek) {
            this.audio.currentTime = seek;
        }
        volume(volume) {
            this.audio.volume = volume;
        }
        mute(params) {
            this.audio.muted = params;
        }
        async play(src) {

            if (src) {
                this.audio.src = src;
                await audio.load();
            }
            if (this.isPlaying) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            this.isPlaying = true;
            return await this.audio.play().then(() => {
                this.isPlaying = false;
            }).finally(() => {
                this.isPlaying = false;
            })
        }
        enable() {
            return this.enabled = true;
        }
        disable() {
            return this.enabled = false;
        }
        dispose() {
            if (this.audio) {
                this.audio.remove()
            }
        }
    };

    (async function () {
        await AudioController.create("https://static-cdn.vibexcast.com/static-resource/mp4/message_voice.mp3", "message")
        await AudioController.create("https://static-cdn.vibexcast.com/static-resource/mp4/tips_voice.mp3", "tip");
    })();


    //#endregion


    //#region 

    //#endregion

    //#region chatbox 事件转发，接收
    const chatbox = function () {
        const websocket = () => {

        }

        function accept(platform, data) {
            try {
            } catch (ex) {
                console.log("======>chatbox accept", ex)
            }

        }
        function listen(platform, data) {
            try {
            } catch (ex) {
                console.log("======>chatbox listen", ex)
            }

        }
        function disconnect(platform) {
            try {
            } catch (ex) {
                console.log("======>chatbox disconnect", ex)
            }
        }
        return {
            accept,
            disconnect,
        }
    }();
    //#endregion

    //#region 注册渠道
    ;
    (function () {

        function getGender(g) {
            switch (g) {
                case "m":
                    return 0;
                case "f":
                    return 1;
                case "t":
                    return 2;
                case "c":
                    return 3;
                default:
                    return -1;
            }
        }
        function convertUser(u) {
            var recents = "";
            if (u.tipped_alot_recently) {
                recents = "lots"
            }
            else if (u.tipped_tons_recently) {
                recents = "tons"
            }
            if (u.tipped_recently) {
                recents = "some"
            } else {
                recents = "none"
            }

            return {
                username: u.username,
                in_fan_club: u.in_fanclub,
                gender: getGender(u.gender),
                has_token: u.has_tokens,
                recent_tips: recents,
                is_mod: u.is_mod,
            }
        }

        PlatformProcessor.register(config.platform.chaturbate, {
            onWebsocket(req, reqId) {
                var { type, data, url, from } = req;
                try {
                    //判断是直播数据有效url
                    // if (config.urls.chaturbate.websocket.chat.test(url)) {
                    if (isMatchs(config.urls.chaturbate.websocket.chat, url)) {
                        var msg = typeof data.responseData === "string" ? JSON.parse(data.responseData) : data.responseData;
                        //聊天记录
                        if (msg.action == 15 && msg.messages) {
                            var userProfile = req.profile || this?.profile || {};
                            if (!userProfile.username) {
                                log("missing user profile")
                                return;
                            }
                            for (var m of msg.messages) {
                                var mc = typeof m.data === "string" ? JSON.parse(m.data) : m.data;
                                // console.log("chaturbate message", mc)

                                //过滤所有主播消息
                                if ((mc.user && mc.user.username == userProfile.username) || (mc.from_user && mc.from_user.username == userProfile.username)) {
                                    continue;
                                }
                                var toBackendMsg = {
                                    platform: config.platform.chaturbate,
                                    type: "chat_message",
                                    data: {
                                        broadcaster: userProfile.username,
                                    }
                                }
                                if (mc._topic == "RoomPrivilegedEnterTopic") {
                                    toBackendMsg.type = "user_enter";
                                    toBackendMsg.data.user = convertUser(mc.user)
                                }
                                else if (mc._topic == "RoomPrivilegedLeaveTopic") {
                                    toBackendMsg.type = "user_leave";
                                    toBackendMsg.data.user = convertUser(mc.user)
                                }
                                else if (mc._topic == "RoomMessageTopic") {
                                    toBackendMsg.type = "chat_message";
                                    toBackendMsg.data.message = {
                                        color: mc.font_color,
                                        bg_color: mc.background,
                                        message: mc.message,
                                        font: mc.font_family
                                    }
                                    toBackendMsg.data.user = convertUser(mc.from_user)
                                }
                                else if (mc._topic == "UserMessageTopic") {
                                    toBackendMsg.type = "private_message";
                                    toBackendMsg.data.message = {
                                        color: mc.font_color,
                                        bg_color: mc.background,
                                        message: mc.message,
                                        font: mc.font_family
                                    }
                                    toBackendMsg.data.user = convertUser(mc.from_user)
                                }
                                else if (mc._topic == "RoomTipAlertTopic") {
                                    toBackendMsg.type = "tip";
                                    toBackendMsg.data.user = convertUser(mc)
                                    toBackendMsg.data.user.username = mc.from_username;
                                    toBackendMsg.data.tip = {
                                        tokens: mc.amount,
                                        is_anon: mc.is_anonymous_tip,
                                        message: mc.message
                                    }
                                }
                                else if (mc._topic == "UserFollowerTopic") {
                                    toBackendMsg.type = mc.is_following ? "follow" : "unfollow";
                                    toBackendMsg.data.user = {
                                        username: mc.follower_username,
                                    }
                                }
                                // else if (mc._topic == "RoomStatusTopic") {
                                //     toBackendMsg.type = mc.status == "offline" ? "broadcast_stop" : "broadcast_start";
                                // } 
                                else {
                                    continue;
                                }
                                local.postEvent(toBackendMsg, config.platform.chaturbate)
                            }
                        }
                    }
                } catch (ex) {
                    err(`process event handle error(${config.platform.chaturbate})`, ex, req)

                }
            }
        });

        PlatformProcessor.register(config.platform.chaturbatetest, {
            onWebsocket(req, reqId) {
                var { type, data, url, from } = req;
                try {
                    //判断是直播数据有效url
                    if (isMatchs(config.urls.chaturbatetest.websocket.chat, url)) {
                        var msg = typeof data.responseData === "string" ? JSON.parse(data.responseData) : data.responseData;
                        //聊天记录
                        if (msg.action == 15 && msg.messages) {
                            var userProfile = req.profile || this?.profile || {};
                            if (!userProfile.username) {
                                console.log("missing user profile")
                                return;
                            }
                            for (var m of msg.messages) {
                                var mc = typeof m.data === "string" ? JSON.parse(m.data) : m.data;

                                //过滤所有主播消息
                                if ((mc.user && mc.user.username == userProfile.username) || (mc.from_user && mc.from_user.username == userProfile.username)) {
                                    continue;
                                }
                                var toBackendMsg = {
                                    platform: config.platform.chaturbatetest,
                                    type: "chat_message",
                                    data: {
                                        broadcaster: userProfile.username,
                                    }
                                }
                                if (mc._topic == "RoomPrivilegedEnterTopic") {
                                    toBackendMsg.type = "user_enter";
                                    toBackendMsg.data.user = convertUser(mc.user)
                                }
                                else if (mc._topic == "RoomPrivilegedLeaveTopic") {
                                    toBackendMsg.type = "user_leave";
                                    toBackendMsg.data.user = convertUser(mc.user)
                                }
                                else if (mc._topic == "RoomMessageTopic") {
                                    toBackendMsg.type = "chat_message";
                                    toBackendMsg.data.message = {
                                        color: mc.font_color,
                                        bg_color: mc.background,
                                        message: mc.message,
                                        font: mc.font_family
                                    }
                                    toBackendMsg.data.user = convertUser(mc.from_user)
                                }
                                else if (mc._topic == "UserMessageTopic") {
                                    toBackendMsg.type = "private_message";
                                    toBackendMsg.data.message = {
                                        color: mc.font_color,
                                        bg_color: mc.background,
                                        message: mc.message,
                                        font: mc.font_family
                                    }
                                    toBackendMsg.data.user = convertUser(mc.from_user)
                                }
                                else if (mc._topic == "RoomTipAlertTopic") {
                                    toBackendMsg.type = "tip";
                                    toBackendMsg.data.user = convertUser(mc)
                                    toBackendMsg.data.user.username = mc.from_username;
                                    toBackendMsg.data.tip = {
                                        tokens: mc.amount,
                                        is_anon: mc.is_anonymous_tip,
                                        message: mc.message
                                    }
                                }
                                else if (mc._topic == "UserFollowerTopic") {
                                    toBackendMsg.type = mc.is_following ? "follow" : "unfollow";
                                    toBackendMsg.data.user = {
                                        username: mc.follower_username,
                                    }
                                }
                                // else if (mc._topic == "RoomStatusTopic") {
                                //     toBackendMsg.type = mc.status == "offline" ? "broadcast_stop" : "broadcast_start";
                                // } 
                                else {
                                    continue;
                                }
                                local.postEvent(toBackendMsg, config.platform.chaturbatetest)
                            }
                        }
                    }
                } catch (ex) {
                    err(`process event handle error(${config.platform.chaturbatetest})`, ex, req)

                }
            }
        });
    })();

    PlatformProcessor.register(config.platform.joystick, {})
    PlatformProcessor.register(config.platform.manyVids, {})
    PlatformProcessor.register(config.platform.tiwistter, {
        sdkEvent(req, reqId) {

            req.platform = this.platform;
            local.postEvent(req, this.platform)
        }
    })

    /**
     * 前端页面的一些测试渠道
     */
    PlatformProcessor.register("test", {
        onChatEvent(data, reqId) {
            req.platform = this.platform;
            local.postEvent(req.data, "")
        }
    })
    //#endregion

    //#region  stripchat
    PlatformProcessor.register(config.platform.stripchat, {
        onWebsocket(req, reqId) {
            var { type, data, url, from, profile } = req;
            try {

                if (profile) {
                    //"https://stripchat.com/oblakitty
                    if (!profile.url.endsWith(profile.username)) {
                        // console.log("it's not current broadcaster's broadcast page");
                        return;
                    }
                }
                //判断是直播数据有效url
                // if (config.urls.stripchat.websocket.chat.test(url)) {
                if (isMatchs(config.urls.stripchat.websocket.chat, url)) {

                    var msg = typeof data.responseData === "string" ? JSON.parse(data.responseData) : data.responseData;
                    if (!msg.push) {
                        return
                    }

                    var userProfile = req.profile || this?.profile || {};

                    const { channel, pub } = msg.push;
                    if (!channel) { return; }
                    //聊天消息
                    if (/^newchatmessage/i.test(channel)) {
                        const msgContent = pub.data;

                        if (!msgContent) {
                            return;
                        }
                        const message = msgContent.message;
                        if (message.type == "tip") {

                            var evt = {
                                platform: config.platform.stripchat,
                                type: "tip",
                                data: {
                                    broadcaster: userProfile.username,
                                    tip: {
                                        tokens: message.details.amount,
                                        is_anon: false,
                                        message: message.details.body
                                    },
                                    user: {
                                        username: message.userData.username,
                                        in_fan_club: null,
                                        has_token: false,
                                        gender: null,
                                        recent_tips: "",
                                        is_mod: message.userData.isAdmin,
                                    }
                                }
                            }
                            local.postEvent(evt, config.platform.stripchat)
                            return
                        } else {
                            var evt = {
                                platform: config.platform.stripchat,
                                type: "chat_message",
                                data: {
                                    broadcaster: userProfile.username,
                                    message: {
                                        color: null,
                                        bg_color: null,
                                        font: null,
                                        message: message.details.body,
                                    },
                                    user: {
                                        username: message.userData.username,
                                        in_fan_club: null,
                                        has_token: null,
                                        gender: null,
                                        recent_tips: "",
                                        is_mod: message.userData.isAdmin,
                                    }
                                }
                            }
                            local.postEvent(evt, config.platform.stripchat)
                        }
                    }
                    //私聊
                    else if (/^newprivateMessageReceived/i.test(channel)) {
                        const msgContent = pub.data;

                        if (!msgContent) {
                            return;
                        }
                        const message = msgContent.message;
                        let evt = null;

                        if (message.type == "offlineTip") {
                            evt = {
                                platform: config.platform.stripchat,
                                type: "tip",
                                data: {
                                    broadcaster: userProfile.username,
                                    tip: {
                                        tokens: message.details.amount,
                                        is_anon: false,
                                        message: message.details.body || message.body
                                    },
                                    user: {
                                        username: msgContent.counterpart.username,
                                        in_fan_club: null,
                                        has_token: msgContent.hasTokens,
                                        gender: null,
                                        recent_tips: "",
                                        is_mod: msgContent.counterpart.isAdmin,
                                    }
                                }
                            }
                            local.postEvent(evt, config.platform.stripchat)
                        } else {
                            evt = {
                                platform: config.platform.stripchat,
                                type: "private_message",
                                data: {
                                    broadcaster: userProfile.username,
                                    message: {
                                        color: null,
                                        bg_color: null,
                                        font: null,
                                        message: message.body,
                                    },
                                    user: {
                                        username: msgContent.counterpart.username,
                                        in_fan_club: null,
                                        has_token: msgContent.hasTokens,
                                        gender: null,
                                        recent_tips: "",
                                        is_mod: msgContent.counterpart.isAdmin,
                                    }
                                }
                            }
                            local.postEvent(evt, config.platform.stripchat)
                        }

                    }


                }
            } catch (ex) {

            }
        }
    })
        ;
    //#endregion

    //#region  camsoda
    ;
    (function () {
        const convertGender = (g) => {
            if (g == "m") {
                return 0;
            }
            if (g == "w") {
                return 1;
            }
            return -1;
        }
        PlatformProcessor.register(config.platform.camsoda, {
            onWebsocket(req, reqId) {
                var { type, data, url, from } = req;
                try {
                    //判断是直播数据有效url
                    // if (config.urls.camsoda.websocket.chat.test(url)) {
                    if (isMatchs(config.urls.camsoda.websocket.chat, url)) {
                        var msg = typeof data.responseData === "string" ? JSON.parse(data.responseData) : data.responseData;

                        var userProfile = req.profile || this?.profile || {};

                        var evt = {
                            platform: config.platform.camsoda,
                            type: "chat_message",
                            data: {
                                broadcaster: userProfile.username,
                            }
                        }
                        //新用户进入
                        if (msg[0] == 37) {
                            var userEvtData = msg[3][0];
                            evt.type = "user_enter";
                            evt.data.user = {
                                username: userEvtData[1][0],
                                in_fan_club: null,
                                gender: convertGender(userEvtData[1][1]),
                                has_token: null,
                                recent_tips: null,
                                is_mod: userEvtData[2].is_model_admin,
                            }
                        }
                        //用户离开
                        else if (msg[0] == 38) {
                            var userEvtData = msg[3][0];
                            evt.type = "user_leave";
                            evt.data.user = {
                                username: userEvtData[1][0],
                                in_fan_club: null,
                                gender: convertGender(userEvtData[1][1]),
                                has_token: null,
                                recent_tips: null,
                                is_mod: userEvtData[2].is_model_admin,
                            }
                        }
                        //发送消息
                        else if (msg[0] == 27) {
                            //打赏消息
                            if (msg[1].is_tip) {
                                return;
                            }
                            //[27,{"color":"#333","created_at":1750228339166},32779,["json","honeyteatesting",true,"en"]]
                            evt.data.message = {
                                color: msg[1]?.color,
                                bg_color: null,
                                message: msg[3][0],
                                font: null
                            };
                            evt.data.user = {
                                username: msg[3][1],
                                in_fan_club: null,
                                gender: null,
                                has_token: null,
                                recent_tips: null,
                                is_mod: null,
                            }
                        }
                        //私聊
                        else if (msg[0] == 11) {
                            evt.type = "private_message"
                            evt.data.message = {
                                color: null,
                                bg_color: null,
                                message: msg[1].message.message,
                                font: null
                            };
                            evt.data.user = {
                                username: msg[1].message.username,
                                in_fan_club: null,
                                has_token: false,
                                gender: null,
                                recent_tips: "",
                                is_mod: null,
                            }
                        }
                        //打赏事件
                        else if (msg[0] == 18) {
                            //过滤3000的websocket,重复收到打赏消息
                            if (config.urls.camsoda.websocket.chat3000.test(url)) {
                                return;
                            }
                            //[27,{"color":"#333","created_at":1750228339166},32779,["json","honeyteatesting",true,"en"]]
                            evt.type = "tip"
                            evt.data.tip = {
                                tokens: msg[3][0],
                                is_anon: null,
                                message: msg[3][4] || null
                            }
                            evt.data.user = {
                                username: msg[3][2],
                                in_fan_club: null,
                                gender: null,
                                has_token: null,
                                recent_tips: null,
                                is_mod: null,
                            }
                        } else {
                            return;
                        }
                        if (evt) {
                            local.postEvent(evt, config.platform.camsoda)
                        }
                    }

                } catch (ex) {

                }
            }
        })

    })();
    //#endregion

    //#region  camversity
    ;
    (function () {
        const convertGender = (g) => {
            if (g == "m") {
                return 0;
            }
            if (g == "w") {
                return 1;
            }
            return -1;
        }
        PlatformProcessor.register(config.platform.camversity, {
            onWebsocket(req, reqId) {
                var { type, data, url, from } = req;
                try {
                    //判断是直播数据有效url
                    // if (config.urls.camversity.websocket.chat.test(url)) {
                    if (isMatchs(config.urls.camversity.websocket.chat, url)) {
                        var msg = typeof data.responseData === "string" ? JSON.parse(data.responseData) : data.responseData;

                        var userProfile = req.profile || this?.profile || {};
                        var evt = {
                            platform: config.platform.camversity,
                            type: "chat_message",
                            data: {
                                broadcaster: userProfile.username,
                            }
                        }
                        //新用户进入
                        if (msg[0] == 37) {
                            var userEvtData = msg[3][0];
                            evt.type = "user_enter";
                            evt.data.user = {
                                username: userEvtData[1][0],
                                in_fan_club: null,
                                gender: convertGender(userEvtData[1][1]),
                                has_token: null,
                                recent_tips: null,
                                is_mod: userEvtData[2].is_model_admin,
                            }
                        }
                        //用户离开
                        else if (msg[0] == 38) {
                            var userEvtData = msg[3][0];
                            evt.type = "user_leave";
                            evt.data.user = {
                                username: userEvtData[1][0],
                                in_fan_club: null,
                                gender: convertGender(userEvtData[1][1]),
                                has_token: null,
                                recent_tips: null,
                                is_mod: userEvtData[2].is_model_admin,
                            }
                        }
                        //发送消息
                        else if (msg[0] == 27) {
                            //打赏消息
                            if (msg[1].is_tip) {
                                return;
                            }
                            //[27,{"color":"#333","created_at":1750228339166},32779,["json","honeyteatesting",true,"en"]]
                            evt.data.message = {
                                color: msg[1]?.color,
                                bg_color: null,
                                message: msg[3][0],
                                font: null
                            };
                            evt.data.user = {
                                username: msg[3][1],
                                in_fan_club: null,
                                gender: null,
                                has_token: null,
                                recent_tips: null,
                                is_mod: null,
                            }
                        }
                        //私聊
                        else if (msg[0] == 11) {
                            evt.type = "private_message"
                            evt.data.message = {
                                color: null,
                                bg_color: null,
                                message: msg[1].message.message,
                                font: null
                            };
                            evt.data.user = {
                                username: msg[1].message.username,
                                in_fan_club: null,
                                has_token: false,
                                gender: null,
                                recent_tips: "",
                                is_mod: null,
                            }
                        }
                        //打赏事件
                        else if (msg[0] == 18) {
                            //过滤3000的websocket,重复收到打赏消息
                            if (config.urls.camversity.websocket.chat3000.test(url)) {
                                return;
                            }
                            //[27,{"color":"#333","created_at":1750228339166},32779,["json","honeyteatesting",true,"en"]]
                            evt.type = "tip"
                            evt.data.tip = {
                                tokens: msg[3][0],
                                is_anon: null,
                                message: msg[3][4] || null
                            }
                            evt.data.user = {
                                username: msg[3][2],
                                in_fan_club: null,
                                gender: null,
                                has_token: null,
                                recent_tips: null,
                                is_mod: null,
                            }
                        } else {
                            return;
                        }
                        if (evt) {
                            local.postEvent(evt, config.platform.camversity)
                        }
                    }

                } catch (ex) {

                }
            }
        })

    })();
    //#endregion

    //#region myfreecams
    ;
    (function () {
        const sessionUserCache = {};
        PlatformProcessor.register(config.platform.myfreecams, {
            onWorker(req, reqId) {
                var { type, data, url, from, profile } = req;
                try {
                    //判断是直播数据有效url
                    // if (config.urls.myfreecams.worker.chat.test(url)) {
                    if (isMatchs(config.urls.myfreecams.worker.chat, url)) {
                        var packraw = data.responseData
                        var pack = JSON.parse(packraw);
                        if (!pack[0] || !/onpacket/i.test(pack[0])) {
                            return
                        }
                        var msg = pack[1]
                        var pattern = msg.split(/\s+/);
                        var type_id = pattern[0].length > 6 ? pattern[0].substring(6) : pattern[0];
                        var userProfile = req.profile || this?.profile || {};
                        //聊天
                        // 00017950 255447814 145798865 0 0 %7B%22lv%22%3A2%2C%22msg%22%3A%22hello%22%2C%22nm%22%3A%22hpbstream%22%2C%22pid%22%3A1%2C%22sid%22%3A255447814%2C%22uid%22%3A46460277%2C%22vs%22%3A90%7D
                        // {"lv":2,"msg":"hello","nm":"hpbstream","pid":1,"sid":255447814,"uid":46460277,"vs":90}
                        if (type_id == 50) {
                            if (pattern[pattern.length - 2] == 4) {
                                //过滤历史聊天记录
                                return;
                            }
                            if (pattern.length == 6) {
                                var encodeData = pattern[pattern.length - 1];
                                if (encodeData) {
                                    encodeData = decodeURIComponent(encodeData);
                                }
                                if (encodeData) {
                                    encodeData = tryJson(encodeData);
                                    if (typeof encodeData != "object") {
                                        return;
                                    }
                                }
                                if (encodeData.nm == "FCServer" || /bot/.test(encodeData.nm)) {
                                    return;
                                }
                                var evt = {
                                    platform: config.platform.myfreecams,
                                    type: "chat_message",
                                    data: {
                                        broadcaster: userProfile.username,
                                        message: {
                                            message: decodeURIComponent(encodeData.msg),
                                            color: encodeData?.u?.chat_color
                                        },
                                        user: {
                                            username: encodeData.nm,
                                            in_fan_club: false,
                                            gender: -1,
                                            has_token: false,
                                            recent_tips: "",
                                            is_mod: false,
                                        }
                                    },
                                }
                                local.postEvent(evt, config.platform.myfreecams)
                            }
                        }
                        //打赏事件
                        else if (type_id == 6) {
                            // 0002516 0 146463986 10 0 %7B%22ch%22%3A146463986%2C%22flags%22%3A24832%2C%22m%22%3A%5B255586054%2C46463986%2C%22Honeystream%22%5D%2C%22sesstype%22%3A10%2C%22stamp%22%3A1751616602%2C%22tokens%22%3A1%2C%22u%22%3A%5B255476525%2C46460277%2C%22hpbstream%22%5D%7D
                            // {"ch":146463986,"flags":24832,"m":[255586054,46463986,"Honeystream"],"sesstype":10,"stamp":1751616602,"tokens":1,"u":[255476525,46460277,"hpbstream"]}
                            if (pattern.length == 6) {
                                var encodeData = pattern[pattern.length - 1];
                                if (encodeData) {
                                    encodeData = decodeURIComponent(encodeData);
                                }
                                if (encodeData) {
                                    encodeData = tryJson(encodeData);
                                    if (typeof encodeData != "object") {
                                        return;
                                    }
                                }
                                var evt = {
                                    platform: config.platform.myfreecams,
                                    type: "tip",
                                    data: {
                                        broadcaster: userProfile.username,
                                        message: {
                                            message: encodeData.msg,
                                            color: encodeData?.u.chat_color
                                        },
                                        user: {
                                            username: encodeData.u[2],
                                            in_fan_club: false,
                                            gender: -1,
                                            has_token: false,
                                            recent_tips: "",
                                            is_mod: false,
                                        },
                                        tip: {
                                            tokens: encodeData.tokens,
                                            is_anon: false,
                                            message: ""
                                        }
                                    },
                                }
                                local.postEvent(evt, config.platform.myfreecams)
                            }
                        }
                        //观众进入事件
                        else if (type_id == 51) {
                            // 进入
                            // 00034351 255476525 255586054 146463986 1 %7B%22lv%22%3A2%2C%22nm%22%3A%22hpbstream%22%2C%22pid%22%3A1%2C%22sid%22%3A255476525%2C%22uid%22%3A46460277%2C%22vs%22%3A90%2C%22u%22%3A%7B%22camserv%22%3A0%2C%22chat_font%22%3A0%2C%22chat_opt%22%3A1%2C%22creation%22%3A1749706646%2C%22status%22%3A%22%22%7D%2C%22s%22%3A%7B%22rp%22%3A37%2C%22tk%22%3A174%7D%7D
                            // {"lv":2,"nm":"hpbstream","pid":1,"sid":255476525,"uid":46460277,"vs":90,"u":{"camserv":0,"chat_font":0,"chat_opt":1,"creation":1749706646,"status":""},"s":{"rp":37,"tk":174}}
                            // 退出
                            // 00003551 255476525 255586054 146463986 2

                            const enter_type = pattern[pattern.length - 2];

                            if (enter_type == 1) {
                                // 进入
                                var encodeData = pattern[pattern.length - 1];
                                if (encodeData) {
                                    encodeData = decodeURIComponent(encodeData);
                                }
                                if (encodeData) {
                                    encodeData = tryJson(encodeData);
                                    if (typeof encodeData != "object") {
                                        return;
                                    }
                                }

                                // session id
                                const sid = pattern[1];

                                // 存入缓存
                                if (sid && encodeData) {
                                    sessionUserCache[sid] = encodeData;
                                }

                                var evt = {
                                    platform: config.platform.myfreecams,
                                    type: "user_enter",
                                    data: {
                                        broadcaster: userProfile.username,
                                        user: {
                                            username: encodeData.nm,
                                            in_fan_club: null,
                                            gender: -1,
                                            has_token: null,
                                            recent_tips: null,
                                            is_mod: null,
                                        }
                                    },
                                }
                                local.postEvent(evt, config.platform.myfreecams);
                            } else {
                                // 退出
                                const sid = pattern[1];
                                const encodeData = sessionUserCache[sid];
                                // console.log('用户退出： ', encodeData);
                                if (encodeData) {
                                    var evt = {
                                        platform: config.platform.myfreecams,
                                        type: "user_leave",
                                        data: {
                                            broadcaster: userProfile.username,
                                            user: {
                                                username: encodeData.nm,
                                                in_fan_club: null,
                                                gender: -1,
                                                has_token: null,
                                                recent_tips: null,
                                                is_mod: null,
                                            }
                                        },
                                    }
                                    local.postEvent(evt, config.platform.myfreecams);
                                    delete sessionUserCache[sid];
                                }
                            }
                        }
                        //私聊
                        else if (type_id == 3) {
                            // 0001753 46460277 46463986 0 0 %7B%22lv%22%3A2%2C%22msg%22%3A%22helo%22%2C%22nm%22%3A%22hpbstream%22%2C%22pid%22%3A1%2C%22sid%22%3A255476525%2C%22uid%22%3A46460277%2C%22vs%22%3A90%7D
                            // {"lv":2,"msg":"helo","nm":"hpbstream","pid":1,"sid":255476525,"uid":46460277,"vs":90}

                            var encodeData = pattern[pattern.length - 1];
                            if (encodeData) {
                                encodeData = decodeURIComponent(encodeData);
                            }
                            if (encodeData) {
                                encodeData = tryJson(encodeData);
                                if (typeof encodeData != "object") {
                                    return;
                                }

                                var evt = {
                                    platform: config.platform.myfreecams,
                                    type: "private_message",
                                    data: {
                                        broadcaster: userProfile.username,
                                        message: {
                                            color: null,
                                            bg_color: null,
                                            font: null,
                                            message: decodeURIComponent(encodeData.msg),
                                        },
                                        user: {
                                            username: encodeData.nm,
                                            in_fan_club: null,
                                            has_token: encodeData.lv > 1 ? true : false,
                                            gender: null,
                                            recent_tips: "",
                                            is_mod: null,
                                        }
                                    }
                                }
                                local.postEvent(evt, config.platform.myfreecams)
                            }
                        }
                    }
                }
                catch (ex) {
                    err(ex)
                }
            }
        });
    })();

    //#endregion

    //#region  监控本地服务状态
    const monitoringStatus = function () {

        console.log("````````````````---->run monitoring status")
        const state = {
            mode: "pc"
        }
        async function getBluetoothStatus() {
            const response = await fetch(`${config.localBaseUrl}/api/v1/bluetooth/usbinfo?x=` + new Date().valueOf(),
                {
                    method: 'get',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                }
            );
            if (!response.ok) {
                state.pingUsb = false;
                return
            }
            state.pingUsb = true;
            var usb = await response.json();
            if (usb.code == 0) {
                state.usb = usb.data.has_usb;
                state.usbOccupy = usb.data.is_occupy;
                state.os = usb.data.platform

                state.os = usb.data.platform !== "darwin" ? "windows" : "mac";
                state.isWin = usb.data.platform !== "darwin";
            }
            else {
                state.usb = false;
                state.usbOccupy = false
                state.os = ""
            }
        }

        async function getExternalOBSStatus() {
            const response = await fetch(`${config.localBaseUrl}/api/v1/obs/external/status?x=` + new Date().valueOf(),
                {
                    method: 'get',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: null
                }
            );
            if (!response.ok) {
                state.pingObs = false;
                return
            }
            state.pingObs = true;
            var sts = await response.json();
            if (sts.code == 0) {
                state.externalObsRunning = sts.data.running;
                state.obsPlugin = sts.data.plugin_install;
            }
            else {
                state.externalObsRunning = false;
                state.obsPlugin = false
            }
        }

        async function getBuildInOBSStatus() {
            const response = await fetch(`${config.localBaseUrl}/api/v1/obs/connection-status`,
                {
                    method: 'get',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: null
                }
            );

            if (!response.ok) {
                state.buildInObsRunning = false;
                return
            }

            var sts = await response.json();
            state.buildInObsRunning = sts?.status

            if (typeof state.isExternalObs === 'undefined') {
                state.isExternalObs = sts?.open_type == 1 ? true : false;
            }
        }

        function notify() {
            //不在vc中不触发
            if (!isVCBrowser()) {
                return;
            }
            extensions.postSync({
                type: "Transfer-To-Platform-All",
                data: {
                    target: "post-message",
                    data: {
                        type: "prestream-check-status",
                        data: state
                    }
                },
            })
        }
        var timer;
        async function start() {
            await getBluetoothStatus();
            await getExternalOBSStatus();
            await getBuildInOBSStatus();
            timer = setInterval(async () => {
                // await getBluetoothStatus();
                await getExternalOBSStatus();
                await getBuildInOBSStatus();
                notify();
            }, 3 * 1000);
        }
        function setToyMode(mode) {
            state.mode = mode
            notify();
        }
        function setIsExternalObs(isExternalObs) {
            state.isExternalObs = isExternalObs
            notify();
        }
        function setUsb(d) {
            state.usb = d.has_usb;
            state.usbOccupy = d.is_occupy;
            state.os = d.platform !== "darwin" ? "windows" : "mac";
            state.isWin = d.platform !== "darwin";
            notify();
        }
        if (isVCBrowser()) {
            start();
        }
        return {
            setToyMode,
            setUsb,
            setIsExternalObs
        }
    }()
        ;
    //#endregion

    //#region OBS Websocket
    const ObsClient = function () {
        const OBS_WS_URL = isVCBrowser() ? 'ws://127.0.0.1:12559' : 'ws://127.0.0.1:12569';
        const OBS_WS_PASSWORD = 'honeyplaybox';

        let _client = null

        class ObsClient {
            connected = false
            heartbeatInterval = null
            errorMessage = ""
            heartbeat = null
            imageFormat = ""

            client = new OBSWebSocket();

            async sendCommand(command, params) {
                try {
                    return await this.client.call(command, params || {})
                } catch (e) {
                    console.log('Error sending command', command, ' - error is:', e.message)
                    return {}
                }
            }

            constructor() {
                this.client.on("error", err => {
                    console.error('Socket error:', err)
                })
                this.init();
            }
            async init() {

                this.client.on('ConnectionClosed', () => {
                    if (this.connected) {
                        setTimeout(() => {
                            connectToObsAndSyncOverlay()
                        }, 10 * 1000);
                    }
                    this.connected = false
                    clearInterval(this.heartbeatInterval)
                    console.log('Connection closed')

                })

                this.client.on('Identified', async () => {
                    console.log('Connected')
                    this.connected = true

                    const data = await this.sendCommand('GetVersion')
                    const version = data.obsWebSocketVersion || ''
                    console.log('OBS-websocket version:', version)
                    // if (compareVersions(version, OBS_WEBSOCKET_LATEST_VERSION) < 0) {
                    //     alert(
                    //         'You are running an outdated OBS-websocket (version ' +
                    //         version +
                    //         '), please upgrade to the latest version for full compatibility.'
                    //     )
                    // }
                    if (
                        data.supportedImageFormats.includes('webp') &&
                        document
                            .createElement('canvas')
                            .toDataURL('image/webp')
                            .indexOf('data:image/webp') === 0
                    ) {
                        this.imageFormat = 'webp'
                    }
                    var ths = this;
                    this.heartbeatInterval = setInterval(async () => {
                        const stats = await this.sendCommand('GetStats')
                        const streaming = await this.sendCommand('GetStreamStatus')
                        const recording = await this.sendCommand('GetRecordStatus')
                        this.heartbeat = { stats, streaming, recording }
                        // console.log(heartbeat);
                    }, 1000) // Heartbeat
                    // isStudioMode =
                    //     (await sendCommand('GetStudioModeEnabled')).studioModeEnabled || false
                    // isVirtualCamActive =
                    //     (await sendCommand('GetVirtualCamStatus')).outputActive || false
                })

                this.client.on('ConnectionError', async () => {
                    this.errorMessage = 'Please enter your password:'
                    // if (!password) {
                    //     connected = false
                    // } else {
                    //     await connect()
                    // }

                })

                this.client.on('VirtualcamStateChanged', async (data) => {
                    console.log('VirtualcamStateChanged', data.outputActive)
                    // isVirtualCamActive = data && data.outputActive
                })

                this.client.on('StudioModeStateChanged', async (data) => {
                    console.log('StudioModeStateChanged', data.studioModeEnabled)
                    // isStudioMode = data && data.studioModeEnabled
                })

                this.client.on('ReplayBufferStateChanged', async (data) => {
                    console.log('ReplayBufferStateChanged', data)
                    // isReplaying = data && data.outputActive
                })
                if ('wakeLock' in navigator) {
                    try {
                        await navigator.wakeLock.request('screen')
                        // Re-request when coming back
                        document.addEventListener('visibilitychange', async () => {
                            if (document.visibilityState === 'visible') {
                                await navigator.wakeLock.request('screen')
                            }
                        })
                    } catch (e) { }
                }
            }
            async disconnect() {
                this.connected = false
                await this.client.disconnect()
                clearInterval(this.heartbeatInterval)
                this.errorMessage = 'Disconnected'
            }
            async connect(address, password) {
                address = address || 'ws://localhost:4455'
                if (address.indexOf('://') === -1) {
                    const secure = location.protocol === 'https:' || address.endsWith(':443')
                    address = secure ? 'wss://' : 'ws://' + address
                }
                console.log('Connecting to:', address, '- using password:', password)
                await this.disconnect()
                try {
                    const { obsWebSocketVersion, negotiatedRpcVersion } = await this.client.connect(
                        address,
                        password
                    )
                    console.log(
                        `Connected to obs-websocket version ${obsWebSocketVersion} (using RPC ${negotiatedRpcVersion})`
                    )
                    window.localStorage.setItem('obsAddress', address) // Save address for next time
                } catch (e) {
                    console.log(e)
                }
            }
            async getScenes() {
                let data = await this.sendCommand('GetSceneList')
                console.log('GetSceneList', data)
                var scenes = data.scenes
                console.log("------------>scenes", scenes);
                return scenes;
            }

            async getSceneItem(name) {
                const data = await this.sendCommand('GetSceneItemList', { sceneName: name })
                console.log("--------->LgetSceneItem", data)
                var items = data.sceneItems
                return items;
            }
            async getInputKind() {
                var scenes = await this.getScenes();
                var ls = []
                for (var scene of scenes) {
                    var items = await this.getSceneItem(scene.sceneName);
                    for (var item of items) {
                        if (item.inputKind == "honeyplaybox_overlay") {//"honeyplaybox_overlay" browser_source
                            ls.push(item.sourceName)
                        }
                    }
                }
                console.log("------------>ls", ls)
                return ls;
            }

            getUrl() {
                //环境切换
                var env = "prods"
                var type = isVCBrowser() ? 0 : 1;
                return `https://extensions.vibexcast.com/${env}/overlay/style31/index.html?external=${type || 0}&id=1&backgroundImage=https://vibeconnect.oss-us-west-1.aliyuncs.com/staticresource/20250515/5/background1.gif&headerUrl=https://vibeconnect-extensions-script.oss-us-west-1.aliyuncs.com/undefined/themes/theme/e3f6dd4dcd4349899239cf3541a2f42c.png&itemBgUrl=https://vibeconnect-extensions-script.oss-us-west-1.aliyuncs.com/undefined/themes/theme/0076f2b4e41047a8a77cc610b0768e9b.png&itemIconUrl=https://vibeconnect-extensions-script.oss-us-west-1.aliyuncs.com/undefined/themes/theme/cb85cf45cc3842e49d38921241ef128c.png&opacity=51&panelMode=3&tippers=3&frameStyle=0&timestamp=1764141398047&token=${server.getToken()}`
            }
            async asyncOverlay(inputName) {
                const result = await this.sendCommand('SetInputSettings', {
                    inputName: inputName,        // 源名称，确保是浏览器源的名称
                    inputSettings: {             // 设置浏览器源的参数
                        url: this.getUrl(),
                    }
                });
            }
            async createOverlayInput() {
                var currentScene = await this.getCurrentScene();
                console.info("------------>currentScene", currentScene)
                if (!currentScene) {
                    var scenes = await this.getScenes();
                    if (scenes && scenes.length > 0) {
                        currentScene = scenes[scenes.length - 1];
                    }
                }
                console.info("------------>currentScene", currentScene)
                await this.sendCommand('CreateInput', {
                    inputName: "HoneyPlayBox Overlay",
                    sceneName: currentScene.sceneName,
                    inputKind: "honeyplaybox_overlay",
                    inputSettings: {
                        url: this.getUrl(),
                        width: 1920,
                        height: 1080,
                    }
                });

            }
            // 获取当前场景
            async getCurrentScene() {
                try {
                    const data = await this.sendCommand('GetCurrentProgramScene'); // 发送命令获取当前场景
                    return data  // 返回当前场景名称
                } catch (error) {
                    console.error('------>Error getting current scene:', error);
                }
            }
            async syncAllOverlay() {
                var inputs = await this.getInputKind();

                if (!inputs || inputs.length == 0) {
                    this.createOverlayInput();
                    return;
                }
                for (var input of inputs) {
                    try {
                        await this.asyncOverlay(input);
                    } catch (ex) {
                        console.log("------------>asyncOverlay error", ex)
                    }
                }
            }

            async autoConnect(callback) {
                if (!server.getToken()) {
                    console.log("---------setTimeout-connectToObsAndSyncOverlay")
                    setTimeout(() => {
                        this.autoConnect(callback);
                    }, 5 * 1000);
                    return
                }
                await this.connect(OBS_WS_URL, OBS_WS_PASSWORD);
                if (!this.connected) {
                    console.log("---------setTimeout-connectToObsAndSyncOverlay")
                    setTimeout(() => {
                        this.autoConnect(callback);
                    }, 5 * 1000);
                    return;
                }
                if (callback) {
                    callback()
                }
            }
            static instance() {
                if (!_client) {
                    _client = new ObsClient();
                }
                return _client;
            }

            static async reconnect() {
                var clnt = ObsClient.instance();
                if (clnt && clnt.connected) {
                    await clnt.disconnect();
                }
                connectToObsAndSyncOverlay();
            }
        }
        ;

        function connectToObsAndSyncOverlay() {
            console.log("----------connectToObsAndSyncOverlay")
            if (ObsClient.connecting == true) {
                return;
            }
            ObsClient.connecting = true;
            ObsClient.instance().autoConnect(function () {

                ObsClient.connecting = false;
                ObsClient.instance().syncAllOverlay();
            });
        }
        ObsClient.connecting = false
        setTimeout(() => {
            connectToObsAndSyncOverlay();
        }, 5000)

        return ObsClient;
    }();
    //#endregion

    window.addEventListener("message", (e) => {
        // console.log("message：", e)
        const { from, type, data } = e.data;
        if (type == "Extenisions") {
            // console.log("接收的extensions 状态：", e.data, e.data.id)
            let d = e.data.data;
            // console.log("=========>data", d)
            extensions.id = d.id;
            extensions.connect()
        }
    })
    window.addEventListener("unload", (e) => {
        // console.log("unload：", e)
        chatbox.disconnect();
        extensions.disconnect()
        server.disconnect();
    })

    try {
        // console.log("------config:", config)
        if (window.parent) {
            window.parent.postMessage({
                type: "loaded",
                config,
                constrains: c,
            }, "*")
        }
    } catch (ex) {
        console.log(ex)
    }


    ;
    (function () {
        server.syncPlatform();
    })()
        ;
})();


//#endregion