
importScripts(
    'config.js',
);

Array.prototype.any = function (fn) {
    if (typeof fn !== "function") {
        for (var item of this) {
            if (fn(fn)) {
                return true;
            }
        }
        return false;
    }
    for (var item of this) {
        if (fn.call(this, item)) {
            return true;
        }
    }
    return false;
}
//#region  基础方法
const tryJson = (raw) => {
    try {
        return JSON.parse(raw);
    } catch (e) {
        return;
    }
}

chrome.runtime.onMessage.addListener(
    function (request, sender, sendResponse) {
        console.log('request', request,)
        const url = request.status == '0' ? "icons/icon_gray_128.png" : "icons/icon_128.png"
        console.log('url', url)
        chrome.action.setIcon({
            path: {
                "128": url
            }
        })
    }
)

function openWebSiteAndSendMessage(data) {
    chrome.tabs.query({ url: honey.config.front.pattern }, function (tabs) {
        if (tabs && tabs.length > 0) {
            chrome.tabs.update(tabs[0].id, { active: true });
            chrome.tabs.sendMessage(tabs[0].id, data);
        } else {
            chrome.tabs.create({
                url: honey.config.pages.front.url
            }, function (tab) {
                chrome.tabs.sendMessage(tab.id, data);
            });
        }
    });
}

function getPlatformByUrl(url) {
    let matchedPlatform = null;
    let matchedPattern = null;
    for (const [platformKey, platformCfg] of Object.entries(honey.config.urls)) {
        let patterns = platformCfg.roomPagePatten;
        if (!patterns) continue;
        if (!Array.isArray(patterns)) patterns = [patterns];
        for (const pat of patterns) {
            const regStr = "^" + pat.replace(/[\\^$.+?()[\]{}|]/g, '\\$&').replace(/\*/g, ".*") + "$";
            const regex = new RegExp(regStr);
            if (regex.test(url)) {
                matchedPlatform = platformKey;
                matchedPattern = pat;
                break;
            }
        }
        if (matchedPlatform) break;
    }

    return matchedPlatform;
}

function createWindow(config) {
    if (typeof config == "string") {
        config = {
            url: config
        };
    }
    return new Promise((res) => {
        chrome.windows.create({
            url: config.url,
            type: config.type || "panel",
            width: config.width || 800,
            height: config.height || 600,
            top: config.top,
            left: config.left,
            focused: "focused" in config ? config.focused : true
        }, (window) => {
            res(window)
        });
    })
}
/**
 * 判断是否是vibe connect浏览器
 * @returns 
 */
function isVCBrowser() {
    const userAgent = navigator.userAgent;
    return /VibeConnect/i.test(userAgent || "")
}

/**
 * 匹配url是否包含指定字符串
 * @param {*} source 
 * @param {*} matched 
 * @returns 
 */
function matchUrl(source, matched) {
    var url = source.split('?')[0];
    url = url.split("#")[0]
    url = url.replace("http:", "").replace("https:", "");
    matched = matched.replace("http:", "").replace("https:", "");
    return url.toLocaleLowerCase() == matched.toLocaleLowerCase();
}
/**
 * 判断是否存在指定url的窗口
 * @param {*} config 
 * @returns 
 */
function existUrlOnAllWindow(config) {

    if (typeof config == "object") {
        config = config.prefixUrl || config.url || "";
    }
    return new Promise((res) => {
        chrome.windows.getAll({ populate: true }, (windows) => {
            if (windows.length > 0) {
                for (var win of windows) {
                    for (var t of win.tabs) {
                        if (matchUrl(t.url, config)) {
                            return res(true);
                        }
                    }
                }
            }
            res(false)
        });
    })
}
/**
 * 获取指定url的窗口
 * @param {*} config 
 * @returns 
 */
function getWindowByUrl(config) {
    if (typeof config == "object") {
        config = config.prefixUrl || config.url || "";
    }
    return new Promise((res) => {
        chrome.windows.getAll({ populate: true }, (windows) => {
            if (windows.length > 0) {
                for (var win of windows) {
                    for (var t of win.tabs) {
                        if (matchUrl(t.url, config)) {
                            return res(win);
                        }
                    }
                }
            }
            res(false)
        });
    })
}
/**
 * 激活选项卡
 * @param {*} tabId 
 * @returns 
 */
function activeTab(tabId) {
    return new Promise((resolve, reject) => {
        chrome.tabs.update(tabId, { active: true }, function () {
            resolve(true);
        });
    });
}
/**
 * 获取当前选项卡的url
 * @returns 
 */
async function getCurrentTabUrl() {
    return new Promise((resolve, reject) => {
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            if (tabs && tabs.length > 0) {
                resolve(tabs[0].url);
            } else {
                resolve(null);
            }
        });
    });
}
/**
 * 数组正则匹配
 * @param {*} regs 
 * @param {*} target 
 * @returns 
 */
function arrayRegTest(regs, target) {
    if (Array.isArray(regs)) {
        for (var reg of regs) {
            if (new RegExp(reg).test(target)) {
                return true;
            }
        }
    } else if (regs) {
        return new RegExp(regs).test(target);
    }
    return false;
}
// 将chrome.tabs.query转换为Promise
function queryTabs(queryInfo) {
    return new Promise((resolve) => {
        chrome.tabs.query(queryInfo, (tabs) => resolve(tabs));
    });
}
/**
 * 匹配url是否包含指定字符串
 * @param {*} url 
 * @param {*} pattern 
 * @returns 
 */
function matchPattern(url, pattern) {
    const regex = new RegExp('^' + pattern.replace(/\*/g, '.*') + '$');
    return regex.test(url);
}
/**
 * 查询当前窗口所有选项卡中匹配指定模式的选项卡
 * @param {*} pattern 
 * @returns 
 */
function queryFrontTabs(pattern) {
    return new Promise((resolve) => {
        chrome.windows.getAll({ populate: true }, function (windows) {
            const matchedTabs = [];
            windows.forEach(function (window) {
                window.tabs.forEach(function (tab) {
                    if (tab.url && matchPattern(tab.url, pattern.url)) {
                        matchedTabs.push(tab);
                    }
                });
            });
            resolve(matchedTabs);
        });
    });
}
/**
 * 发送消息到指定选项卡
 * @param {*} tabId 
 * @param {*} type 
 * @param {*} data 
 * @returns 
 */
function sendTabMessage(tabId, type, data) {
    return new Promise((resolve, reject) => {
        chrome.tabs.sendMessage(tabId, {
            type: type,
            platform: honey.name,
            ...data
        }, (response) => {
            if (chrome.runtime.lastError) {

                console.error("sendTabMessage Error:", type, data, chrome.runtime.lastError);
                chrome.tabs.get(tabId, function (tab) {
                    if (chrome.runtime.lastError) {
                        console.error("Error: ", chrome.runtime.lastError);
                    } else {
                        console.log("sendTabMessage Error:", type, data, chrome.runtime.lastError);
                        console.log("Tab Info:", tab);
                        console.log("Tab ID:", tab.id);
                        console.log("URL:", tab.url);
                        console.log("Title:", tab.title);
                    }
                });
            }
            resolve(response)
        });
    });
}
/**
 * 判断url是否来自指定平台
 * @param {*} url 
 * @param {*} platform 
 * @returns 
 */
const isFromPlatform = (url, platform = "chaturbate") => {
    if (typeof url == "object" && url.url) {
        url = url.url;
    }
    var regTxt = honey.config.urls[platform].pattern;
    if (Array.isArray(regTxt)) {
        // return regTxt.any(el => {
        //     if (el[0] == "*") {
        //         el = `.${el}`
        //     }
        //     return new RegExp(el, 'i').test(url)
        // })
        for (var el in regTxt) {
            if (el[0] == "*") {
                el = `.${el}`
            }
            return new RegExp(el, 'i').test(url)
        }
    }
    if (regTxt[0] == "*") {
        // regTxt.splice(0,1)
        regTxt = `.${regTxt}`
    }

    return new RegExp(regTxt, 'i').test(url)
}
/**
 * 获取url所属平台
 * @param {*} url 
 * @returns 
 */
const getFromPlatform = (url) => {
    if (/^chrome-extension/i.test(url)) {
        return "chrome-extension"
    }
    if (!honey.config.urls) {
        return "unkown"
    }
    for (var key of Object.keys(honey.config.urls)) {
        if (isFromPlatform(url, key)) {
            return key;
        }
    }
    return "";
}
// 将chrome.scripting.executeScript转换为Promise
function executeScript(tabId, func) {
    return new Promise((resolve, reject) => {
        chrome.scripting.executeScript({
            target: { tabId },
            function: func
        }, (results) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            resolve(results && results[0] ? results[0].result : null);
        });
    });
}
/**
 * 操作本地存储,如果value有值，为存储，value未传值，则为读取，json内容{key:value}
 * @param {*} key 
 * @param {*} value 
 * @returns 
 */
function storage(key, value) {
    if (arguments.length == 1) {
        return new Promise((res, rej) => {
            chrome.storage.local.get(key, (t) => {
                if (chrome.runtime.lastError) {
                    console.error(chrome.runtime.lastError);
                    rej(chrome.runtime.lastError)
                } else {
                    res(t)
                }
            });
        })
    } else {
        return new Promise((res, rej) => {
            var d = {};
            if (value == null) {
                chrome.storage.local.remove(key, function () {
                    res();
                })
                return;
            }
            d[key] = value;
            chrome.storage.local.set(d, () => {
                res();
            });
        })
    }
}
/**
 * 获取本地存储值
 * @param {*} key 
 * @returns 
 */
async function getStorage(key) {
    var t = await storage(key);
    if (!t) {
        return null;
    }
    return t[key]
}
/**
 * 调用api请求
 * @param {*} url 
 * @param {*} method 
 * @param {*} data 
 * @param {*} headers 
 * @returns 
 */
async function api(url, method, data, headers) {
    try {
        var headOpts = {
            'Content-Type': 'application/json',
            ...headers
        }
        var token = await honey.front.getToken();
        if (token) {
            if (!/Bearer/i.test(token)) {
                token = `Bearer ${token}`
            }
            headOpts.authorization = `${token}`;
        }
        var params = ""
        if (data) {
            params = JSON.stringify({
                ...data
            })
        }
        var url = url.replace("@server", honey.config.serverBaseUrl)
            .replace("@local", honey.config.localBaseUrl)
        const response = await fetch(`${url}`, {
            method: method || 'POST',
            headers: headOpts,
            body: params
        });
        return await response.json();
    } catch (ex) {
        throw ex
    }
}
/**
 * 等待指定时间
 * @param {*} duration 等待时间，单位毫秒
 * @returns 
 */
async function sleep(duration = 500) {
    return new Promise((res, rej) => {
        setTimeout(() => {
            res();
        }, duration);
    })
}
function compareVersions(version1, version2) {
    // 移除版本号中的v前缀，并分割成数字数组
    const v1 = version1.replace(/^v/i, '').split('.').map(Number);
    const v2 = version2.replace(/^v/i, '').split('.').map(Number);

    // 取两个版本号中较长的长度
    const maxLength = Math.max(v1.length, v2.length);

    // 逐个比较每个版本层级
    for (let i = 0; i < maxLength; i++) {
        // 对于较短的版本号，缺失的部分用0补充
        const num1 = i < v1.length ? v1[i] : 0;
        const num2 = i < v2.length ? v2[i] : 0;

        if (num1 > num2) {
            return 1;
        } else if (num1 < num2) {
            return -1;
        }
    }

    // 所有层级都相等
    return 0;
}
//#endregion

(function () {
    const T = {
        eventDispath: "Event-Dispatch",
        authToken: "Get-Auth-Token"
    }

    //#region 注册平台通信渠道 channel

    const PlatformChannel = {
        getRoomPagePattern(platform) {
            return honey.config.urls[platform].roomPagePatten || ""
        },
        getLiveTab(platform, isAll = false) {
            return new Promise((res, rej) => {
                chrome.tabs.query({ url: this.getRoomPagePattern(platform) }, (tabs) => {
                    if (tabs && tabs.length > 0) {
                        res(isAll ? tabs : tabs[0])
                    } else {
                        res(null)
                    }
                });
            })
        },
        canSendMsg(platform) {
            return new Promise((res, rej) => {
                chrome.tabs.query({ url: this.getRoomPagePattern(platform) }, (tabs) => {
                    if (tabs && tabs.length > 0) {
                        res(true)
                    } else {
                        res(false)
                    }
                });
            })
        },
        async post(platform, type, data) {
            var tab = await this.getLiveTab(platform);
            if (!tab) {
                return { success: false, data: { errCode: "404" } }
            }
            return await sendTabMessage(tab.id, type, {
                platform: honey.name,
                ...data
            })
        },
        async directPost(tabId, platform, type, data) {
            return await sendTabMessage(tabId, type, {
                platform: honey.name,
                ...data
            })
        },
        connector(platform) {
            return Connector.get(platform);
        },
        async interactUser(platform, type, data) {
            //{ platform:"",type:"interactUser",data:{ type:"mute",username:"",info:user的所有信息}}
            return await this.post(platform, type, data);
        }
    }
    //#endregion

    //#region 与平台的通信渠道
    class Connector {
        static platforms = []
        constructor(tabId, platform) {
            this.tabId = tabId;
            this.connector = null;
            this.name = "room";
            this.platform = platform
            Connector.platforms.push(platform)
        }
        static exist(platform) {
            return !!Connector[`@${platform}`]
        }
        static get(platform) {
            return Connector[`@${platform}`]
        }
        /**
         * Creates a new Connector instance for the given tab if it doesn't exist, 
         * or returns the existing one.
         * @param {number} tabId - The ID of the tab to connect to
         * @param {string} name - The name of the connector
         * @param {string} platform - The platform of the connector
         * @returns {Connector} The existing or newly created Connector instance
         */
        static create(tabId, platform) {
            if (Connector.exist(platform)) {
                return Connector.get(platform);
            }

            return new Connector(tabId, platform)
        }

        static disconnect(platform) {
            if (Connector.exist(platform)) {
                if (Connector.get(platform)?.disconnect)
                    Connector.get(platform)?.disconnect();

                delete Connector[`@${platform}`];
            }
        }
        /**
         * 断开了就开始连接新的tab页面
         * @param {*} onMessage 
         */
        async reconnectNewTab(onMessage) {
            var tabs = await queryTabs({ url: honey.config.urls[this.platform]['roomPagePatten'] });
            if (tabs && tabs[0]) {
                this.tabId = tabs[0].id;
                this.connect(onMessage)
            }
        }

        connect(onMessage) {
            //保持平台单个连接
            if (Connector[`@${this.platform}`]) {
                return;
            }
            this.connector = chrome.tabs.connect(this.tabId, {
                name: `${this.name}`,      // 连接名称（可选）
                // frameId: 0                 // 指定iframe（可选，默认主框架）
            });

            Connector[`@${this.platform}`] = this
            var ths = this;
            this.connector.onMessage.addListener((message) => {
                // console.log("connect message", message)
                if (onMessage) {
                    onMessage.call(ths, message);
                }
            });
            this.connector.onDisconnect.addListener(() => {
                console.log("background断开了连接");
                ths.connector.d
                delete Connector[`@${ths.platform}`];
                // ths.reconnectNewTab(onMessage);
            });
            this.post({ type: "version", data: honey.version || "" })
            this.cached = {};
            Track.track("live-page", this.platform)
        }
        static broadcast(data) {
            for (var pt of Connector.platforms) {
                var ctor = Connector.get(pt);
                if (ctor) {
                    try {
                        ctor.post(data);
                    } catch (ex) {

                    }
                }
            }
        }
        post(...args) {
            this.connector.postMessage(...args)
        }
        postSync(data, timeout) {
            data = data || {}
            const timestamp = Date.now();
            const random = Math.random().toString(36).slice(2, 10); // 8位随机字符串
            var reqId = `${data.type || "req"}_${timestamp}_${random}`;
            var t = this;
            return new Promise((res, rej) => {
                var channel = this.connector, timer;
                // 定义消息处理函数
                function handleMessage(message) {
                    console.log('收到消息:', message);
                    if (message.requestId != reqId && message.callbackId && message.callbackId == reqId) {
                        // 处理消息...
                        channel.onMessage.removeListener(handleMessage);
                        res(message);
                        if (timer) {
                            clearTimeout(timer)
                        }
                    }
                }
                if (timeout) {
                    timer = setTimeout(() => {
                        channel.onMessage.removeListener(handleMessage);
                        rej()
                    }, timeout);
                }
                channel.onMessage.addListener(handleMessage);
                channel.postMessage({
                    ...data,
                    requestId: reqId,
                })
            })
        }
        cached = null
        userProfile = null
    }


    /**
     * Handles chrome.rumtime.connect messages from the connected.
     */
    function handleChannelMessage(data) {
        const { type, requestId } = data;
        switch (data.type) {
            case honey.c.xping:
                onPing.call(this, data, this.platform);
                break;
            case honey.c.websocket:
            case honey.c.xhr:
            case honey.c.xfetch:
            case honey.c.xworker:
                const d = data.data;
                // console.log("type", type);
                // if (this.platform === "stripchat") {
                //     console.log("====================>stripchat")
                //     console.log(d)
                // }
                offscreen.transferConnect(type,
                    { data: d.data, url: d.url, requestId, from: data.from, profile: this.userProfile },
                    this.platform, requestId)
                break;
            case honey.c.chatEvent:
                const dm = data.message
                offscreen.transferConnect(type,
                    { data: dm, requestId, profile: this.userProfile },
                    this.platform, requestId)
                break;
            case honey.c.toOffscreen:
                offscreen.transferConnect(data.type,
                    { data: data.data, url: data.url, requestId, from: data.from, profile: this.userProfile },
                    this.platform, requestId)
                break;
            case honey.c.toOffscreenUdf:
                offscreen.transferConnect(honey.c.offscreenUDF,
                    { data: data.data, url: data.url, from: data.from, requestId, profile: this.userProfile },
                    this.platform, requestId)
                break;
            case honey.c.postChatEvent:
                local.event(this.platform, data)
                break;
            case honey.c.toOffscreenSync:
                offscreen.sendMessageSync(data.target, data.data || {})
                    .then((syresult) => {
                        // sendResponse({ success: true, data: syresult })
                    })
                return true;
            case honey.c.toProfile:
                profile.transferConnect(data.type,
                    { data: data.data, url: data.url, requestId, from: data.from, profile: this.userProfile },
                    this.platform, requestId)
                break;
            case honey.c.toProfileSync:
                var result = profile.sendMessageSync(data.type, data.data || {})
                // sendResponse({ success: true, data: result })
                break;
            case honey.c.userSignout:
                front.dispatchEvent("User-Signout")
                // sendResponse({ success: true })
                break;
            case honey.c.syncTipmenuCallback:
                front.dispatchEvent(honey.c.syncTipmenuCallback, { platform: this.platform, ...data.data })
                break;
            case honey.c.sdkEvent:
                offscreen.transferConnect(honey.c.sdkEvent, { ...data.data, platform: this.platform, }, this.platform)
                break;
            case honey.c.userScirptsRegister:
                ext.registerScript(data);
                return true;

        }
    }

    function onPing(data) {
        // console.log("=========ping")
        // console.log("ping data", this.platform, data.state, data)
        this.userProfile = data;
        var isLive = data.state;
        if (data.isFirst) {
            return;
        }
        if (isLive == "live") {
            isLive = 1;
        } else if (isLive == "unknow") {
            isLive = 0;
        } else {
            isLive = 2;
        }
        try {
            //state 直播状体
            local.ping(this.userProfile.username, isLive, this.platform, data.url)
            if (offscreen.hasConnected()) {
                offscreen.sendMessage(honey.c.PingOffscreen, {
                    ...data,
                    liveState: isLive
                })

                offscreen.post("Ping-From-Platform", {
                    ...data,
                    liveState: isLive
                })
            }
        } catch (ex) {

        }
        try {
            front.dispatchEvent("OnLiveStateChanged", {
                platform: this.platform,
                live: isLive,
                username: this.userProfile.username,
                url: data.url,
            })
        } catch (e) {

        }
    }
    //连接直播页面
    function connectToRoomPage(req, tabId, platform) {
        if (!Connector.exist(platform)) {
            var port = Connector.create(tabId, platform)
            port.connect(handleChannelMessage);

            try {
                //当某一个camsite 打开时，自动打开chatbox
                console.log(`ext.openchatbox`)
                ext.openChatBox();
            } catch (ex) { }
        } else {
            var port = Connector.get(platform);
        }
    }

    //页面加载
    function onPageLoaded(req, from, platform) {
        const { url, tab } = from;
        //直播页面
        // if (new RegExp(honey.config.urls[platform].roomPage).test(url)) {
        //     connectToRoomPage(req, tab.id, platform);
        // }
        if (arrayRegTest(honey.config.urls[platform].roomPage, url)) {
            connectToRoomPage(req, tab.id, platform);
        }
    }

    function onPageClose(req, from, platform) {
        const { url } = from;
        //直播页面
        // if (new RegExp(honey.config.urls[platform].roomPage).test(url)) {
        //     if (Connector.exist(platform)) {
        //         Connector.disconnect(platform);
        //     }
        // }
        if (arrayRegTest(honey.config.urls[platform].roomPage, url)) {
            if (Connector.exist(platform)) {
                Connector.disconnect(platform);
            }
        }
    }

    //#endregion

    //#region  runtime 消息通道
    // 监听来自content script的消息
    const runtimeOnMessageHandler = async (request, sender, sendResponse) => {
        const { type, platform, data, requestId } = request;
        //判断来源平台
        // console.log("-------------type", type)
        // console.log(request)
        const fromPlatform = getFromPlatform(sender.url);
        // console.log("from url", sender.url, fromPlatform)
        switch (type) {
            case honey.c.domloaded:
                onPageLoaded(request, sender, platform);
                sendResponse({ success: true })
                break;
            case honey.c.monitorloaded:
                MonitorServer.connect(request, sender, platform)
                sendResponse({ success: true })
                break;
            case honey.c.connectingMonitor:
                MonitorServer.connect(request, sender, platform)
                sendResponse({ success: true })
                break;
            case honey.c.pageClose:
                onPageClose(request, sender, platform);
                sendResponse({ success: true })
                break;
            case honey.c.pageClosing:
                onPageClose(request, sender, fromPlatform);
                sendResponse({ success: true })
                break;
            case honey.c.extensionsStatus:
                sendResponse({
                    success: true
                });
                break;
            case honey.c.sendMsg:
                //所有平台发送消息
                if (!platform) {
                    for (var key of Object.keys(honey.config.platform)) {
                        if (!Connector.exist(key)) {
                            //目标平台没有加载
                            continue
                        }
                        await PlatformChannel.post(key, "Send-Message", { message: request.message });
                    }
                }
                //指定平台发送消息
                if (platform && Connector.exist(platform)) {
                    // console.log(`发送消息至 ${platform} 消息：${request.message}`)
                    var r = await PlatformChannel.post(platform, "Send-Message", { message: request.message });
                    sendResponse({ success: true, data: r?.data })
                }
                break;
            case honey.c.sendPmMsg:
                const messageContent = { message: request.message, username: request.username, info: request.info }

                //所有平台发送消息
                if (!platform) {
                    for (var key of Object.keys(honey.config.platform)) {
                        if (!Connector.exist(key)) {
                            //目标平台没有加载
                            continue
                        }
                        await PlatformChannel.post(key, honey.c.sendPmMsg, messageContent);
                    }
                }
                //指定平台发送消息
                if (platform && Connector.exist(platform)) {
                    console.log(`发送消息至 ${platform} 消息：${request.message}`)
                    var r = await PlatformChannel.post(platform, honey.c.sendPmMsg, messageContent);
                    sendResponse({ success: true, data: r.data })
                }
                break;
            case honey.c.ping:
                // 处理ping请求，用于检查扩展是否已安装
                sendResponse({ success: true, version: honey.version });
                return true;
            case honey.c.platformForChat:
                var list = []
                for (var key of Object.keys(honey.config.platform)) {
                    if (!Connector.exist(key)) {
                        //目标平台没有加载
                        continue
                    }
                    var res = await PlatformChannel.canSendMsg(key);
                    if (res) {
                        list.push(key)
                    }
                }
                sendResponse({
                    success: true,
                    data: list || []
                });
                break;
            case honey.c.platformForLive:
                var list = []
                if (!honey.config || !honey.config.platform) {
                    return sendResponse({
                        success: true,
                        data: list || []
                    })
                }
                for (var key of Object.keys(honey.config.platform)) {
                    if (!Connector.exist(key)) {
                        //目标平台没有加载
                        continue
                    }

                    var res = await PlatformChannel.post(key, "Get-Living-State", {
                        platform: honey.name
                    });
                    // console.log("Get-Living-State post message", res)
                    if (res && res.success) {
                        list.push({
                            platform: key,
                            state: res.data
                        })
                    }
                }
                return sendResponse({
                    success: true,
                    data: list || []
                })
            case honey.c.fetch:
                var resp = await api(request.data.url, request.data.method, request.data.requestBody);
                sendResponse({
                    success: true,
                    data: resp
                })
                break;
            case honey.c.getViewers:
                var d = []
                for (var key of Object.keys(honey.config.platform)) {
                    if (!Connector.exist(key)) {
                        //目标平台没有加载
                        continue
                    }
                    var res = await PlatformChannel.post(key, "Get-Viewers", {
                        platform: honey.name
                    });
                    console.log("Get-Viewers", key, res)
                    if (res && res.success)
                        d.push({
                            platform: key,
                            viewers: res.data
                        })
                }
                sendResponse({
                    success: true,
                    data: d
                })
                break;
            case honey.c.openChatBox:
                ext.openChatBox();
                sendResponse({ success: true });
                break;
            case honey.c.openProfile:
                ext.openProfile();
                sendResponse({ success: true });
                break;
            case honey.c.openPopup:
                ext.openPopup(data);
                sendResponse({ success: true });
                break;
            case honey.c.tipAnimationChanges:
                onTipAnimationChanged(request.data);
                sendResponse({ success: true })
                break;
            case honey.c.userLogout:
                sendResponse({ success: true })
                break;
            case honey.c.notifyUserLogout:
                front.logoutFromProfile().finally(() => {

                    //遗弃前端退出，通知插件退出，全部由websocket 通知
                    sendResponse({ success: true })
                });
                break;
            case honey.c.userLogin:
                await front.userLogin(request.data);
                sendResponse({ success: true })
                break;
            case honey.c.toOffscreen:
                await offscreen.transferConnect(honey.c.offscreen, data);
                sendResponse({ success: true })
                break;
            case honey.c.toOffscreenSync:
                offscreen.sendMessageSync(data.target, data.data || {}).then(res => {
                    sendResponse({ success: true, data: res?.data })
                });
                break;
            case honey.c.interactUser:
                var resultinteractUser = await PlatformChannel.interactUser(data.platform, data.type, data.data || {});
                sendResponse({ success: true, data: resultinteractUser.data });
                break;
            case honey.c.transferPlatformsAction:
                var d = []
                for (var key of Object.keys(honey.config.platform)) {
                    if (!Connector.exist(key)) {
                        //目标平台没有加载
                        continue
                    }
                    var res = await PlatformChannel.post(key, data.type, {
                        platform: honey.name,
                        ...data.data
                    });
                    if (res && res.success)
                        d.push({
                            platform: key,
                            data: res.data
                        })
                }
                sendResponse({ success: true, data: d });
                break;
            case honey.c.transferPlatformAction:
                if (Connector.exist(platform)) {
                    var res = await PlatformChannel.post(platform, data.type, {
                        platform: honey.name,
                        ...data.data
                    });
                    if (res && res.success) {
                        sendResponse({ success: true, data: res.data });
                    }
                    else {
                        sendResponse({ success: false, data: res.data });
                    }
                }
                break;
            case honey.c.openUrl:
                var resultopenUrl = await ext.openUrl(data.url);
                sendResponse({ success: true, data: resultopenUrl.data })
                break;
            case honey.c.openExtPage:
                var resultopenExtPage = await ext.openExtPage(data.url);
                sendResponse({ success: true, data: resultopenExtPage.data })
                break;
            case honey.c.getConfig:
                var resultconf = honey.config.urls[request.platform];
                sendResponse({ success: true, data: resultconf })
                break;
            case honey.c.chatEvent:
                const dm = data.message
                offscreen.transferConnect(type,
                    { data: dm, requestId, profile: null },
                    platform, requestId)
                break;
            case honey.c.getStreamSetting:
                const resultpost = await PlatformChannel.post(platform, honey.c.getStreamSetting, {});
                sendResponse({ success: resultpost?.success, data: resultpost?.data })
                break;
            case honey.c.shareLink:
                const url = await getCurrentTabUrl();
                const fromPlatform = getFromPlatform(url);

                if (!fromPlatform) {
                    sendResponse({ success: false });
                } else {
                    sendResponse({ success: true, url: url, platform: fromPlatform });
                }
                break;
            case honey.c.popupLogout:
                if (honey.config.pages.front.loginUrl) {
                    chrome.runtime.sendMessage({ type: 'close-popup', baseUrl: honey.config.pages.front.loginUrl });
                }
                sendResponse({ success: true });
                break;
            case honey.c.connectedToyChanged:
                var devices = data.devices;
                await storage("connected-toys", devices);
                sendResponse({ success: true })
                break;
            case honey.c.getConnectedToy:

                //1.4.5
                var devices = ToyConnector.devices
                var devs = []
                for (var d of devices) {
                    if (d.status == "connected") {
                        devs.push(d)
                    }
                }
                return sendResponse({ success: true, data: devs })
                break;
            case honey.c.connectToyNow:
                front.activeHomePage();
                sendResponse({ success: true });
                return;
            case honey.c.syncTipmenu:
                var connector = PlatformChannel.connector(platform);
                if (!connector) {
                    // sendResponse({ success: false, data: { msgcode: "404" } })
                    sendResponse({ success: true })
                    return;
                }
                connector.post({
                    type: honey.c.syncTipmenu,
                    data: data
                })
                sendResponse({ success: true })
                return;
            case honey.c.getStreamSetting:
                const livetab = await PlatformChannel.getLiveTab(platform);
                if (!livetab) {
                    sendResponse({ success: false, data: { code: 404 } })
                    return;
                }
                var r = await PlatformChannel.directPost(tabs?.id, platform, type, data);
                sendResponse({ success: r.success, data: r.data })
                return;
            case honey.c.getToys:
                // front.directMessageSync("Get-Toys", {}).then(r => {
                //     sendResponse({ success: true, data: r.data })
                // }).catch(e => {
                //     sendResponse({ success: false, error: "error" })
                // })
                sendResponse({ success: true, data: ToyConnector.devices })
                return true;
            case honey.c.clientLoginState:
                front.getToken().then(res => {
                    sendResponse({
                        success: true,
                        data: {
                            login: !!res
                        }
                    })
                }).catch(e => {
                    sendResponse({ success: false, })
                })
                return true;
            case honey.c.connectedDevicesChange:
                notifyDevicesChange();
                sendResponse({ success: true, })
                return true;
            case honey.c.frontOnLoaded:
                if (data.type == "web" && !front.homePageTabId) {
                    front.homePageTabId = sender.tab?.id
                    front.homePageWindowId = sender.tab?.windowId;
                }
                sendResponse({ success: true, })
                return true;
            case honey.c.frontOnUnLoaded:
                if (data.type == "web" && front.homePageTabId && front.homePageTabId == sender.tab?.id) {
                    front.homePageTabId = null
                    front.homePageWindowId = null;
                }
                front.directMessage("front-unload", {})
                sendResponse({ success: true, })
                return true;
            case honey.c.gotoLogin:
                front.gotoLogin();
                sendResponse({ success: true, })
                return true;
            case honey.c.openHomePage:
                front.activeHomePage();
                sendResponse({ success: true, })
                return true;
            case "Get-Current-Url-Platform":
                front.getCurrentUrlPlatform().then(res => {
                    sendResponse({ success: true, data: res })
                })
                return true;
            case honey.c.restartApp:
                ext.restartApp();
                sendResponse({ success: true, })
                return true;
            case honey.c.userScriptsAvailable:
                sendResponse({ success: true, data: ext.isUserScriptsAvailable, })
                return true;
            case honey.c.userScirptsRegister:
                ext.registerScript(data).finally(() => {
                    sendResponse({ success: true, data: ext.isUserScriptsAvailable, })
                })
                return true;
            case honey.c.preCheckAddToys:
                openWebSiteAndSendMessage({
                    type: 'PRE_CHECK_ADD_TOYS'
                })
                return true;
            case honey.c.preCheckScanQrCode:
                openWebSiteAndSendMessage({
                    type: 'PRE_CHECK_SCAN_QR_CODE'
                })
                return true;
            case honey.c.preCheckConnectVideoFeedback:
                console.log('PRE_CHECK_CONNECT_VIDEO_FEEDBACK request message');
                openWebSiteAndSendMessage({
                    type: 'PRE_CHECK_CONNECT_VIDEO_FEEDBACK',
                    platform: getPlatformByUrl(request.url)
                })
                return true;
            case honey.c.preCheckExternalOpenObs:
                openWebSiteAndSendMessage({
                    type: 'PRE_CHECK_EXTERNAL_OPEN_OBS',
                    platform: getPlatformByUrl(request.url)
                })
                return true;
        }
        return true;
    }
    function notifyDevicesChange() {
        front.broadcast({
            type: "notify-devices-change"
        });
        offscreen.sendMessage(honey.c.notifyDevicesChange, {});
        profile.sendMessage(honey.c.notifyDevicesChange, {})
    }
    chrome.runtime.onUserScriptMessage.addListener(runtimeOnMessageHandler)
    chrome.runtime.onMessage.addListener(runtimeOnMessageHandler);
    // 监听来自外部网页的消息
    chrome.runtime.onMessageExternal.addListener(runtimeOnMessageHandler);
    function onTipAnimationChanged(items) {
        const data = items.map(el => {
            return el;
        })
        local.post(`/api/v1/pc/cache/tip/special-effects`, data)
    }
    //#endregion

    //#region toy connector
    class ToyConnector {
        constructor() {
        }
        static devices = []
        static devicesFromApp = []
        static syncDevices(devs) {
            this.devices = devs || [];
            // front.broadcast({
            //     type: "toyconnector-sync-list",
            //     data: devs
            // })
            ToyConnector.broadcastDevices();
        }
        static syncDevicesFromApp(devs) {
            this.devicesFromApp = (devs || []);
            ToyConnector.broadcastDevices();
        }
        static broadcastDevices() {
            var devs = (ToyConnector.devices || []).concat(ToyConnector.devicesFromApp || []);
            try {
                Connector.broadcast({
                    type: "post-message",
                    data: {
                        type: "toyconnector-sync-list",
                        toys: devs,
                    },
                    requestId: "none"
                })
            } catch (ex) {

            }
            front.broadcast({
                type: "toyconnector-sync-list",
                data: devs
            })
        }
        static async connect(toyId) {
            try {
                var devs = ToyConnector.devices;
                devs.forEach(el => {
                    if (el.uuid == toyId) {
                        el.status = "connecting"
                    }
                })
                ToyConnector.syncDevices(devs);
                const payload = {
                    uuid: toyId
                };
                function _restoreConnect() {
                    var devs = ToyConnector.devices;
                    devs.forEach(el => {
                        if (el.uuid == toyId) {
                            el.status = ""
                        }
                    })
                    ToyConnector.syncDevices(devs);
                }
                const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/connect?x=` + new Date().valueOf(),
                    {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify(payload)
                    }
                ).catch((ex) => {
                    _restoreConnect();
                    return {
                        ok: false,
                        data: ToyConnector.devices
                    };
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 0) {

                        var devs = ToyConnector.devices;
                        devs.forEach(el => {
                            if (el.uuid == toyId) {
                                el.status = "connected"
                            }
                        })
                        ToyConnector.syncDevices(devs);
                        return {
                            ok: true,
                            data: ToyConnector.devices
                        }
                    }
                }

                _restoreConnect();
                // var devs = ToyConnector.devices;
                // devs.forEach(el => {
                //     if (el.uuid == toyId) {
                //         el.status = ""
                //     }
                // })
                // ToyConnector.syncDevices(devs);
                return {
                    ok: true,
                    data: ToyConnector.devices
                }

            } catch (err) {
                _restoreConnect();
                console.error('连接设备失败:', err);
                return {
                    ok: true,
                    data: ToyConnector.devices
                }
            }
        }

        static async disconnect(toyId) {
            try {
                const payload = {
                    uuid: toyId
                };

                var devs = ToyConnector.devices;
                devs.forEach(el => {
                    if (el.uuid == toyId) {
                        el.status = ""
                    }
                })

                ToyConnector.syncDevices(devs);
                const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/disconnect`,
                    {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify(payload)
                    }
                );
                if (response.ok) {

                    const data = await response.json();
                    if (data.code === 0) {

                        ToyConnector.syncDevices(devs);
                        return {
                            ok: true,
                            data: ToyConnector.devices
                        }
                    }

                    ToyConnector.syncDevices(devs);
                    return {
                        ok: false,
                        data: ToyConnector.devices,
                    }
                }
            } catch (err) {
                console.error('断开设备连接失败:', err);
                return {
                    ok: false,
                    data: ToyConnector.devices
                }
            }
        }

        static async delete(toyId) {
            var devs = ToyConnector.devices;
            var index = devs.findIndex(el => {
                return el.uuid == toyId
            })
            if (index > -1)
                devs.splice(index, 1)
            ToyConnector.devices = devs;
            ToyConnector.syncDevices(devs);
            return true;
        }

        static abortSignal = null

        static async getDeviceStatus(toyId) {
            const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/stats?uuid=${toyId}`,
                {
                    method: 'GET'
                }
            );
            if (response.ok) {
                const data = await response.json();
                if (data.data.length > 0) {
                    return data.data[0]
                }
            }
            return null
        }


        static async testToy(toyId) {
            if (!toyId) {
                return;
            }

            const payload = {
                'uuid': toyId
            };
            await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/test`,
                {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(payload)
                }
            );
        }

        static async getProduct() {
            try {
                var devs = ToyConnector.devices
                if (!devs || !devs.length) {
                    return []
                }
                var ids = devs.map(el => {
                    return el.product_id
                });
                if (!ids.length) {
                    return [];
                }
                const response = await fetch(`${honey.config.serverBaseUrl}/system/toyReactionRules/productList`, {
                    method: "POST",
                    headers: {
                        'Authorization': `Bearer ${await front.getToken()}`,
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        productIdList: ids
                    })
                });
                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 1000) {
                        devs.map(el => {
                            for (var item of data.data) {
                                if (item.productId == el.product_id)
                                    el.product = item;
                            }
                        })

                        ToyConnector.devices = devs;
                        ToyConnector.syncDevices(devs);
                    }
                }
            } catch (e) {
            }
        }

        static async discover() {
            const timeout = 5;
            try {
                console.log(`toy connector discover--`, this.usbTimer, this.watchingDeviceStats)
                this.abortSignal = new AbortController();
                const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/search?timeout=` + timeout,
                    {
                        method: 'GET',
                        headers: {
                            'Authorization': `Bearer ${await front.getToken()}`,
                        },
                        signal: this.abortSignal.signal
                    },
                );

                if (response.ok) {
                    const data = await response.json();
                    if (data.code === 0) {
                        var devs = (data.data.data || []).map((el) => {
                            el.canTurnon = true;
                            el.status = el.in_use ? "connected" : ""
                            return el;
                        })
                        ToyConnector.devices = devs;
                        await this.getProduct()
                    } else {
                        console.log(data.message);
                        ToyConnector.devices = []
                        ToyConnector.syncDevices([]);
                    }
                } else {
                    ToyConnector.devices = []
                    ToyConnector.syncDevices([]);
                }
            } catch (err) {
                if (err != "abortSignalClose") {
                    // setTimeout(() => {
                    //     useToyConnector.getState().setConnectState("success")
                    // }, 10);
                }
                ToyConnector.syncDevices([]);
                console.error('connect error', err);
            } finally {
                return []
            }
        }
        switchMode(mode) {
            ToyConnector.mode = mode;
        }
        static usbState = ""
        static setUsbState(state) {
            ToyConnector.usbState = state;
            front.broadcast({
                type: "toyconnector-usb-state",
                data: state
            })
        }

        static bluetoothState = ""
        static setBlueetoothState(bluetoothState) {
            ToyConnector.bluetoothState = bluetoothState;
            front.broadcast({
                type: "toyconnector-bluetooth-state",
                data: bluetoothState
            })
        }

        static hasError = false
        static setHasError(hasError) {
            ToyConnector.hasError = hasError;
            front.broadcast({
                type: "toyconnector-has-error",
                data: hasError
            })
        }

        static async _watchUsbState() {
            try {
                var token = await front.getToken();
                if (!token) {
                    return;
                }
                if (ToyConnector.mode && ToyConnector.mode != "pc") {
                    return;
                }
                const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/usbinfo?nocahce=${new Date().valueOf()}`,
                    {
                        method: 'GET',
                        headers: {
                            'Authorization': `Bearer ${token}`,
                        }
                    }
                );
                if (response.ok) {
                    // useToyConnector.getState().setError(false)
                    ToyConnector.setHasError(false)
                    const data = await response.json();
                    if (data.code === 0) {
                        //返回 is_occupy 占用状态，如果被占用
                        // if (useToyConnector.getState().mode != "pc") {
                        //     return
                        // }
                        try {
                            offscreen.post("usb-status", data.data);
                        } catch (ex) { }
                        let has_usb = data.data.has_usb, is_occupy = data.data.is_occupy;
                        if (data.data.platform == "windows") {

                        }
                        if (data.data.platform == "darwin") {
                            ToyConnector.setBlueetoothState(has_usb);
                            has_usb = true;
                            is_occupy = false;
                        }

                        if (has_usb) {
                            // const connectState = useToyConnector.getState().connectState;
                            const connectState = ToyConnector.usbState;
                            if (["searching", "success"].includes(connectState)) {
                                return;
                            }
                            if (is_occupy) {
                                // useToyConnector.getState().setConnectState("usboccupy")
                                ToyConnector.setUsbState("occupy")
                            } else {
                                // useToyConnector.getState().setConnectState("loadusb")
                                ToyConnector.setUsbState("normal")
                            }
                        } else {
                            // useToyConnector.getState().setConnectState("default")
                            ToyConnector.setUsbState("disconnect")
                        }
                        return !is_occupy;
                    } else {
                        console.log(data.message);
                        return false;
                    }
                } else {
                    // useToyConnector.getState().setError(true)

                    ToyConnector.setHasError(true)
                    return false;
                }
            } catch (err) {
                // useToyConnector.getState().setError(true)
                ToyConnector.setHasError(true)
                ToyConnector.syncDevices([]);
                console.error('connect error', err);
                return false
            }
        }

        static async _watchDeviceStats() {

            // var devs = ToyConnector.devices;
            // if (!devs || !devs.length) {
            //     return;
            // }
            var token = await front.getToken();
            if (!token) {
                return;
            }
            const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/stats`,
                {
                    method: 'GET'
                }
            );
            if (response.ok) {
                const data = await response.json();
                var devices = ToyConnector.devices;
                var stats = data.data || []
                var devs = [];
                var version = await local.getVersion();
                var newVersion = isVCBrowser() ? "1.4.11" : "1.0.1";
                // if (compareVersions(version, newVersion) < 0) {
                //     for (var j of devices) {
                //         var has = false;
                //         for (var i of stats) {
                //             if (i.uuid == j.uuid) {
                //                 has = true;
                //                 if (i.in_use) {
                //                     j.status = "connected"
                //                 } else {
                //                     j.status = ""
                //                 }
                //                 devs.push(Object.assign(j, i));
                //             }
                //         }
                //         if (!has && j.status != "connected") {
                //             devs.push(j)
                //         }
                //     }
                //     ToyConnector.syncDevices(devs);
                // } else {
                var needLoadProducts = false
                stats.forEach(el => {
                    if (el.in_use) {
                        el.status = "connected"
                    } else {
                        el.status = ""
                    }
                })
                // for (var i of stats) {
                //     var has = false;
                //     for (var j of devices) {
                //         if (i.uuid == j.uuid) {
                //             if (i.in_use) {
                //                 j.status = "connected"
                //             } else {
                //                 j.status = ""
                //             }
                //             Object.assign(i, j)
                //             has = true;
                //         }
                //     }
                //     if (!has) {
                //         devices.push(i)
                //         needLoadProducts = true;
                //     }
                // }
                ToyConnector.syncDevices(stats);
                // if (needLoadProducts) {
                //     ToyConnector.getProduct();
                // }
                // }
                // for (var j of devices) {
                //     var has = false;
                //     for (var i of stats) {
                //         if (i.uuid == j.uuid) {
                //             has = true;
                //             if (i.in_use) {
                //                 j.status = "connected"
                //             } else {
                //                 j.status = ""
                //             }
                //             devs.push(Object.assign(j, i));
                //         }
                //     }
                //     if (!has && j.status != "connected") {
                //         devs.push(j)
                //     }
                // }
                // ToyConnector.syncDevices(devs);
            }
            return null
        }

        usbTimer = 0
        watchingDeviceStats = 0
        static watching() {
            //开启监听usb状态
            this._watchUsbState();
            if (!this.usbTimer) {
                this.usbTimer = setInterval(() => {
                    try {
                        this._watchUsbState();
                    } catch (ex) {
                        console.log("watchDeviceStats error", ex)
                    }
                }, 5 * 1000)
            }
            if (!this.watchingDeviceStats) {
                //监听设备状态
                this.watchingDeviceStats = setInterval(() => {
                    try {
                        this._watchDeviceStats();
                    } catch (ex) {
                        console.log("watchDeviceStats error", ex)
                    }

                }, 5 * 1000)
            }
            //同步调用一下discover
            // this.discover();
        }

        static async destory() {
            console.log(`toy connector destory`)
            if (this.usbTimer) {
                clearInterval(this.usbTimer)
                this.usbTimer = null
            }
            if (this.watchingDeviceStats) {
                clearInterval(this.watchingDeviceStats)
                this.watchingDeviceStats = null
            }
            if (this.abortSignal) {
                this.abortSignal.abort("abortSignalClose");
                this.abortSignal = null;
            }
            // useToyConnector.getState().setConnectState("")
            ToyConnector.devices = []
            ToyConnector.syncDevices([])
            // const response = await fetch(`${honey.config.localBaseUrl}/api/v1/bluetooth/disconnectall?nocahce=${new Date().valueOf()}`,
            //     {
            //         method: 'POST',
            //         headers: {
            //             'Authorization': `Bearer ${await front.getToken()}`,
            //         }
            //     }
            // );
        }
    }

    //#endregion

    //#region 数据设置监控
    const MonitorServer = function () {
        const channels = {};
        // 生成基于来源URL的唯一key
        function generateUniqueKey(channel) {
            // 1. 获取来源URL（优先从sender中取）
            let sourceUrl = 'unknown-url'; // 默认值
            if (channel.sender && channel.sender.url) {
                sourceUrl = channel.sender.url;
            }
            // 2. 补充时间戳和随机数（确保原始字符串唯一）
            const timestamp = Date.now();
            const random = Math.random().toString(36).slice(2, 10); // 8位随机字符串

            // 原始字符串：[url]_[timestamp]_[random]
            return `${sourceUrl}_${timestamp}_${random}`;
        }
        function genRequestId(type) {
            const timestamp = Date.now();
            const random = Math.random().toString(36).slice(2, 10); // 8位随机字符串

            // 原始字符串：[url]_[timestamp]_[random]
            return `${type}_${timestamp}_${random}`;
        }

        function put(key, channel) {
            channels[key] = channel;
        }
        function get(key) {
            return channels[key];
        }
        function remove(key) {
            delete channels[key]
        }

        function postSync(data, timeout, channel) {
            if (!channel) {
                return Promise.resolve(null);
            }
            data = data || {}
            var reqId = genRequestId(data.type);
            var t = this;
            return new Promise((res, rej) => {
                // 定义消息处理函数
                var timer;
                function handleMessage(message) {
                    console.log('收到消息:', message);
                    if (message.requestId != reqId && message.callbackId && message.callbackId == reqId) {
                        // 处理消息...
                        channel.onMessage.removeListener(handleMessage);
                        res(message);
                        if (timer) {
                            clearTimeout(timer)
                        }
                    }
                }
                if (timeout) {
                    timer = setTimeout(() => {
                        channel.onMessage.removeListener(handleMessage);
                        rej()
                    }, timeout);
                }
                channel.onMessage.addListener(handleMessage);
                channel.postMessage({
                    ...data,
                    requestId: reqId,
                })
            })
        }
        function notify(data, platform) {
            var keys = Object.keys(channels);
            for (var key of keys) {
                var channel = channels[key];
                if (platform) {
                    if (channel && channel.postMessage && platform == channel.platform) {
                        channel.postMessage({
                            ...data,
                            platform: channel.platform,
                            key: key,
                        });
                    }
                } else {
                    if (channel && channel.postMessage) {
                        channel.postMessage({
                            ...data,
                            platform: channel.platform,
                            key: key,
                        });
                    }
                }
            }
        }

        function notifyChanged(key, data) {
            notify({
                requestId: genRequestId("notify-changed"),
                type: `notify-${key}-changed`,
            }, data.platform)
        }

        function notifySync(data, timeout) {
            var keys = Object.keys(channels);
            var promises = [];
            for (var key of keys) {
                var channel = channels[key];
                if (channel && channel.postMessage) {
                    if (platform) {
                        if (platform != channel.platform) {
                            continue;
                        }
                    }
                    var promise = postSync(data, timeout, channel).then(res => {
                        return {
                            data: res,
                            key: key,
                            platform: channel.platform
                        };
                    });
                    promises.push(promise);
                }
            }
            return Promise.all(promises);
        }

        function onMessage(type, data, platform, requestId, name, channel) {
            switch (type) {
                //获取菜单设置
                case "Get-Tip-Menu-Settings":
                    offscreen.sendMessageSync({
                        type: "Transfer-To-Offscreen",
                        data: {
                            type: "Get-Tip-Menu-Settings",
                        },
                        platform: platform,
                        requestId: "transferToOffscreen" + requestId,
                    }).then(r => {
                        callback(type, requestId, r, channel);
                    })
                    break;
                //获取打赏规则设置
                case "Get-Tip-Rule-Settings":
                    offscreen.sendMessageSync({
                        type: "Transfer-To-Offscreen",
                        data: {
                            type: "Get-Tip-Rule-Settings",
                        },
                        platform: platform,
                        requestId: "transferToOffscreen" + requestId,
                    }).then(r => {
                        callback(type, requestId, r, channel);
                    })
                    break;
                //转发给后台动态代码处理
                case "Transfer-To-Offscreen":
                case "Transfer-To-Offscreen-Sync":
                    offscreen.sendMessageSync("Transfer-To-Offscreen", {
                        data: { platform },
                        type: data.target,
                    }).then(r => {
                        callback(type, requestId, r, channel);
                    })
                    break;
                case "Transfer-To-Monitor-Sync":
                    notifySync({
                        type: data.target,
                        data: data.data,
                        platform: platform,
                        requestId: "transferToMonitor_" + requestId,
                    })
                    break;
            }
        }

        function errorCallback(type, requestId, data, channel) {
            if (!channel) {
                return;
            }
            return channel.postMessage({
                ok: false,
                type: type + "-callback",
                requestId,
                data,
            })
        }
        function callback(type, requestId, data, channel) {
            if (!channel) {
                return;
            }
            return channel.postMessage({
                ok: true,
                type: type + "-callback",
                requestId,
                data,
            })
        }

        // function listen() {
        //     function processConnect(channel) {
        //         if (channel.name != "monitor") {
        //             return;
        //         }
        //         const key = generateUniqueKey(channel);
        //         channel.onMessage.addListener((port) => {
        //             const { type, data, platform, requestId, name } = port
        //             onMessage(type, data, platform, requestId, name, channel)
        //         });
        //         channel.onDisconnect.addListener(() => {
        //             remove(key);
        //         })
        //     }
        //     chrome.runtime.onConnectExternal.addListener(processConnect);
        //     chrome.runtime.onConnect.addListener(processConnect);
        // }

        function connect(req, from, platform) {
            const { url, tab } = from;
            var key = url;
            if (!get(key)) {
                var channel = chrome.tabs.connect(tab.id, {
                    name: `monitor`,      // 连接名称（可选）
                    // frameId: 0                 // 指定iframe（可选，默认主框架）
                });
                channel.platform = platform;

                channel.onMessage.addListener((d) => {
                    const { type, data, platform, requestId, name } = d
                    onMessage(type, data, platform, requestId, name, channel)
                });
                channel.onDisconnect.addListener(() => {
                    remove(key);
                })
                put(key, channel);
            }
        }
        //监听外部通知
        // listen();

        return {
            put,
            get,
            connect,
            postSync,
            notifySync,
            notifyChanged,
            remove,
            notify,
            callback
        }
    }();
    //#endregion

    //#region front 负责逻辑

    const front = {
        channel: null,
        chatChannel: null,
        extProfileChannel: null,
        isLogin: false,
        homePageTabId: null,
        homePageWindowId: null,
        async sendToFronts(type, data) {
            if (!honey.config?.front?.pattern) {
                return;
            }
            var tabs = await queryTabs({ url: honey.config.front.pattern })
            if (tabs) {
                for (var tab of tabs)
                    sendTabMessage(tab.id, type, data)
            }
        },
        async gotoLogin() {
            var queried = await queryFrontTabs({ url: honey.config.pages.front.loginUrl || "" })
            if (!queried || !queried.length) {
                chrome.tabs.create({
                    url: honey.config.pages.front.loginUrl || ""
                })
                return;
            }

            setTimeout(() => {
                chrome.tabs.update(queried[0]?.id, { active: true, url: (honey.config.pages.front.loginUrl || "") }, function () {
                });
            }, 1000)
            // 配置刷新参数
            // const reloadOptions = {
            //     bypassCache: false  // true 表示忽略缓存（强制刷新），false 表示使用缓存
            // };
            // setTimeout(() => {
            //     chrome.tabs.reload(queried[0]?.id, reloadOptions);
            // }, 100)
        },
        openHomePage() {
            chrome.tabs.create({
                url: honey.config.pages.front.url
            })
        },
        async activeHomePage() {
            if (!front.channel) {
                front.openHomePage();
                return;
            }
            let tabId = front.channel.sender?.tab?.id;
            if (!tabId) {
                return;
            }
            chrome.tabs.update(tabId, { active: true }, function () {
            });
        },
        async sendAllFronts(type, data) {
            var tabs = await queryFrontTabs({ url: honey.config.front.pattern })
            if (tabs) {
                for (var tab of tabs) {
                    try {
                        sendTabMessage(tab.id, type, data)
                    } catch (ex) {

                    }
                }
            }
        },
        async sendToFront(type, data) {
            var tabs = await queryTabs({ url: honey.config.front.pattern })
            if (tabs && tabs[0]) {
                return await sendTabMessage(tabs[0].id, type, data)
            }
        },
        async sendToHomepage(type, data) {
            if (!front.homePageTabId) {
                return await this.sendToFront(type, data);
            }
            return await sendTabMessage(front.homePageTabId, type, data)

        },
        dispatchEvent(event, data,) {
            front.sendToFronts(honey.c.dispatch, {
                event,
                data
            })
        },
        directMessage(type, data,) {
            front.sendToFronts("Post-Message", {
                data: {
                    type,
                    data
                }
            })
        },
        async directMessageSync(type, data,) {
            var res = await front.sendToFront("Post-Message-Sync", {
                data: {
                    type,
                    data
                }
            })
            return res;
        },
        async directHomepageSync(type, data,) {
            var res = await front.sendToHomepage("Post-Message-Sync", {
                data: {
                    type,
                    data
                }
            })
            return res;
        },
        async getToken() {
            var token = await getStorage("vc.token");
            return token || ""
        },
        userLogin(token) {
            front.token = token;
            if (token) {
                offscreen.post("sync-user-token", {
                    token: token
                })
            }
            try {
                ToyConnector.watching();
            } catch (ex) {
                console.error("user login error", ex)
            }
        },
        // async userLogout(isFromFront) {
        //     front.token = "";
        //     var token = await front.getToken();
        //     storage("vc.token", null)

        //     chrome.runtime.sendMessage({ type: 'close-popup-only' });
        //     try {
        //         ToyConnector.destory();
        //     } catch (ex) {
        //         console.error("close all toy connected status error", ex)
        //     }

        //     // try {
        //     //     //通知各个端，关闭状态
        //     //     front.broadcast({
        //     //         type: "user-logout-from-ext",
        //     //         data: isFromFront,
        //     //     })
        //     // } catch (ex) {
        //     //     console.error("broadcast user logout error", ex)
        //     // }
        //     //close chatbox
        //     var win = await getWindowByUrl(honey.config.pages.chatbox);
        //     if (win)
        //         chrome.windows.remove(win.id)
        //     //close popup
        // },
        /**
         * 来自于websocket的连接，登出
         */
        async logoutFromProfile() {
            try {
                //通知各个端，关闭状态
                var res = await front.sendToFront("Post-Message", {
                    data: {
                        type: "user-logout",
                    }
                })
            } catch (ex) {
                console.error("broadcast user logout error", ex)
            }
        },
        async logoutFromWebsocket() {
            front.token = "";
            await storage("vc.token", null)

            try {
                chrome.runtime.sendMessage({ type: 'close-popup-only' });
            } catch (ex) {

            }

            try {
                ToyConnector.destory();
            } catch (ex) {
                console.error("close all toy connected status error", ex)
            }
            front.syncUserInfo({})

            if (honey.config.pages?.chatbox) {
                var win = await getWindowByUrl(honey.config.pages.chatbox);
                if (win)
                    chrome.windows.remove(win.id)
            }
        },
        /**
         * 来自于websocket的连接，登出
         */
        // async logout() {
        //     var res = await front.sendToFront("Post-Message", {
        //         data: {
        //             type: "user-logout",
        //         }
        //     })
        //     //websocket已连接
        //     fetch(`${honey.config.serverBaseUrl}/auth/web/logout?front=${isFromFront}`, {
        //         method: "post",
        //         headers: {
        //             'Authorization': token ? `Bearer ${token}` : "",
        //             'Accept': 'application/json',
        //         }
        //     }).finally(() => {
        //     })
        //     await this.userLogout();
        //     front.syncUserInfo({})
        // },
        // async userLogoutFromFront() {
        // await this.userLogout(true);
        // front.syncUserInfo({})
        // },
        //获取当前选中的tab 的url，转成平台代码
        async getCurrentUrlPlatform() {
            var url = await getCurrentTabUrl();
            var uri = new URL(url);
            var hostname = uri.hostname;
            hostname = (hostname || "").toLocaleLowerCase();
            for (var item of Object.keys(honey.config.urls)) {
                if (Array.isArray(honey.config.urls[item].domain)) {
                    for (var d of honey.config.urls[item].domain) {
                        if (hostname.indexOf(d) > -1) {
                            return item;
                        }
                    }
                } else {
                    if (hostname.indexOf(honey.config.urls[item].domain) > -1) {
                        return item;
                    }
                }
            }
            return ""
        },
        async syncUserInfo(data) {
            if (data.token) {
                try {
                    await storage("vc.token", data.token)
                    await storage("vc.user.nickname", data.nickname || "")
                    await storage("vc.user.avatar", data.avatar || "")
                    await storage("vc.user.email", data.email || "")
                } catch (ex) {
                    console.error("sync user info error", ex)
                }
                //同步信息后，调用userLogin接口，同步登录逻辑
                await front.userLogin(data.token);
            } else {
                await storage("vc.token", null)
                await storage("vc.user.nickname", null)
                await storage("vc.user.avatar", null)
                await storage("vc.user.email", null)
            }
        },
        async syncWebsiteInfo(data) {
            await storage("vc.site.version", data.version || null)
            await storage("vc.site.lang", data.lang || null)
            await storage("vc.site.url", data.url || null)
        },
        async onMessage(message) {
            const { type, data, platform, requestId } = message;
            switch (type) {
                case "sync-website-info":
                    await front.syncWebsiteInfo(data);
                    return;
                case "sync-user-info":
                    await front.syncUserInfo(data);
                    return;
                case "connect-device":
                    var d = await ToyConnector.connect(data.deviceSn);
                    return await this.callback({ ok: d?.ok, data: ToyConnector.devices }, message)
                case "disconnect-device":
                    var d = await ToyConnector.disconnect(data.deviceSn);
                    return await this.callback({ ok: d?.ok, data: ToyConnector.devices }, message)
                case "destory-connector":
                    var d = await ToyConnector.destory();
                    return await this.callback({ ok: true, data: ToyConnector.devices }, message)
                case "test-device":
                    var d = await ToyConnector.testToy(data.deviceSn);
                    return await this.callback({ ok: true, data: ToyConnector.devices }, message)
                case "delete-device":
                    var d = await ToyConnector.delete(data.deviceSn);
                    return await this.callback({ ok: d, data: ToyConnector.devices }, message)
                case "discover-device":
                    var d = await ToyConnector.discover();
                    return await this.callback({ ok: true, data: ToyConnector.devices }, message)
                case "getlist-device":
                    return await this.callback({ ok: true, data: ToyConnector.devices }, message)
                case "notify-tiprule-changed":
                    MonitorServer.notifyChanged("tiprule", data);
                    return;
                case "notify-tipmenu-changed":
                    MonitorServer.notifyChanged("tipmenu", data);
                    return;
                case honey.c.toOffscreenSync:
                    offscreen.sendMessageSync(data.target, data.data || {})
                    return;
                case honey.c.toOffscreen:
                    offscreen.transferConnect(data.type,
                        { data: data.data, url: data.url, requestId, from: data.from, profile: this.userProfile },
                        this.platform, requestId)
                    break;
                case honey.c.toOffscreenUdf:
                    offscreen.transferConnect(honey.c.offscreenUDF,
                        { data: data.data, url: data.url, from: data.from, requestId, profile: this.userProfile },
                        this.platform, requestId)
                    break;
                case "ToyConnector-Mode-Changed":
                    ToyConnector.mode = data;
                    offscreen.post("ToyConnector-Mode-Changed", {
                        data: data,
                    })
                    break;
                case "OBS-mode-Changed":
                    offscreen.post("OBS-mode-Changed", {
                        data: data,
                    })
                    break;
            }
        },
        postSync(data, timeout) {
            data = data || {}
            var reqId = new Date().valueOf() + `${data.type || "_"}`;
            var t = this;
            return new Promise((res, rej) => {
                // 定义消息处理函数
                var timer;
                function handleMessage(message) {
                    console.log('收到消息:', message);
                    if (message.requestId != reqId && message.callbackId && message.callbackId == reqId) {
                        // 处理消息...
                        t.channel.onMessage.removeListener(handleMessage);
                        res(message);
                        if (timer) {
                            clearTimeout(timer)
                        }
                    }
                }
                if (timeout) {
                    timer = setTimeout(() => {
                        t.channel.onMessage.removeListener(handleMessage);
                        rej()
                    }, timeout);
                }
                t.channel.onMessage.addListener(handleMessage);
                t.channel.postMessage({
                    ...data,
                    requestId: reqId,
                })
            })
        },
        callback(data, parent) {
            if (!this.channel) {
                return
            }
            return this.channel.postMessage({
                ...data,
                callbackId: parent?.requestId || parent,
                requestId: new Date().valueOf() + `${data.type || "_"}`,
            })
        },
        post(data) {
            if (!this.channel) {
                return
            }
            return this.channel.postMessage({
                ...data,
                requestId: new Date().valueOf() + `${data.type || "_"}`,
            })
        },
        /**
         * 广播给前端三个channel  首页，聊天框，插件
         * @param {*} data 
         * @returns 
         */
        broadcast(data) {
            if (!this.channel && !this.chatChannel && !this.extProfileChannel) {
                return
            }
            if (this.channel)
                this.channel.postMessage({
                    ...data,
                    requestId: new Date().valueOf() + `${data.type || "_"}`,
                })
            if (this.chatChannel) {
                this.chatChannel.postMessage({
                    ...data,
                    requestId: new Date().valueOf() + `${data.type || "_"}`,
                })
            }
            if (this.extProfileChannel) {
                this.extProfileChannel.postMessage({
                    ...data,
                    requestId: new Date().valueOf() + `${data.type || "_"}`,
                })
            }
        },
        async listen() {
            function processConnect(port) {
                console.log("======>front  connected:", port.name);
                // 验证连接来源是否为指定域名 app.vibe-connect.net
                let isAllowedDomain = false;
                if (port.sender?.url) {
                    try {
                        // 解析URL获取域名
                        const url = new URL(port.sender.url);
                        // 检查主机名是否匹配（包含可能的子域名）
                        isAllowedDomain = (honey.config.hostname || []).includes(
                            url.hostname.toLocaleLowerCase()
                        );
                    } catch (e) {
                        console.error("解析来源URL失败:", e);
                    }
                }
                if (["front", "chatbox", "ext-profile"].includes(port.name) && !isAllowedDomain) {
                    return;
                }

                //同时开始玩具监控
                ToyConnector.watching();
                if (port.name == "front") {
                    if (front.channel) {
                        //已经打开过站点，限制打开
                        if (port.sender?.tab?.id) {
                            chrome.tabs.remove(port.sender?.tab?.id)
                            activeTab(port.sender?.tab?.id)
                        }
                        return
                    }
                    front.channel = port;
                    front.channel.onMessage.addListener((port) => {
                        front.onMessage(port)
                    });
                    front.channel.onDisconnect.addListener(() => {
                        front.channel = null;
                    })
                } else if (port.name == "chatbox") {
                    if (front.chatChannel) {
                        //已经打开过站点，限制打开
                        if (port.sender?.tab?.id) {
                            chrome.tabs.remove(port.sender?.tab?.id)
                            activeTab(port.sender?.tab?.id)
                        }
                        return
                    }
                    front.chatChannel = port;
                    front.chatChannel.onMessage.addListener((port) => {
                        front.onMessage(port)
                    });
                    front.chatChannel.onDisconnect.addListener(() => {
                        front.chatChannel = null;
                    })
                } else if (port.name == "ext-profile") {
                    front.extProfileChannel = port;
                    front.extProfileChannel.onMessage.addListener((port) => {
                        front.onMessage(port)
                    });
                    front.extProfileChannel.onDisconnect.addListener(() => {
                        front.extProfileChannel = null;
                    })
                }
                //front channel 连接成功后执行，同步相关的服务
                //同步本地连接的模式，以及状态
                front.broadcast({
                    type: "local-server-mode",
                    data: {
                        status: local.status,
                        serverMode: local.serverMode
                    }
                })
                //同步玩具连接器错误状态
                front.broadcast({
                    type: "toyconnector-has-error",
                    data: ToyConnector.hasError
                })
                //同步usb 状态
                front.broadcast({
                    type: "toyconnector-usb-state",
                    data: ToyConnector.usbState
                })
                //同步蓝牙 状态
                front.broadcast({
                    type: "toyconnector-bluetooth-state",
                    data: ToyConnector.bluetoothState
                })
                //同步玩具连接信息
                // if (ToyConnector.devices?.length > 0 && ToyConnector.devicesFromApp?.length > 0) {
                ToyConnector.broadcastDevices();
                // front.broadcast({
                //     type: "toyconnector-sync-list",
                //     data: ToyConnector.devices,
                // })
                // }
            }
            chrome.runtime.onConnectExternal.addListener(processConnect);
            //同时开始玩具监控
            ToyConnector.watching();
        }
    }
    //#endregion

    //#region Local Server
    const local = {
        async get(interfaceUrl) {
            try {
                const response = await fetch(honey.config.localBaseUrl + interfaceUrl, {
                    method: 'get',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                });
                return response
            } catch (ex) {
                throw ex
            }
        },
        async post(interfaceUrl, data) {
            try {
                const response = await fetch(honey.config.localBaseUrl + interfaceUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: typeof data == "string" ? data : JSON.stringify(data)
                });
                return response
            } catch (ex) {
                throw ex
            }
        },
        async ping(username, isLive, platform, url) {
            var r = await local.get(`/api/v1/pc/platform/${platform}/status?broadcaster=${username}&isLive=${isLive}&livePage=${encodeURIComponent(url || "")}`, {})
            // console.log("ping result", r)
        },
        async event(platform, data) {
            var r = await local.post(`/api/v1/${platform}/postevents`, data)
            console.log("post event result", r)
        },
        async getVersion() {
            if (this.serverVersion) {
                return this.serverVersion;
            }
            var r = await local.get("/api/v1/xvibe/software/info");
            if (r?.ok) {
                var d = await r.json();
                if (d.code == 0) {
                    this.serverVersion = d.data.version;
                    this.clientInfo = d.data;
                }
            }
            return this.serverVersion || ""
        },
        clientInfo: null,
        serverVersion: "",
        status: false,//本地服务的状态，包括连接器，综合服务
        serverMode: "client",//client 为本地客户端，connector 为连接器
        setState(status, serverMode) {
            serverMode = serverMode || "client";
            local.status = status
            local.serverMode = serverMode;
            if (front.channel) {
                front.post({
                    type: "local-server-mode",
                    data: {
                        status: status,
                        serverMode
                    }
                });
            }
        }
    };
    //#endregion

    //#region 监控/信使
    ;
    (function () {
        let mainWindowId = null;
        let pingIntervalId = null; // 全局变量，用于存储定时器 ID
        const cached = {} //缓存已打开的popup窗口
        // 初始化：查找第一个窗口
        chrome.windows.getAll({ populate: false }, (windows) => {
            if (windows.length > 0) {
                mainWindowId = windows[0].id;
                console.log("初始化主窗口 ID:", mainWindowId);
            }
        });

        // 检查窗口是否为聊天框窗口
        function isChatboxWindow(windowId, callback) {
            chrome.windows.get(windowId, { populate: true }, (window) => {
                if (chrome.runtime.lastError || !window) {
                    callback(false);
                    return;
                }
                // 检查窗口类型是否为 panel
                const isPanel = window.type === "panel";
                chrome.tabs.query({ windowId: windowId }, (tabs) => {
                    if (tabs.length > 0 && tabs[0].url) {
                        const url = tabs[0].url;
                        // 判断是否为聊天框窗口的 URL
                        const isChatboxUrl = url && url.startsWith(honey.config.localBaseUrl + "/chatbox");
                        callback(isChatboxUrl || isPanel); // 结合 URL 和 panel 类型
                    } else {
                        // 如果标签页未加载完成，假定是 panel 类型窗口
                        callback(isPanel);
                    }
                });
            });
        }

        async function hasExist(url, windowId) {
            return new Promise((res) => {


                chrome.windows.getAll({ populate: true }, (windows) => {
                    windows = windows.filter(el => {
                        return el.type == "popup"
                    })
                    if (windows.length > 0) {
                        for (var win of windows) {
                            if (win.id == windowId) {
                                continue
                            }
                            for (var t of win.tabs) {
                                if (matchUrl(t.url, url)) {
                                    return res(true);
                                }
                            }
                        }
                    }
                    res(false)
                });
            })
        }

        // 监听窗口创建
        chrome.windows.onCreated.addListener((window) => {
            console.log("新窗口创建，ID:", window.id);
            //如果不是VC 浏览器，则不执行窗口监控操作
            if (!isVCBrowser()) {
                return;
            }
            // 延迟检查窗口，确保标签页加载
            setTimeout(async () => {
                const isPopup = window.type === "popup";
                if (isPopup) {
                    chrome.tabs.query({ windowId: window.id }, async (tabs) => {
                        if (tabs && tabs[0]) {
                            if (existId = await hasExist(tabs[0].url, window.id)) {
                                chrome.windows.remove(window.id, () => {
                                    if (chrome.runtime.lastError) {
                                        console.error("关闭新窗口失败:", chrome.runtime.lastError);
                                    } else {
                                        console.log("新窗口已关闭:", window.id);
                                        // 激活主窗口
                                        chrome.windows.update(existId, { focused: true });
                                    }
                                });
                            }
                        }
                    });
                }

                if (mainWindowId === null) {
                    // 第一个窗口，设置为主窗口
                    mainWindowId = window.id;
                    console.log("设置主窗口 ID:", mainWindowId);
                } else {
                    // 已有主窗口，检查主窗口是否存在
                    chrome.windows.get(mainWindowId, { populate: false }, (mainWindow) => {
                        if (chrome.runtime.lastError || !mainWindow) {
                            // 主窗口已关闭，当前窗口成为主窗口
                            mainWindowId = window.id;
                            console.log("主窗口不存在，新窗口成为主窗口:", mainWindowId);
                        } else if (window.type != "popup") {
                            //type: "popup"
                            // 主窗口存在，关闭非聊天框的新窗口
                            chrome.windows.remove(window.id, () => {
                                if (chrome.runtime.lastError) {
                                    console.error("关闭新窗口失败:", chrome.runtime.lastError);
                                } else {
                                    console.log("新窗口已关闭:", window.id);
                                    // 激活主窗口
                                    chrome.windows.update(mainWindowId, { focused: true });
                                }
                            });
                        }
                    });
                }
            }, 500); // 延迟 500ms 等待标签页加载
        });

        // 监听窗口关闭
        chrome.windows.onRemoved.addListener((windowId) => {
            console.log("窗口关闭，ID:", windowId);
            // 这里我们不需要再次查询所有窗口的数量来判断是否是最后一个
            // chrome.windows.getAll({ populate: false }, (windows) => {
            // 因为如果这个事件触发了，并且没有剩余的非聊天窗口可以作为主窗口，
            // 那么就是最后一个主窗口（或者所有窗口）被关闭。
            // 我们在 sendOnCloseRequest 内部进行延迟判断。
            ext.closeChatBox();
            if (windowId === mainWindowId) {
                // 主窗口关闭，查找第一个非聊天框窗口
                chrome.windows.getAll({ populate: false }, (windows) => {
                    if (windows.length > 0) {
                        let foundNonChatbox = false;
                        const checkNextWindow = (index) => {
                            if (index >= windows.length) {
                                mainWindowId = null;
                                console.log("无非聊天框窗口，主窗口 ID 重置为 null");
                                // 在这里，即使主窗口关闭，如果还有其他窗口，不会立即发送关闭请求
                                // sendOnCloseRequest() 的延迟逻辑会处理最终的关闭判断
                                return;
                            }
                            isChatboxWindow(windows[index].id, (isChatbox) => {
                                if (!isChatbox && !foundNonChatbox) {
                                    mainWindowId = windows[index].id;
                                    console.log("更新主窗口 ID:", mainWindowId);
                                    foundNonChatbox = true;
                                } else {
                                    checkNextWindow(index + 1);
                                }
                            });
                        };
                        checkNextWindow(0);
                    } else {
                        mainWindowId = null;
                        console.log("无窗口，主窗口 ID 重置为 null");
                        console.log("尝试发送关闭事件 (由延迟逻辑处理)");
                        sendOnCloseRequest(); // 调用 sendOnCloseRequest，它会内部判断是否满足5秒条件
                    }
                });
            } else {
                // 如果关闭的不是主窗口，检查是否所有窗口都已关闭
                chrome.windows.getAll({ populate: false }, (windows) => {
                    if (windows.length === 0) {
                        console.log("所有窗口已关闭 (非主窗口关闭后检查)，尝试发送 onclose 请求 (由延迟逻辑处理)。");
                        sendOnCloseRequest(); // 调用 sendOnCloseRequest，它会内部判断是否满足5秒条件
                    }
                });
            }
        });

        /**
         * 发送关闭请求到本地服务器
         */
        function sendOnCloseRequest() {
            const url = honey.config.localBaseUrl + "/api/v1/pc/windows/close";
            fetch(url, {
                method: "GET", // 建议使用 POST 进行关闭操作
            }).then(response => {
                if (response.ok) {
                    console.log("已成功发送 onclose 请求到本地服务器。");
                } else {
                    console.error(`发送 onclose 请求失败，状态码：${response.status}`);
                }
            })
                .catch(error => {
                    console.error("发送 onclose 请求时发生错误:", error);
                });
        }

        /**
         * 发送 ping 请求到本地服务器
         */
        async function pingOnRunningServer() {
            const url = honey.config.localBaseUrl + "/api/v1/pc/windows/onrunning";
            await fetch(url, {
                method: "GET", // ping 操作通常使用 GET
            }).then(async response => {
                if (response.ok) {
                    var j = await response.text();
                    if (j) {
                        j = tryJson(j)
                        if (j && j.serverMode) {
                            local.setState(true, j.serverMode == "local" ? "client" : j.serverMode)
                            return;
                        }
                    }
                    local.setState(true, local.serverMode)
                } else {
                    console.error(`发送 ping 请求失败，状态码：${response.status}`);
                    local.setState(false, local.serverMode)
                }
            }).catch(error => {
                local.setState(false, local.serverMode)
                console.error("发送 ping 请求时发生错误:", error);
                // 如果 ping 失败，并且所有窗口都已关闭，可以考虑停止定时器
                chrome.windows.getAll({ populate: false }, (windows) => {
                    if (windows.length === 0) {
                        console.log("所有窗口已关闭且 ping 失败，停止 ping 定时器。");
                        stopPingTimer();
                    }
                });
            });
        }

        /**
         * 启动唯一的 ping 定时器
         */
        function startPingTimer() {
            // 如果定时器已经存在，先清除它，确保只有一个定时器运行
            if (pingIntervalId !== null) {
                clearInterval(pingIntervalId);
                console.log("已清除现有 ping 定时器。");
            }

            // 立即执行一次 ping
            pingOnRunningServer();

            // 每隔 3 秒执行一次 ping
            pingIntervalId = setInterval(() => {
                pingOnRunningServer();
            }, 2000); // 3000 毫秒 = 3 秒

            // console.log("已启动 ping 定时器。");
        }
        // startPingTimer();
        local.startPingTimer = startPingTimer;

        // ---------------------------------------------------------------
        // 注意：chrome.runtime.onSuspend 事件的异步操作限制
        // ---------------------------------------------------------------
        // 这个事件在浏览器即将关闭或扩展即将卸载/更新时触发。
        // 它是你执行同步清理工作的最后机会。
        // ！！重要：浏览器不会等待在此事件中启动的异步操作（如 fetch 请求）完成。
        // 因此，在此处调用 sendOnCloseRequest 很可能不会成功发送请求。
        // 建议将关键的关闭通知逻辑放在 chrome.windows.onRemoved 中，
        // 因为它在窗口关闭发生时触发，通常有更多时间来处理异步操作。
        // 如果您的本地服务器通知是强制性的，您可能需要考虑在本地应用程序中实现一个心跳机制
        // 或者其他更可靠的通信方式，而不是仅仅依赖浏览器扩展的关闭事件。
        chrome.runtime.onSuspend.addListener(() => {
            // console.log("Extension is suspending (browser is closing or reloading). Attempting to send onclose request (may not complete).");
            // 此处调用 sendOnCloseRequest 仅作为“尽力而为”的尝试，
            // 不保证请求能够成功发送或完成。
            sendOnCloseRequest();
            // 同样，在浏览器即将关闭时，也可以尝试停止 ping 定时器，尽管 service worker 可能会被挂起。
            stopPingTimer();
        });

        // chrome.action.onClicked.addListener((tab) => {
        //     console.log('图标被点击了！');

        //     honey.ext.openChatBox();
        // });
        /**
         * 停止 ping 定时器
         */
        function stopPingTimer() {
            if (pingIntervalId !== null) {
                clearInterval(pingIntervalId);
                pingIntervalId = null;
                console.log("已停止 ping 定时器。");
            }
        }
    })();
    //#endregion


    //#region 插件功能
    ;
    const ext = function () {
        //#region 注入脚本方法

        function isUserScriptsAvailable() {
            try {
                // Property access which throws if developer mode is not enabled.
                chrome.userScripts;
                return !!chrome.userScripts.configureWorld;
            } catch {
                return false;
            }
        }

        async function registerScript(opts) {
            console.log("register script from bg")
            if (!isUserScriptsAvailable()) return;
            if (!opts.id || !opts.urls || (!opts.path && !opts.code)) {
                console.log("")
                return;
            }
            var scriptId = opts.id
            const existingScripts = await chrome.userScripts.getScripts({
                ids: [scriptId]
            });
            let type = opts.type || (opts.path ? "file" : "code"),
                script = opts.code,
                runAt = opts.runAt || "document_start"
                ;
            if (type == "file") {
                if (opts.path && opts.path.startsWith('@')) {
                    script = opts.path.replace("@", "");
                } else {
                    var resp = await fetch(opts.path, {
                        method: "get"
                    });
                    script = await resp.text();
                    type = "code"
                }
            }
            var matches = [];
            if (Array.isArray(opts.urls)) {
                matches = matches.concat(opts.urls)
            } else if (opts.urls) {
                matches.push(opts.urls)
            }
            if (existingScripts && existingScripts.length > 0) {
                // Update existing script.
                await chrome.userScripts.update([
                    {
                        id: scriptId,
                        allFrames: opts.allFrames,
                        matches: matches || [],
                        js: type === 'file' ? [{ file: script }] : [{ code: script }],
                        runAt: runAt
                    }
                ]).then(() => {
                    // console.log('更新成功');
                }).catch(err => console.error('update script faild:', err));;
            } else {
                await chrome.userScripts.register([{  // 关键修改：用数组包裹配置
                    id: scriptId,
                    allFrames: opts.allFrames,
                    matches: matches || [],
                    js: type === 'file' ? [{ file: script }] : [{ code: script }],
                    runAt: runAt
                }]).then(() => {
                    // console.log('注册成功');
                }).catch(err => console.error('register faild:', err));
            }
        }
        async function registerOrUpdateScript(platform, scriptPath = 'file', version = "") {
            if (!isUserScriptsAvailable()) return;
            var scriptId = `honey-uscript-${platform}`
            const existingScripts = await chrome.userScripts.getScripts({
                ids: [scriptId]
            });
            let type = scriptPath, script = `/sites/${platform}.js`
            if (type != "file") {
                var resp = await fetch(scriptPath, {
                    method: "get"
                });
                script = await resp.text();
                type = "code"
            }
            var matches = [];
            if (Array.isArray(honey.config.urls[platform].roomPagePatten)) {
                matches = matches.concat(honey.config.urls[platform].roomPagePatten)
            } else if (honey.config.urls[platform].roomPagePatten) {
                matches.push(honey.config.urls[platform].roomPagePatten)
            }
            if (existingScripts && existingScripts.length > 0) {
                // Update existing script.
                await chrome.userScripts.update([
                    {
                        id: scriptId,
                        matches: matches || [],
                        js: type === 'file' ? [{ file: script }] : [{ code: script }],
                        runAt: "document_start"
                    }
                ]).then(() => {
                    storage(`honey-uscript-${platform}-version`, version)
                }).catch(err => console.error('update faild:', err));;
            } else {
                await chrome.userScripts.register([{  // 关键修改：用数组包裹配置
                    id: scriptId,
                    matches: matches || [],
                    js: type === 'file' ? [{ file: script }] : [{ code: script }],
                    runAt: "document_start"
                }]).then(() => {
                    // console.log('注册成功');
                    storage(`honey-uscript-${platform}-version`, version)
                }).catch(err => console.error('register faild:', err));
            }
        }
        async function checkAndUpdate(platform) {
            var scriptVersion = `honey-uscript-${platform}-version`;
            var version = await getStorage(scriptVersion);
            if (typeof version == "object") {
                version = null
            }
            var checkUpdated = await fetch(`${honey.config.serverBaseUrl}/system/anon/webapp/extensions/script/checkversion`, {
                method: "post",
                headers: { "content-type": "application/json" },
                body: JSON.stringify({
                    version: version || 0,
                    platform: platform
                })
            });
            var checkUpdated = await checkUpdated.json();
            if (checkUpdated && checkUpdated.code == 1000 && checkUpdated.data && checkUpdated.data.path) {

                var scriptFile = checkUpdated.data.path;
                await registerOrUpdateScript(platform, scriptFile, checkUpdated.data.version);
                //本地注册 环境切换
                // await registerOrUpdateScript(platform, "file", checkUpdated.data.version);
            }
        }
        async function checkAllPlatformUpdate(params) {
            var platforms = await fetch(`${honey.config.serverBaseUrl}/system/anon/webapp/extensions/script/platforms`, {
                method: "post",
                headers: { "content-type": "application/json" }
            });
            platforms = await platforms.json();
            if (platforms && platforms.code == 1000 && platforms.data && platforms.data.length) {
                for (var platform of platforms.data) {
                    //检查更新
                    // console.log("check updating", platform)
                    await checkAndUpdate(platform.code)
                }
            }
        }
        function openUrl(url) {
            chrome.tabs.create({
                url: url
            })
        }
        function openExtPage(url) {
            chrome.tabs.create({
                url: chrome.runtime.getURL(url)
            })
        }

        async function openPopup(data) {
            data.type = "popup";
            if (data.repeat) {
                await createWindow(data);
                console.log("open popup success", data)
            } else {
                if (!await existUrlOnAllWindow(data)) {
                    await createWindow(data);
                    console.log("open popup success", data)
                }
            }
        }

        async function openChatBox() {
            var win = await getWindowByUrl(honey.config.pages.chatbox);
            if (!win) {
                createWindow(honey.config.pages.chatbox);
            }
            else {
                chrome.windows.update(win.id, { focused: true });
            }
        }

        async function openProfile(params) {
            if (!honey.config.pages.profile) {
                return;
            }
            var win = await getWindowByUrl(honey.config.pages.profile);
            if (!win) {
                createWindow(honey.config.pages.profile);
            }
            else {
                chrome.windows.update(win.id, { focused: true });
            }
        }

        async function closeChatBox() {
            if (!honey.config?.pages?.chatbox) {
                return;
            }
            var win = await getWindowByUrl(honey.config.pages.chatbox);
            if (win)
                chrome.windows.remove(win.id)
        }

        function restartApp() {
            // 获取所有窗口
            chrome.windows.getAll({}, (windows) => {
                // 遍历并关闭每个窗口
                windows.forEach(window => {
                    chrome.windows.remove(window.id, () => {
                        // 关闭成功后的回调（可选）
                        console.log(`窗口 ${window.id} 已关闭`);
                    });
                });
            });
        }

        const ext = {
            checkAllPlatformUpdate,
            registerOrUpdateScript,
            registerScript,
            checkAndUpdate,
            openUrl,
            restartApp,
            openExtPage,
            openPopup,
            openChatBox,
            closeChatBox,
            openProfile,
            /**
             * 监控插件刷新
             * @returns 
             */
            async checkAndReload(callback) {
                try {
                    const LOCAL_RELOAD_STATUS_URL = `${honey.config.localBaseUrl}/api/v1/pc/broswer-plugin/reload`;
                    console.log(`[插件刷新] 插件启动`);
                    // 向本地服务器发送 GET 请求
                    const response = await fetch(LOCAL_RELOAD_STATUS_URL, { cache: "no-store" }); // 禁用缓存
                    if (!response.ok) {
                        console.warn(`[插件刷新] 查询本地服务器请求失败，状态码: ${response.status}`);
                        if (callback)
                            callback();
                        return; // 请求失败，不执行刷新
                    }
                    const data = await response.json();
                    if (data && typeof data.status === 'number') {
                        if (data.status === 0) {
                            // 服务器返回 status: 0 表示需要刷新
                            console.log(`[插件刷新] 本地服务器指示需要刷新。立即重新加载插件...`);
                            chrome.runtime.reload();
                            // 再次强调：这里会立刻触发 reload。
                            // 你的本地服务器必须在收到此插件的部署完成通知后，迅速将状态从 0 切换到 1，
                            // 否则插件重新加载后，如果仍是旧 background.js，会再次查询到 0 导致无限循环。
                        } else if (data.status === 1) {
                            // 服务器返回 status: 1 表示已刷新，无需操作
                            console.log("[插件刷新] 本地服务器指示插件已是最新状态，无需刷新。");
                            if (callback)
                                callback();
                        } else {
                            console.warn("[插件刷新] 本地服务器返回的 status 值不明确 (非 0 或 1):", data.status);
                            if (callback)
                                callback();
                        }
                    } else {
                        console.warn("[插件刷新] 本地服务器返回数据格式不符合预期 (缺少 'status' 字段或类型错误):", data);
                        if (callback)
                            callback();
                    }
                } catch (error) {
                    console.error(`[插件刷新] 查询本地服务器或处理响应失败: ${error}`);
                    if (callback)
                        callback();
                    // 任何错误都阻止自动刷新，避免死循环或错误行为
                }
            },
            refreshAllTabs() {
                chrome.tabs.query({}, (tabs) => {
                    if (tabs.length === 0) {
                        console.log("没有活动标签页，无需刷新");
                        return;
                    }
                    tabs.forEach((tab) => {
                        // 排除 Chrome 内部页面（如 chrome:// 开头的页面）
                        if (tab.url && !tab.url.startsWith("chrome://")) {
                            chrome.tabs.reload(tab.id, { bypassCache: true }, () => {
                                if (chrome.runtime.lastError) {
                                    console.error("刷新标签页失败:", tab.id, chrome.runtime.lastError);
                                } else {
                                    console.log("已刷新标签页:", tab.id, tab.url);
                                }
                            });
                        } else {
                            console.log("跳过 Chrome 内部页面:", tab.url);
                        }
                    });
                });
            },
            refreshPlatformTabs() {
                try {
                    var urls = []
                    for (var i of Object.keys(honey.config.platform)) {
                        // urls.push(honey.config.urls[i].roomPagePatten)
                        if (Array.isArray(honey.config.urls[i].roomPagePatten)) {
                            urls.push(...honey.config.urls[i].roomPagePatten)
                        } else {
                            urls.push(honey.config.urls[i].roomPagePatten)
                        }
                    }
                    chrome.tabs.query({ url: urls }, (tabs) => {
                        tabs.forEach((tab) => {
                            chrome.tabs.reload(tab.id, { bypassCache: true }, () => {
                                if (chrome.runtime.lastError) {
                                    console.error("刷新标签页失败:", tab.id, chrome.runtime.lastError);
                                } else {
                                    console.log("已刷新标签页:", tab.id, tab.url);
                                }
                            });
                        });
                    })
                } catch (ex) {

                }
            },
            refreshFrontPage() {
                try {
                    var urls = []
                    if (honey.config.frontUrlPattern) {
                        urls.push(...honey.config.frontUrlPattern)
                    }
                    chrome.tabs.query({
                        url: urls,
                        // windowTypes: ["normal", "popup", "panel"], // 包含所有可能的窗口类型
                        // populate: true
                    }, (tabs) => {
                        if (!tabs) {
                            return;
                        }
                        tabs.forEach((tab) => {
                            chrome.tabs.reload(tab.id, { bypassCache: true }, () => {
                                if (chrome.runtime.lastError) {
                                    console.error("刷新标签页失败:", tab.id, chrome.runtime.lastError);
                                } else {
                                    console.log("已刷新标签页:", tab.id, tab.url);
                                }
                            });
                        });
                    })
                } catch (ex) {

                }
            }
        };

        ext.isUserScriptsAvailable = false;
        if (isUserScriptsAvailable()) {
            ext.isUserScriptsAvailable = true;
            try {
                chrome.userScripts.configureWorld({
                    messaging: true
                });
            } catch (ex) {
                console.log("configureWorld failed:", ex);
            }
        }
        return ext;
        //#endregion
    }();
    //#endregion

    //#region offscreen
    const offscreen = function () {
        let creating; // 全局promise，用于避免并发问题

        async function setupOffscreenDocument() {
            var path = "/pages/background.html";
            // 检查服务工作者控制的所有窗口，看是否有一个是给定路径的屏幕外文档
            const offScreenUrl = chrome.runtime.getURL(path);
            const existingContexts = await chrome.runtime.getContexts({
                contextTypes: [chrome.runtime.ContextType.OFFSCREEN_DOCUMENT],
                documentUrls: [offScreenUrl]
            });
            if (existingContexts && existingContexts.length > 0) {
                return;
            }
            // 创建屏幕外文档
            if (creating) {
                await creating;
            } else {
                creating = chrome.offscreen.createDocument({
                    url: path,
                    reasons: ['WORKERS'],
                    justification: 'reason for needing the document'
                });
                await creating;
                creating = null;
            }
        }
        let offscreenLoaded = false
        function onMessage(msg, sender, response) {
            const { type, data } = msg;
            if (type == "offscreen-document-loaded") {
                offscreenLoaded = true;
                //同步配置
                honey.sync(msg.data?.config || {});
                honey.syncConstains(msg.data?.constrains || {});
                chrome.runtime.onMessage.removeListener(onMessage);
            }
        }

        async function listen(callback) {
            chrome.runtime.onMessage.addListener(onMessage);
            async function processConnect(port) {
                // console.log("======>offscreen  connected:", port.name);
                if (port.name != "offscreen-iframe") {
                    return;
                }
                offscreen.channel = port;
                offscreen.channel.onMessage.addListener((port) => {
                    const { type, data, platform, requestId, name } = port
                    if (type == "living-mobile-change") {
                        front.post("living-mobile-change", data);
                    }
                    else if (type == "user-logout") {
                        front.logoutFromWebsocket()
                    } else if (type == "User-Scripts-Register") {
                        ext.registerScript(data);
                    } else if (type == "toyconnector-sync-list") {
                        //同步玩具列表
                        ToyConnector.syncDevicesFromApp(data.devices)
                    } else if (type == "Transfer-To-Monitor") {
                        //同步已连接的玩具
                        MonitorServer.notify({
                            type: data.target,
                            data: data.data,
                            platform: data.platform,
                            requestId: requestId,
                        });
                    } else if (type == "Transfer-To-Monitor-Sync") {
                        //同步已连接的玩具
                        MonitorServer.notifySync({
                            type: data.target,
                            data: data.data,
                            platform: data.platform,
                            requestId: requestId,
                        }).then((res) => {
                            callback({
                                type: type + "_callback",
                                data: res,
                                platform: platform,
                                requestId: requestId,
                            })
                        });
                    } else if (type == "Transfer-To-Platform") {
                        Connector.get(platform)?.post({
                            type: data.target,
                            data: data.data,
                            platform: platform,
                            requestId: requestId
                        })
                    } else if (type == "Transfer-To-Platform-All") {
                        Connector.broadcast({
                            type: data.target,
                            data: data.data,
                            platform: platform,
                            requestId: requestId
                        })
                    } else if (type == "Transfer-To-Platform-sync") {
                        Connector.get(platform)?.postSync({
                            type: data.target,
                            data: data.data,
                            platform: platform,
                            requestId: requestId
                        })
                    }

                });
                //同步token给offscreen
                port.postMessage({
                    type: "sync-user-token",
                    data: {
                        token: await honey.front.getToken(),
                    },
                    requestId: "offscreen" + new Date().valueOf(),
                })
                chrome.runtime.onConnect.removeListener(processConnect);
            }
            chrome.runtime.onConnectExternal.addListener(processConnect);
            chrome.runtime.onConnect.addListener(processConnect);
            for (; ;) {
                await sleep(300);
                if (offscreenLoaded) {
                    break;
                }
            }
            callback();
        }

        async function setup(callback) {
            listen(callback)
            //安装屏幕外的文档
            await setupOffscreenDocument()
        }
        function hasConnected() {
            return !!offscreen.channel;
        }
        async function transferConnect(type, data, platform, requestId) {
            if (!hasConnected()) {
                return;
            }
            offscreen.channel.postMessage({
                type,
                data: data,
                platform: platform,
                requestId,
            })
        }
        function sendMessage(type, data) {
            chrome.runtime.sendMessage({
                type,
                ...data
            })
        }
        function post(type, data) {
            if (!hasConnected()) {
                return;
            }
            var reqId = "offscreen-" + new Date().valueOf();
            offscreen.channel.postMessage({
                type,
                data: data,
                requestId: reqId,
            })
        }
        async function sendMessageSync(type, data, timeout) {
            if (!hasConnected()) {
                return Promise.resolve();
            }
            const reqId = "offscreen-" + new Date().valueOf()
            return new Promise((res, rej) => {
                function handleMessage(msg) {
                    console.log('收到消息:', msg);
                    if (msg.type == type + "-callback" && msg.requestId && msg.requestId == reqId) {
                        // 处理消息...
                        offscreen.channel.onMessage.removeListener(handleMessage);
                        const { ok, data, message } = msg;
                        if (ok) {
                            res(data)
                        } else {
                            rej(message)
                        }
                    }
                }

                if (timeout) {
                    setTimeout(() => {
                        offscreen.channel.onMessage.removeListener(handleMessage);
                        rej("timeout")
                    }, timeout);
                }
                offscreen.channel.onMessage.addListener(handleMessage);
                offscreen.channel.postMessage({
                    type,
                    data: data,
                    requestId: reqId,
                })
                // function sync(msg, sender, response) {
                //     const { type, data, requestId } = msg;
                //     if (type == honey.c.response && requestId == reqId) {
                //         chrome.runtime.onMessageExternal.removeListener(sync)
                //         res(data)
                //     }
                // }
                // chrome.runtime.onMessageExternal.addListener(sync)
                // offscreen.channel.postMessage({
                //     type,
                //     data: data,
                //     requestId: reqId,
                // })
            })
        }

        return {
            setup,
            post,
            hasConnected,
            transferConnect,
            sendMessageSync,
            sendMessage
        }
    }();

    //#endregion

    //#region profile 
    ;
    const profile = function () {
        let channel = null;
        chrome.runtime.onConnectExternal.addListener(port => {
            console.log("profile  connected:", port.name);
            if (port.name != "profile-iframe") {
                return;
            }
            channel = port;
        });
        function hasConnected() {
            return !!channel;
        }
        async function transferConnect(type, data, platform, requestId) {
            if (!hasConnected()) {
                return;
            }
            channel.postMessage({
                type,
                data: data,
                platform: platform,
                requestId,
            })
        }
        function sendMessage(type, data) {
            chrome.runtime.sendMessage({
                type,
                ...data
            })
        }
        async function sendMessageSync(type, data) {
            if (!hasConnected()) {
                return;
            }
            const reqId = "profile-" + new Date().valueOf()
            return new Promise((res, rej) => {
                function sync(msg, sender, response) {
                    // const { type, data, requestId } = msg;
                    if (msg.type == type + "—callback" && msg.requestId == reqId) {
                        chrome.runtime.onMessageExternal.removeListener(sync)
                        res(data)
                    }
                }
                chrome.runtime.onMessageExternal.addListener(sync)
                channel.postMessage({
                    type,
                    data: data,
                    requestId: reqId,
                })
            })
        }
        return {
            hasConnected, sendMessage, sendMessageSync, transferConnect
        }
    }();

    //#endregion

    //#region 防睡眠
    const wakeLock = function () {
        let wakeLock = null;
        const keepAlive = () => {
            try {
                chrome.power.requestKeepAwake('display')
            } catch (ex) {
            }
        }
        const keepBackgroundWork = () => {
            chrome.alarms.create('keepAlive', { periodInMinutes: 1 });
            let alarmIndex = 0;
            chrome.alarms.onAlarm.addListener((alarm) => {
                if (alarm.name === 'keepAlive') {
                    console.log('Extension is still running', alarmIndex++);
                    // 执行你的任务
                }
            });
        }
        return {
            keepAlive,
            keepBackgroundWork
        }
    }();
    //#endregion

    //#region  Track User Behavior
    const Track = function () {
        function formatDate(date) {
            // 处理参数：支持传入时间戳、日期字符串或Date对象，默认当前时间
            date = date ? (date instanceof Date ? date : new Date(date)) : new Date();
            // 获取各部分时间，不足两位补0
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0'); // 月份从0开始，需+1
            const day = String(date.getDate()).padStart(2, '0');
            const hours = String(date.getHours()).padStart(2, '0');
            const minutes = String(date.getMinutes()).padStart(2, '0');
            const seconds = String(date.getSeconds()).padStart(2, '0');

            // 返回 "年-月-日 时:分:秒" 格式
            return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
        }
        function getBrowserType() {
            if (isVCBrowser()) {
                return "VibeConnect"
            }
            const userAgent = navigator.userAgent;
            // 判断 Edge（优先，因为 Edge 也包含 Chrome 标识）
            if (userAgent.includes('Edg/')) {
                return 'Edge';
            }
            // 判断 Chrome（排除 Edge 后）
            if (userAgent.includes('Chrome/')) {
                return 'Chrome';
            }
            // 判断 Safari（排除 Chrome/Edge 后，包含 Safari 标识）
            if (userAgent.includes('Safari/')) {
                return 'Safari';
            }
            // 其他浏览器
            return '';
        }
        function getOSInfo() {
            const ua = navigator.userAgent.toLowerCase();
            let os = "Unknown";
            let version = "Unknown";

            // 1. 判断 Windows
            if (ua.includes("windows nt")) {
                os = "Windows";
                const ntVersion = ua.match(/windows nt (\d+\.\d+)/)[1];
                // NT 版本对应 Windows 实际版本
                const ntMap = {
                    "5.0": "2000",
                    "5.1": "XP",
                    "6.0": "Vista",
                    "6.1": "7",
                    "6.2": "8",
                    "6.3": "8.1",
                    "10.0": "10/11" // Win10 和 Win11 的 UA 均为 NT 10.0，需额外判断
                };
                version = ntMap[ntVersion] || ntVersion;
            }

            // 2. 判断 macOS
            else if (ua.includes("mac os x")) {
                os = "macOS";
                const verMatch = ua.match(/mac os x (\d+_\d+(_\d+)?)/);
                if (verMatch) {
                    version = verMatch[1].replace(/_/g, "."); // 13_5 → 13.5
                }
            }

            // 3. 判断 iOS（基于设备标识）
            else if (ua.includes("iphone") || ua.includes("ipad")) {
                os = ua.includes("iphone") ? "iOS (iPhone)" : "iOS (iPad)";
                const verMatch = ua.match(/os (\d+_\d+(_\d+)?) like mac os x/);
                if (verMatch) {
                    version = verMatch[1].replace(/_/g, ".");
                }
            }

            // 4. 判断 Android
            else if (ua.includes("android")) {
                os = "Android";
                const verMatch = ua.match(/android (\d+\.\d+(\.\d+)?)/);
                if (verMatch) {
                    version = verMatch[1];
                }
            }

            // 5. 判断 Linux
            else if (ua.includes("linux")) {
                os = "Linux";
                // 提取发行版（如 Ubuntu、CentOS）
                if (ua.includes("ubuntu")) version = "Ubuntu";
                else if (ua.includes("centos")) version = "CentOS";
                else if (ua.includes("debian")) version = "Debian";
            }

            return { os, version };
        }
        // 内容脚本中获取语言
        function getBrowserLanguages() {
            // 首选语言
            const primaryLanguage = navigator.language;

            // 所有语言偏好（数组）
            const allLanguages = navigator.languages || [primaryLanguage]; // 兼容旧浏览器

            return {
                primary: primaryLanguage,
                all: allLanguages
            };
        }
        const OS = getOSInfo() || {}
        Object.assign(OS, getBrowserLanguages() || {});
        function track(action, tag) {
            var date = new Date();
            try {
                api("@server/system/track/user/behavior/action", "post", {
                    client: "vibeconnect-Web Extensions",
                    clientType: "pc",
                    lang: OS.primary,
                    os: OS.os,
                    version: honey.version,
                    osVersion: getOSInfo()?.version,
                    obsVersion: "",
                    extVersion: "",
                    localTime: formatDate(date),
                    action,
                    tag,
                    browserType: getBrowserType() || "",
                    isConnector: false,
                    osType: "",
                });
            } catch (ex) {
                console.log(`error`, ex);
            }
        }
        return {
            track,
            OS
        }
    }();
    //#endregion

    //#region 监控插件安装时间/刷新
    chrome.runtime.onInstalled.addListener((details) => {
        console.log("插件加载", details)
        if (details.reason === "install") {
            console.log("安装")
            // chrome.runtime.skipWaiting().then(() => {
            //     console.log("刷新组件")
            //     // 激活后强制扩展重载，确保所有组件（内容脚本、页面）使用新版本
            //     chrome.runtime.reload();
            // });
        } else if (details.reason === "update") {
            console.log("插件刷新")
            // 插件更新时，刷新所有平台已打开的tab页
            honey.ext.refreshFrontPage();
        }
        Track.track("install", "");
    });
    //#endregion
    honey.local = local;
    honey.front = front;
    honey.offscreen = offscreen;
    honey.ext = ext;

    //先检查更新
    // honey.ext.checkAndReload(function () {
    //安装offscreen
    honey.offscreen.setup(async function () {
        await wakeLock.keepAlive();
        wakeLock.keepBackgroundWork();

        front.listen()
        local.startPingTimer();
        honey.ext.checkAllPlatformUpdate().finally(() => {
            //刷新所有平台已打开的tab页
            honey.ext.refreshPlatformTabs();
        });
        honey.ext.refreshFrontPage();

    });
    // })
})();

