
(function () {
    let hasLoaded = false;
    window.addEventListener("message", (e) => {
        const data = e.data;
        const { from, type, } = data;
        // console.log("message evt", from, type, data, e)
        if (type == "loaded") {
            chrome.runtime.sendMessage({
                type: "profile-document-loaded", data: {}
            }, (resp) => { })
            const extensionId = chrome.runtime.id;
            console.log("extensions id", extensionId)
            iframe.contentWindow?.postMessage({
                type: "Extenisions",
                platform: "profile",
                data: {
                    id: extensionId
                }
            }, "*");
            console.log("post message", extensionId)
        }
        else if (type == "update-window-size") {
            let _data = data.data
            if (_data.width) {
                document.body.style.width = _data.width + 'px';
            }
            if (_data.height) {
                document.body.style.height = _data.height + 'px';
            }
        }
        else if (type == "update-pop-isActive") {
            let _data = data.data
            chrome.runtime.sendMessage({ status: _data.isActivePop })
        } 
        else if (type == 'close-pop') {
            window.close();
        }
    })
 
    async function runtimeOnMessageHandler(request, sender, sendResponse) {
        const { type, platform, data } = request;
        switch (type) {
            case "To-Profile":
                iframe.contentWindow?.postMessage({
                    type,
                    platform,
                    data
                });
                sendResponse({ success: true })
                break;
        }
    }

    chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
        if (msg.type === 'close-popup') {
            chrome.tabs.query({}, function (tabs) {
                const loginUrl = msg.baseUrl;
                const tabsToReload = [];
                let loginTabs = [];

                for (let tab of tabs) {
                    if (tab.url && tab.url.includes(msg.baseUrl)) {
                        tabsToReload.push(tab.id);
                        loginTabs.push(tab);
                    }
                    if (tab.url && tab.url.includes(loginUrl)) {
                        // loginTabs.push(tab);
                    }
                }

                for (let tabId of tabsToReload) {
                    chrome.tabs.update(tabId, { url: loginUrl });
                }

                if (loginTabs.length > 0) {
                    const mainLoginTab = loginTabs[0];
                    for (let i = 1; i < loginTabs.length; i++) {
                        chrome.tabs.remove(loginTabs[i].id);
                    }
                    chrome.tabs.update(mainLoginTab.id, { active: true });
                    chrome.windows.update(mainLoginTab.windowId, { focused: true });
                } else {
                    chrome.tabs.create({ url: loginUrl });
                }

                window.close();
            });
        }
        else if (msg.type === 'close-popup-only') {
            window.close();
        }
    });

    window.onload = function() {
        setTimeout(function() {
            const iframe = document.createElement('iframe');
            iframe.id = 'popupIframe';
            iframe.setAttribute('frameborder', 'no');
            iframe.setAttribute('allowfullscreen', '0');
            iframe.setAttribute('width', '100%');
            iframe.setAttribute('height', '100%');
            iframe.src = "https://app.vibe-connect.net/ext/profile?no-store=" + new Date().valueOf();
            // 环境切换
            // iframe.src = "http://localhost:5173/ext/profile?no-store=" + Date.now();

            iframe.addEventListener('load', () => {
                if (hasLoaded) {
                    return;
                }
                
                chrome.runtime.onMessage.addListener(runtimeOnMessageHandler);
                hasLoaded = true;
                
                const loadingOverlay = document.getElementById('loadingOverlay');
                if (loadingOverlay) {
                    loadingOverlay.classList.add('fade-out');
                    setTimeout(() => {
                        loadingOverlay.style.display = 'none';
                    }, 500);
                }
                
                iframe.classList.add('loaded');
            });

            const container = document.querySelector('.popup-container');
            if (container) {
                container.appendChild(iframe);
            }
        }, 100);
    }
})();